/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.fxapp;

import com.panopset.compat.LogDisplayer;
import com.panopset.compat.Logz;
import com.panopset.compat.StringFunKt;
import com.panopset.fxapp.Anchor;
import com.panopset.fxapp.PanApplication;
import java.io.File;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u000bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\u001dH\u0016J\b\u0010%\u001a\u00020\"H\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/panopset/fxapp/FxDoc;", "Lcom/panopset/fxapp/Anchor;", "Lcom/panopset/compat/LogDisplayer;", "panApplication", "Lcom/panopset/fxapp/PanApplication;", "stage", "Ljavafx/stage/Stage;", "file", "Ljava/io/File;", "<init>", "(Lcom/panopset/fxapp/PanApplication;Ljavafx/stage/Stage;Ljava/io/File;)V", "(Lcom/panopset/fxapp/PanApplication;Ljavafx/stage/Stage;)V", "getStage", "()Ljavafx/stage/Stage;", "menuBarStatusMessage", "Ljavafx/scene/control/TextField;", "getMenuBarStatusMessage", "()Ljavafx/scene/control/TextField;", "setMenuBarStatusMessage", "(Ljavafx/scene/control/TextField;)V", "scene", "Ljavafx/scene/Scene;", "getScene", "()Ljavafx/scene/Scene;", "setScene", "(Ljavafx/scene/Scene;)V", "closingSaveComplete", "", "updateTitle", "", "closeWindow", "saveWindow", "dspmsg", "msg", "", "warn", "clear", "getPriorMessage", "green", "errorMsg", "throwable", "", "errorEx", "debug", "fxapp"})
public final class FxDoc
extends Anchor
implements LogDisplayer {
    @NotNull
    private final Stage stage;
    public TextField menuBarStatusMessage;
    public Scene scene;
    private boolean closingSaveComplete;

    @NotNull
    public final Stage getStage() {
        return this.stage;
    }

    @NotNull
    public final TextField getMenuBarStatusMessage() {
        TextField textField = this.menuBarStatusMessage;
        if (textField != null) {
            return textField;
        }
        Intrinsics.throwUninitializedPropertyAccessException("menuBarStatusMessage");
        return null;
    }

    public final void setMenuBarStatusMessage(@NotNull TextField textField) {
        Intrinsics.checkNotNullParameter(textField, "<set-?>");
        this.menuBarStatusMessage = textField;
    }

    @NotNull
    public final Scene getScene() {
        Scene scene = this.scene;
        if (scene != null) {
            return scene;
        }
        Intrinsics.throwUninitializedPropertyAccessException("scene");
        return null;
    }

    public final void setScene(@NotNull Scene scene) {
        Intrinsics.checkNotNullParameter(scene, "<set-?>");
        this.scene = scene;
    }

    public FxDoc(@NotNull PanApplication panApplication, @NotNull Stage stage, @NotNull File file) {
        Intrinsics.checkNotNullParameter(panApplication, "panApplication");
        Intrinsics.checkNotNullParameter(stage, "stage");
        Intrinsics.checkNotNullParameter(file, "file");
        super(panApplication, file);
        this.stage = stage;
    }

    public FxDoc(@NotNull PanApplication panApplication, @NotNull Stage stage) {
        Intrinsics.checkNotNullParameter(panApplication, "panApplication");
        Intrinsics.checkNotNullParameter(stage, "stage");
        super(panApplication);
        this.stage = stage;
    }

    @Override
    public void updateTitle() {
        this.stage.setTitle(this.createWindowTitle());
    }

    public final void closeWindow() {
        this.saveWindow();
        this.closingSaveComplete = true;
        try {
            this.stage.close();
        }
        catch (Exception e) {
            Logz.INSTANCE.errorEx(e);
        }
    }

    public final void saveWindow() {
        if (this.closingSaveComplete) {
            return;
        }
        String[] stringArray = new String[]{String.valueOf(this.stage.getX()), String.valueOf(this.stage.getY()), String.valueOf(this.stage.getWidth()), String.valueOf(this.stage.getHeight())};
        this.getPmf().put("windowDims", StringFunKt.combineDelim("|", stringArray));
        this.saveDataToFile();
    }

    @Override
    public void dspmsg(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.getMenuBarStatusMessage().setStyle("-fx-text-fill: green;");
        this.getMenuBarStatusMessage().setText(msg);
    }

    @Override
    public void warn(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.dspmsg(msg);
    }

    @Override
    public void clear() {
        this.dspmsg("");
    }

    @Override
    @NotNull
    public String getPriorMessage() {
        String string = this.getMenuBarStatusMessage().getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        return string;
    }

    @Override
    public void green(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.dspmsg(msg);
    }

    @Override
    public void errorMsg(@NotNull String msg, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        this.getMenuBarStatusMessage().setStyle("-fx-text-fill: red;");
        this.getMenuBarStatusMessage().setText(msg);
    }

    @Override
    public void errorMsg(@NotNull String msg, @NotNull File file) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(file, "file");
        this.getMenuBarStatusMessage().setStyle("-fx-text-fill: red;");
        this.getMenuBarStatusMessage().setText(msg + ",\n" + file.getAbsolutePath());
    }

    @Override
    public void errorMsg(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.getMenuBarStatusMessage().setStyle("-fx-text-fill: red;");
        this.getMenuBarStatusMessage().setText(msg);
    }

    @Override
    public void errorMsg(@NotNull File file, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        this.getMenuBarStatusMessage().setStyle("-fx-text-fill: red;");
        this.getMenuBarStatusMessage().setText(throwable.getMessage() + ",\n" + file.getAbsolutePath());
    }

    @Override
    public void errorEx(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        this.getMenuBarStatusMessage().setStyle("-fx-text-fill: red;");
        this.getMenuBarStatusMessage().setText(String.valueOf(throwable.getMessage()));
    }

    @Override
    public void debug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.dspmsg(msg);
    }
}

