/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Logz;
import com.panopset.flywheel.Command;
import com.panopset.flywheel.CommandFile;
import com.panopset.flywheel.CommandMatcher;
import com.panopset.flywheel.Flywheel;
import com.panopset.flywheel.FlywheelException;
import com.panopset.flywheel.ImpliedQuitFilter;
import com.panopset.flywheel.LineFeedRules;
import com.panopset.flywheel.RawCommandLoader;
import com.panopset.flywheel.RawCommandLoaderKt;
import com.panopset.flywheel.SourceFile;
import com.panopset.flywheel.TemplateFile;
import com.panopset.flywheel.TemplateKt;
import com.panopset.flywheel.TemplateSource;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\fJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u001fJ\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006\u0002"}, d2={"Lcom/panopset/flywheel/Template;", "", "flywheel", "Lcom/panopset/flywheel/Flywheel;", "templateSource", "Lcom/panopset/flywheel/TemplateSource;", "templateRules", "Lcom/panopset/flywheel/LineFeedRules;", "<init>", "(Lcom/panopset/flywheel/Flywheel;Lcom/panopset/flywheel/TemplateSource;Lcom/panopset/flywheel/LineFeedRules;)V", "sourceFile", "Lcom/panopset/flywheel/SourceFile;", "(Lcom/panopset/flywheel/Flywheel;Lcom/panopset/flywheel/SourceFile;Lcom/panopset/flywheel/LineFeedRules;)V", "getFlywheel", "()Lcom/panopset/flywheel/Flywheel;", "getTemplateSource", "()Lcom/panopset/flywheel/TemplateSource;", "getTemplateRules", "()Lcom/panopset/flywheel/LineFeedRules;", "sf", "commandFile", "Lcom/panopset/flywheel/CommandFile;", "getCommandFile", "()Lcom/panopset/flywheel/CommandFile;", "setCommandFile", "(Lcom/panopset/flywheel/CommandFile;)V", "rawCommands", "", "Lcom/panopset/flywheel/Command;", "topCommands", "exec", "", "sw", "Ljava/io/StringWriter;", "output", "stop", "msg", "", "relativePath", "getRelativePath", "()Ljava/lang/String;"})
public final class Template {
    @NotNull
    private final Flywheel flywheel;
    @NotNull
    private final TemplateSource templateSource;
    @NotNull
    private final LineFeedRules templateRules;
    @Nullable
    private SourceFile sf;
    @Nullable
    private CommandFile commandFile;
    @NotNull
    private final List<Command> rawCommands;
    @NotNull
    private final List<Command> topCommands;

    public Template(@NotNull Flywheel flywheel2, @NotNull TemplateSource templateSource, @NotNull LineFeedRules templateRules) {
        Intrinsics.checkNotNullParameter(flywheel2, "flywheel");
        Intrinsics.checkNotNullParameter(templateSource, "templateSource");
        Intrinsics.checkNotNullParameter(templateRules, "templateRules");
        this.flywheel = flywheel2;
        this.templateSource = templateSource;
        this.templateRules = templateRules;
        this.rawCommands = new RawCommandLoader(this).load();
        RawCommandLoaderKt.addStructure(this.rawCommands);
        List<Command> commands = new ImpliedQuitFilter().addImpliedQuits(this.rawCommands);
        System.out.println((Object)"************************************************************");
        System.out.println((Object)"============================================================");
        System.out.println((Object)("Template name: " + this.templateSource.getName()));
        TemplateKt.printTemplateStructure(commands);
        this.topCommands = CommandMatcher.INSTANCE.matchQuitCommands(commands);
        System.out.println((Object)"****** Command Structure: **********************************");
        TemplateKt.printTemplateStructure(this.topCommands);
        System.out.println((Object)"============================================================");
        System.out.println((Object)"************************************************************");
    }

    @NotNull
    public final Flywheel getFlywheel() {
        return this.flywheel;
    }

    @NotNull
    public final TemplateSource getTemplateSource() {
        return this.templateSource;
    }

    @NotNull
    public final LineFeedRules getTemplateRules() {
        return this.templateRules;
    }

    public Template(@NotNull Flywheel flywheel2, @NotNull SourceFile sourceFile, @NotNull LineFeedRules templateRules) {
        Intrinsics.checkNotNullParameter(flywheel2, "flywheel");
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        Intrinsics.checkNotNullParameter(templateRules, "templateRules");
        this(flywheel2, new TemplateFile(sourceFile.getFile()), templateRules);
    }

    @Nullable
    public final CommandFile getCommandFile() {
        return this.commandFile;
    }

    public final void setCommandFile(@Nullable CommandFile commandFile) {
        this.commandFile = commandFile;
    }

    public final void exec(@NotNull StringWriter sw) {
        Intrinsics.checkNotNullParameter(sw, "sw");
        List<Command> list = this.topCommands;
        for (Command topCommand : list) {
            if (this.flywheel.isStopped()) {
                return;
            }
            try {
                topCommand.resolve(sw);
            }
            catch (FlywheelException e) {
                Logz.INSTANCE.errorEx(e);
                Logz.INSTANCE.warn("Relative path: " + this.getRelativePath());
                String string = e.getMessage();
                if (string == null) {
                    string = "Unexpected error, if your pull request is accepted, we'll send you 1000 currently worthless Panopset shares.";
                }
                this.flywheel.stop(string);
                return;
            }
        }
    }

    public final void output() {
        List<Command> list = this.topCommands;
        try {
            for (Command topCommand : list) {
                topCommand.resolveCommand(this.flywheel.getWriter());
            }
        }
        catch (FlywheelException t) {
            Logz.INSTANCE.errorEx(t);
            String string = t.getMessage();
            if (string == null) {
                string = "Unexpected error, if your pull request is accepted, we'll send you 1000 currently worthless Panopset shares.";
            }
            this.stop(string);
        }
    }

    private final void stop(String msg) {
        String string = "Stopped while processing line %d: %s.";
        Object[] objectArray = new Object[]{this.templateSource.getLine(), this.templateSource.getName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        Logz.INSTANCE.errorMsg(string2);
        this.flywheel.stop(msg);
    }

    @NotNull
    public final String getRelativePath() {
        Object object = this.sf;
        if (object == null || (object = ((SourceFile)object).getRelativePath()) == null) {
            object = "";
        }
        return object;
    }
}

