/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Fileop;
import com.panopset.compat.Logz;
import com.panopset.compat.Nls;
import com.panopset.compat.Propop;
import com.panopset.compat.Stringop;
import com.panopset.flywheel.Flywheel;
import com.panopset.flywheel.Javop;
import com.panopset.flywheel.LineFeedRules;
import com.panopset.flywheel.LineFeedRulesKt;
import com.panopset.flywheel.TemplateArray;
import com.panopset.flywheel.TemplateFile;
import com.panopset.flywheel.TemplateInputStream;
import com.panopset.flywheel.TemplateSource;
import com.panopset.gp.TextFileProcessor;
import com.panopset.gp.TextFileProcessorKt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\rJ\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010\rJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0010J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\u0010J\u001b\u0010\"\u001a\u00020\u00002\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0010J\u0014\u0010'\u001a\u00020\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100)J\u001c\u0010*\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\b\u0010-\u001a\u0004\u0018\u00010\u0010J\u001c\u0010.\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\b\u0010-\u001a\u0004\u0018\u00010\u0010J\u0010\u0010/\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\b\u00101\u001a\u00020\rH\u0002J\b\u00102\u001a\u00020\rH\u0002J\n\u00103\u001a\u0004\u0018\u00010\u0010H\u0002J\n\u00104\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u00105\u001a\u00020\tH\u0002J\u001a\u0010\u0016\u001a\u00020\u00002\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001007J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010J\u001a\u00109\u001a\u00020\u00002\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000107J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0010J\u0016\u0010;\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u0001J\u0010\u0010=\u001a\u00020\u00002\b\u0010>\u001a\u0004\u0018\u00010\rJ\u000e\u0010=\u001a\u00020\u00002\u0006\u0010=\u001a\u00020?J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\rJ\u0019\u0010B\u001a\u00020\u00002\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010$J\u0016\u0010B\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u00102\u0006\u0010E\u001a\u00020\u0010J\u0010\u0010K\u001a\u00020\u00002\b\u0010L\u001a\u0004\u0018\u00010\u000bJ\b\u0010M\u001a\u00020NH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010J\u00a8\u0006O"}, d2={"Lcom/panopset/flywheel/FlywheelBuilder;", "", "<init>", "()V", "inputStream", "Ljava/io/InputStream;", "isOutputEnabled", "", "lineFeedRules", "Lcom/panopset/flywheel/LineFeedRules;", "writer", "Ljava/io/StringWriter;", "targetDirectory", "Ljava/io/File;", "array", "", "", "[Ljava/lang/String;", "sls", "Lcom/panopset/flywheel/TemplateSource;", "scriptFile", "baseDirectoryPath", "map", "", "registeredObjects", "Ljava/util/HashMap;", "isValid", "construct", "Lcom/panopset/flywheel/Flywheel;", "newTargetDirectory", "file", "value", "scriptFilePath", "path", "inputArray", "newStringArray", "([Ljava/lang/String;)Lcom/panopset/flywheel/FlywheelBuilder;", "inputString", "template", "inputList", "newInput", "", "input", "clazz", "Ljava/lang/Class;", "resourcePath", "inputResourcePath", "inputInputStream", "withLineFeedRules", "getTargetDirectory", "getScriptFile", "getBaseDirectoryPath", "getStringLineSupplier", "getLineFeedRules", "additionalMap", "", "key", "mapObjects", "tokens", "registerObject", "obj", "properties", "propertiesFile", "Ljava/util/Properties;", "replacements", "replacementsFile", "replacement", "sa", "from", "to", "Ljava/util/ArrayList;", "getReplacements", "()Ljava/util/ArrayList;", "setReplacements", "(Ljava/util/ArrayList;)V", "withWriter", "newWriter", "invalidate", "", "flywheel"})
public final class FlywheelBuilder {
    @Nullable
    private InputStream inputStream;
    private boolean isOutputEnabled = true;
    @Nullable
    private LineFeedRules lineFeedRules;
    @Nullable
    private StringWriter writer;
    @Nullable
    private File targetDirectory;
    @Nullable
    private String[] array;
    @Nullable
    private TemplateSource sls;
    @Nullable
    private File scriptFile;
    @Nullable
    private String baseDirectoryPath;
    @NotNull
    private final Map<String, String> map = new HashMap();
    @NotNull
    private final HashMap<String, Object> registeredObjects = new HashMap();
    private boolean isValid = true;
    @NotNull
    private ArrayList<String[]> replacements = new ArrayList();

    @NotNull
    public final Flywheel construct() {
        Flywheel flywheel2 = new Flywheel(this.getStringLineSupplier());
        flywheel2.setBaseDirectoryPath(this.getBaseDirectoryPath());
        flywheel2.mergeMap(this.map);
        flywheel2.setReplacements(this.replacements);
        flywheel2.setTargetDirectory(Fileop.INSTANCE.getCanonicalPath(this.getTargetDirectory()));
        flywheel2.put("com.panopset.flywheel.target", Fileop.INSTANCE.getCanonicalPath(this.getTargetDirectory()));
        if (this.writer != null) {
            StringWriter stringWriter = this.writer;
            Intrinsics.checkNotNull(stringWriter);
            flywheel2.setWriter(stringWriter);
        }
        ((Map)this.registeredObjects).put("com.panopset.flywheel", flywheel2);
        flywheel2.setRegisteredObjects(this.registeredObjects);
        flywheel2.setFile(this.getScriptFile());
        flywheel2.setOutputEnabled(this.isOutputEnabled);
        flywheel2.setLineFeedRules(this.getLineFeedRules());
        if (!this.isValid) {
            flywheel2.stop("See messages above, processing cancelled.");
        }
        return flywheel2;
    }

    @NotNull
    public final FlywheelBuilder targetDirectory(@NotNull File newTargetDirectory) {
        Intrinsics.checkNotNullParameter(newTargetDirectory, "newTargetDirectory");
        this.targetDirectory = newTargetDirectory.getAbsoluteFile();
        return this;
    }

    @NotNull
    public final FlywheelBuilder file(@Nullable File value) {
        this.scriptFile = value;
        return this;
    }

    @NotNull
    public final FlywheelBuilder scriptFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.file(new File(path));
    }

    @NotNull
    public final FlywheelBuilder baseDirectoryPath(@Nullable String path) {
        this.baseDirectoryPath = path;
        return this;
    }

    @NotNull
    public final FlywheelBuilder inputArray(@NotNull String[] newStringArray) {
        Intrinsics.checkNotNullParameter(newStringArray, "newStringArray");
        this.array = newStringArray;
        return this;
    }

    @NotNull
    public final FlywheelBuilder inputString(@NotNull String template) {
        Intrinsics.checkNotNullParameter(template, "template");
        String[] stringArray = new String[]{template};
        return this.inputArray(stringArray);
    }

    @NotNull
    public final FlywheelBuilder inputList(@NotNull List<String> newInput) {
        Intrinsics.checkNotNullParameter(newInput, "newInput");
        String[] sa = new String[newInput.size()];
        int incr = 0;
        for (String s : newInput) {
            sa[incr++] = s;
        }
        return this.inputArray(sa);
    }

    @NotNull
    public final FlywheelBuilder input(@NotNull Class<?> clazz, @Nullable String resourcePath) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return this.inputInputStream(clazz.getResourceAsStream(resourcePath));
    }

    @NotNull
    public final FlywheelBuilder inputResourcePath(@NotNull Class<?> clazz, @Nullable String resourcePath) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return this.inputInputStream(clazz.getResourceAsStream(resourcePath));
    }

    @NotNull
    public final FlywheelBuilder inputInputStream(@Nullable InputStream value) {
        this.inputStream = value;
        return this;
    }

    @NotNull
    public final FlywheelBuilder withLineFeedRules(@NotNull LineFeedRules lineFeedRules) {
        Intrinsics.checkNotNullParameter(lineFeedRules, "lineFeedRules");
        this.lineFeedRules = lineFeedRules;
        return this;
    }

    private final File getTargetDirectory() {
        if (this.targetDirectory == null) {
            String targetDirName;
            String string = this.map.get("com.panopset.flywheel.target");
            if (string == null) {
                string = "";
            }
            return Stringop.INSTANCE.isPopulated(targetDirName = string) ? new File(targetDirName) : new File("temp");
        }
        File file = this.targetDirectory;
        if (file == null) {
            file = new File("temp");
        }
        return file;
    }

    private final File getScriptFile() {
        if (this.scriptFile == null) {
            String scriptFileName;
            String string = this.map.get("com.panopset.flywheel.script");
            if (string == null) {
                string = "";
            }
            if (Stringop.INSTANCE.isPopulated(scriptFileName = string)) {
                File file = this.scriptFile = new File(scriptFileName);
                Intrinsics.checkNotNull(file);
                return file;
            }
            this.scriptFile = new File("com.panopset.flywheel.EmptyFile.txt");
        }
        File file = this.scriptFile;
        Intrinsics.checkNotNull(file);
        return file;
    }

    private final String getBaseDirectoryPath() {
        if (!Stringop.INSTANCE.isPopulated(this.baseDirectoryPath)) {
            this.baseDirectoryPath = Fileop.INSTANCE.getCanonicalPath(this.getScriptFile().getAbsoluteFile().getParentFile());
        }
        return this.baseDirectoryPath;
    }

    private final TemplateSource getStringLineSupplier() {
        if (this.sls == null) {
            if (this.array != null) {
                Intrinsics.checkNotNull(this.array);
                this.sls = new TemplateArray(this.array);
                return this.sls;
            }
            if (this.inputStream != null) {
                InputStream inputStream = this.inputStream;
                Intrinsics.checkNotNull(inputStream);
                this.sls = new TemplateInputStream(inputStream);
                return this.sls;
            }
            this.sls = new TemplateFile(this.getScriptFile());
        }
        return this.sls;
    }

    private final LineFeedRules getLineFeedRules() {
        if (this.lineFeedRules == null) {
            this.lineFeedRules = LineFeedRulesKt.getFULL_BREAKS();
        }
        LineFeedRules lineFeedRules = this.lineFeedRules;
        Intrinsics.checkNotNull(lineFeedRules);
        return lineFeedRules;
    }

    @NotNull
    public final FlywheelBuilder map(@NotNull Map<String, String> additionalMap) {
        Intrinsics.checkNotNullParameter(additionalMap, "additionalMap");
        Javop.INSTANCE.copyMap(additionalMap, this.map);
        return this;
    }

    @NotNull
    public final FlywheelBuilder map(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        this.map.put(key, value);
        return this;
    }

    @NotNull
    public final FlywheelBuilder mapObjects(@NotNull Map<String, ? extends Object> additionalMap) {
        Intrinsics.checkNotNullParameter(additionalMap, "additionalMap");
        Javop.INSTANCE.copyMapObjects(additionalMap, this.map);
        return this;
    }

    @NotNull
    public final FlywheelBuilder tokens(@NotNull String tokens) {
        Intrinsics.checkNotNullParameter(tokens, "tokens");
        this.map.put("com.panopset.flywheel.tokens", tokens);
        return this;
    }

    @NotNull
    public final FlywheelBuilder registerObject(@NotNull String key, @NotNull Object obj) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(obj, "obj");
        ((Map)this.registeredObjects).put(key, obj);
        return this;
    }

    @NotNull
    public final FlywheelBuilder properties(@Nullable File propertiesFile) throws IOException {
        if (propertiesFile != null && propertiesFile.exists()) {
            return this.map(Propop.INSTANCE.loadPropsFromFile(propertiesFile));
        }
        if (propertiesFile != null) {
            Logz.INSTANCE.warn(Fileop.INSTANCE.getCanonicalPath(propertiesFile) + " " + Nls.INSTANCE.xlate("does not exist, skipping."));
        }
        return this;
    }

    @NotNull
    public final FlywheelBuilder properties(@NotNull Properties properties) {
        Intrinsics.checkNotNullParameter(properties, "properties");
        return this.map(Propop.INSTANCE.loadMapFromProperties(properties));
    }

    @NotNull
    public final FlywheelBuilder replacements(@NotNull File replacementsFile) {
        Intrinsics.checkNotNullParameter(replacementsFile, "replacementsFile");
        List v = new ArrayList();
        try {
            TextFileProcessor tfp = TextFileProcessorKt.textFileIterator(replacementsFile);
            String separator = null;
            while (tfp.hasNext()) {
                String str = tfp.next();
                if (separator == null) {
                    separator = str;
                    continue;
                }
                StringTokenizer st = new StringTokenizer(str, separator);
                String[] stringArray = new String[]{st.nextToken(), st.nextToken()};
                v.add(stringArray);
            }
            for (Object e : v) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                String[] r = (String[])e;
                this.replacement(r);
            }
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
        }
        return this;
    }

    @NotNull
    public final FlywheelBuilder replacement(@NotNull String[] sa) {
        Intrinsics.checkNotNullParameter(sa, "sa");
        return this.replacement(sa[0], sa[1]);
    }

    @NotNull
    public final FlywheelBuilder replacement(@NotNull String from, @NotNull String to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        String[] stringArray = new String[]{from, to};
        this.replacements.add(stringArray);
        return this;
    }

    @NotNull
    public final ArrayList<String[]> getReplacements() {
        return this.replacements;
    }

    public final void setReplacements(@NotNull ArrayList<String[]> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.replacements = arrayList;
    }

    @NotNull
    public final FlywheelBuilder withWriter(@Nullable StringWriter newWriter) {
        this.writer = newWriter;
        this.isOutputEnabled = false;
        return this;
    }

    private final void invalidate() {
        this.isValid = false;
    }
}

