/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Logz;
import com.panopset.flywheel.Command;
import com.panopset.flywheel.CommandQuit;
import com.panopset.flywheel.FlywheelException;
import com.panopset.flywheel.MatchableCommand;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/panopset/flywheel/CommandMatcher;", "", "<init>", "()V", "matchQuitCommands", "", "Lcom/panopset/flywheel/Command;", "commands", "updateStack", "", "stack", "Ljava/util/Deque;", "Lcom/panopset/flywheel/MatchableCommand;", "rtn", "", "command", "flywheel"})
public final class CommandMatcher {
    @NotNull
    public static final CommandMatcher INSTANCE = new CommandMatcher();

    private CommandMatcher() {
    }

    @NotNull
    public final List<Command> matchQuitCommands(@NotNull List<? extends Command> commands) {
        Intrinsics.checkNotNullParameter(commands, "commands");
        FlywheelException fwe = null;
        List matchedCommandsForDebugging = new ArrayList();
        List rtn2 = new ArrayList();
        Deque stack = new ArrayDeque();
        for (Command command : commands) {
            this.updateStack(stack, rtn2, command);
            if (command instanceof MatchableCommand) {
                matchedCommandsForDebugging.add(command);
                if (stack.isEmpty()) {
                    rtn2.add(command);
                }
                stack.push(command);
                continue;
            }
            if (!(command instanceof CommandQuit)) continue;
            if (stack.isEmpty()) {
                for (MatchableCommand mc : matchedCommandsForDebugging) {
                    String string = "Succussfully matched with quit, before un-matched quit found: %s";
                    Object[] objectArray = new Object[]{mc.toString()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                    Logz.INSTANCE.info(string2);
                }
                fwe = new FlywheelException("Un-matched quit found, stopping.");
                break;
            }
            stack.pop();
        }
        if (fwe != null) {
            Logz.INSTANCE.errorMsg("Failed to process the following template commands:");
            for (Command command : commands) {
                Logz.INSTANCE.info(command.toString());
            }
            throw fwe;
        }
        return rtn2;
    }

    private final void updateStack(Deque<MatchableCommand> stack, List<Command> rtn2, Command command) {
        if (stack.isEmpty()) {
            if (!(command instanceof MatchableCommand)) {
                rtn2.add(command);
            }
        } else {
            stack.peek().getCommands().add(command);
        }
    }
}

