/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities;

import com.panopset.compat.HttpClientFactoryKt;
import com.panopset.compat.HttpResponsePackage;
import com.panopset.compat.Logz;
import com.panopset.compat.Stringop;
import com.panopset.desk.utilities.skyscraper.Floor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.control.TextArea;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a(\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"doSend", "", "floor", "Lcom/panopset/desk/utilities/skyscraper/Floor;", "doPost", "doGet", "createHeaders", "", "", "rawHeaders", "clrmsg", "ta", "Ljavafx/scene/control/TextArea;", "processResponse", "rp", "Lcom/panopset/compat/HttpResponsePackage;", "urlString", "responseTextArea", "startTime", "", "desk"})
public final class SkyscraperKt {
    private static final void doSend(Floor floor) {
        String string = floor.getPostMethodChoiceBox().getValue();
        if (Intrinsics.areEqual(string, "GET")) {
            SkyscraperKt.doGet(floor);
        } else if (Intrinsics.areEqual(string, "POST")) {
            SkyscraperKt.doPost(floor);
        }
    }

    private static final void doPost(Floor floor) {
        String actualURL = floor.getUrlOutField().getText();
        TextArea headerTextField = floor.getHeaderTextArea();
        TextArea responseTextArea = floor.getResponseTextArea();
        TextArea bodyTextField = floor.getBodyTextArea();
        SkyscraperKt.clrmsg(responseTextArea);
        long startTime = System.currentTimeMillis();
        try {
            String string = headerTextField.getText();
            Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
            Map<String, String> map = SkyscraperKt.createHeaders(string);
            Intrinsics.checkNotNull(actualURL);
            String string2 = bodyTextField.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
            SkyscraperKt.processResponse(HttpClientFactoryKt.doPostHttp(map, actualURL, string2), actualURL, responseTextArea, startTime);
        }
        catch (Throwable throwable) {
            floor.getFxDoc().errorEx(throwable);
        }
    }

    private static final void doGet(Floor floor) {
        String actualURL = floor.getUrlOutField().getText();
        TextArea headerTextField = floor.getHeaderTextArea();
        TextArea responseTextArea = floor.getResponseTextArea();
        SkyscraperKt.clrmsg(responseTextArea);
        long startTime = System.currentTimeMillis();
        try {
            String string = headerTextField.getText();
            Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
            Map<String, String> map = SkyscraperKt.createHeaders(string);
            Intrinsics.checkNotNull(actualURL);
            SkyscraperKt.processResponse(HttpClientFactoryKt.doGetHttp(map, actualURL), actualURL, responseTextArea, startTime);
        }
        catch (Throwable throwable) {
            floor.getFxDoc().errorEx(throwable);
        }
    }

    @NotNull
    public static final Map<String, String> createHeaders(@NotNull String rawHeaders) {
        Intrinsics.checkNotNullParameter(rawHeaders, "rawHeaders");
        HashMap rtn2 = new HashMap();
        ArrayList<String> lines = Stringop.INSTANCE.stringToList(rawHeaders);
        Iterator<String> iterator2 = lines.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String key;
            String s;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            int i = StringsKt.indexOf$default((CharSequence)s, ":", 0, false, 6, null);
            if (i <= -1) continue;
            Intrinsics.checkNotNullExpressionValue(s.substring(0, i), "substring(...)");
            String string = s.substring(i + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String value = ((Object)StringsKt.trimStart((CharSequence)string)).toString();
            if (!(((CharSequence)key).length() > 0) || !(((CharSequence)value).length() > 0)) continue;
            ((Map)rtn2).put(key, value);
        }
        return rtn2;
    }

    private static final void clrmsg(TextArea ta) {
        Platform.runLater(() -> SkyscraperKt.clrmsg$lambda$0(ta));
    }

    private static final void processResponse(HttpResponsePackage rp, String urlString, TextArea responseTextArea, long startTime) {
        if (rp.getResponseCode() == 200) {
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            Logz.INSTANCE.green("Completed in " + totalTime + " ms. " + urlString);
        } else if (rp.getResponseCode() == -1) {
            Logz.INSTANCE.errorMsg("No response was received, " + rp.getErrorMessage());
        } else {
            Logz.INSTANCE.errorMsg("Response code was " + rp.getResponseCode() + ", " + rp.getErrorMessage());
        }
        Platform.runLater(() -> SkyscraperKt.processResponse$lambda$1(responseTextArea, rp));
    }

    private static final void clrmsg$lambda$0(TextArea $ta) {
        $ta.setText("");
    }

    private static final void processResponse$lambda$1(TextArea $responseTextArea, HttpResponsePackage $rp) {
        $responseTextArea.setText($rp.getText());
    }

    public static final /* synthetic */ void access$doSend(Floor floor) {
        SkyscraperKt.doSend(floor);
    }
}

