/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities;

import com.panopset.compat.AppVersion;
import com.panopset.compat.ChecksumFunKt;
import com.panopset.compat.Fileop;
import com.panopset.compat.Jsonop;
import com.panopset.marin.bootstrap.Platform;
import com.panopset.marin.bootstrap.PlatformMap;
import com.panopset.marin.secure.checksums.ChecksumType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"generateJsonFor", "", "file", "Ljava/io/File;", "createJsonMap", "", "", "fxArch", "installerFile", "desk"})
public final class GenerateAppInfoKt {
    private static final void generateJsonFor(File file) {
        String name = file.getName();
        for (Platform platform : new PlatformMap().getMap().values()) {
            String json;
            if (!Intrinsics.areEqual(FilesKt.getExtension(file), FilesKt.getExtension(new File(platform.getArtifactName())))) continue;
            File targetFile = new File("/var/www/html/downloads/pci_" + name + ".json");
            File targetFileForOneJar = new File("/var/www/html/downloads/" + platform.getFxArch() + "OneJar.json");
            Fileop.INSTANCE.checkParent(targetFileForOneJar);
            if (!targetFile.exists()) {
                json = new Jsonop<Map<String, String>>().toJson(GenerateAppInfoKt.createJsonMap(platform.getFxArch(), file));
                Fileop.INSTANCE.write(json, targetFile);
            }
            if (targetFileForOneJar.exists()) continue;
            json = new Jsonop<Map<String, String>>().toJson(GenerateAppInfoKt.createJsonMap(platform.getFxArch(), new File("/var/www/html/downloads/" + platform.getFxArch() + "/panopset.jar")));
            Fileop.INSTANCE.write(json, targetFileForOneJar);
        }
    }

    @NotNull
    public static final Map<String, String> createJsonMap(@NotNull String fxArch, @NotNull File installerFile) {
        Intrinsics.checkNotNullParameter(fxArch, "fxArch");
        Intrinsics.checkNotNullParameter(installerFile, "installerFile");
        HashMap map = new HashMap();
        ((Map)map).put("fxArch", fxArch);
        ((Map)map).put("version", AppVersion.INSTANCE.getFullVersion());
        ((Map)map).put("bytes", ChecksumFunKt.byteCount(installerFile));
        ((Map)map).put(ChecksumType.SHA512.key, ChecksumFunKt.sha512(installerFile));
        ((Map)map).put("ifn", installerFile.getName());
        return map;
    }

    public static final /* synthetic */ void access$generateJsonFor(File file) {
        GenerateAppInfoKt.generateJsonFor(file);
    }
}

