/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.security;

import com.panopset.compat.Logz;
import com.panopset.compat.Stringop;
import com.panopset.compat.TextScrambler;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanComponentFactoryKt;
import com.panopset.marin.fx.PanopsetBrandedAppTran;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/panopset/desk/security/Scrambler;", "Lcom/panopset/marin/fx/PanopsetBrandedAppTran;", "<init>", "()V", "unscrambleButton", "Ljavafx/scene/control/Button;", "scrambleButton", "taInOutMessage", "Ljavafx/scene/control/TextArea;", "tfKoi", "Ljavafx/scene/control/TextField;", "showPwdCheckbox", "Ljavafx/scene/control/CheckBox;", "passwordField", "Ljavafx/scene/control/PasswordField;", "passwordShow", "createDynapane", "Ljavafx/scene/layout/Pane;", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "createCenter", "Ljavafx/scene/layout/BorderPane;", "getApplicationDisplayName", "", "getDescription", "doUnscramble", "", "doScramble", "getTheCurrentPassphrase", "createScrambler", "Lcom/panopset/compat/TextScrambler;", "getKeyObIters", "", "Companion", "desk"})
public final class Scrambler
extends PanopsetBrandedAppTran {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Button unscrambleButton;
    private Button scrambleButton;
    private TextArea taInOutMessage;
    private TextField tfKoi;
    private CheckBox showPwdCheckbox;
    private PasswordField passwordField;
    private TextField passwordShow;

    @Override
    @NotNull
    public Pane createDynapane(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.unscrambleButton = PanComponentFactoryKt.createPanButton(fxDoc, () -> Scrambler.createDynapane$lambda$0(this), "_Unscramble", true, "Unscramble the given text, using the given password.");
        this.scrambleButton = PanComponentFactoryKt.createPanButton(fxDoc, () -> Scrambler.createDynapane$lambda$1(this), "_Scramble", true, "Scramble the given text, using the given password.");
        this.showPwdCheckbox = PanComponentFactoryKt.createPanCheckBox(fxDoc, "showPwd", "Show");
        this.passwordField = PanComponentFactoryKt.createPanPwdField();
        this.passwordShow = PanComponentFactoryKt.createPanTransientField();
        PasswordField passwordField = this.passwordField;
        if (passwordField == null) {
            Intrinsics.throwUninitializedPropertyAccessException("passwordField");
            passwordField = null;
        }
        StringProperty stringProperty = passwordField.textProperty();
        TextField textField = this.passwordShow;
        if (textField == null) {
            Intrinsics.throwUninitializedPropertyAccessException("passwordShow");
            textField = null;
        }
        stringProperty.bindBidirectional(textField.textProperty());
        PasswordField passwordField2 = this.passwordField;
        if (passwordField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("passwordField");
            passwordField2 = null;
        }
        BooleanProperty booleanProperty = passwordField2.visibleProperty();
        CheckBox checkBox = this.showPwdCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException("showPwdCheckbox");
            checkBox = null;
        }
        booleanProperty.bind(checkBox.selectedProperty().not());
        TextField textField2 = this.passwordShow;
        if (textField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("passwordShow");
            textField2 = null;
        }
        BooleanProperty booleanProperty2 = textField2.visibleProperty();
        CheckBox checkBox2 = this.showPwdCheckbox;
        if (checkBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("showPwdCheckbox");
            checkBox2 = null;
        }
        booleanProperty2.bind(checkBox2.selectedProperty());
        this.taInOutMessage = PanComponentFactoryKt.createPanTextArea();
        this.tfKoi = PanComponentFactoryKt.createPanIntTextFieldWithDefaultValue(fxDoc, "koi", "10000", "Please enter a numeric value.", "Default is 10000, recommend you change that for added security.");
        BorderPane b = this.createStandardMenubarBorderPane(fxDoc);
        b.setCenter(this.createCenter());
        return b;
    }

    private final BorderPane createCenter() {
        TextField textField;
        Button button;
        BorderPane bp = new BorderPane();
        Node[] nodeArray = new Node[5];
        Node node = this.unscrambleButton;
        if (node == null) {
            Intrinsics.throwUninitializedPropertyAccessException("unscrambleButton");
            node = nodeArray[0] = null;
        }
        if ((button = this.scrambleButton) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("scrambleButton");
            button = null;
        }
        nodeArray[1] = button;
        nodeArray[2] = PanComponentFactoryKt.createPanLabel("  Passphrase:");
        Node[] nodeArray2 = new Node[2];
        Node node2 = this.passwordField;
        if (node2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("passwordField");
            node2 = nodeArray2[0] = null;
        }
        if ((textField = this.passwordShow) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("passwordShow");
            textField = null;
        }
        nodeArray2[1] = textField;
        nodeArray[3] = PanComponentFactoryKt.createPanStackPane(nodeArray2);
        CheckBox checkBox = this.showPwdCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException("showPwdCheckbox");
            checkBox = null;
        }
        nodeArray[4] = checkBox;
        bp.setTop(PanComponentFactoryKt.createPanHBox(nodeArray));
        TextArea textArea = this.taInOutMessage;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("taInOutMessage");
            textArea = null;
        }
        bp.setCenter(PanComponentFactoryKt.createPanScrollPane(textArea));
        nodeArray = new Node[2];
        nodeArray[0] = PanComponentFactoryKt.createPanLabel("   Key obtention interations: ");
        TextField textField2 = this.tfKoi;
        if (textField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tfKoi");
            textField2 = null;
        }
        nodeArray[1] = textField2;
        bp.setBottom(PanComponentFactoryKt.createPanHBox(nodeArray));
        return bp;
    }

    @Override
    @NotNull
    public String getApplicationDisplayName() {
        return "Scrambler";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Text scrambler.";
    }

    private final void doUnscramble() {
        TextArea textArea = this.taInOutMessage;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("taInOutMessage");
            textArea = null;
        }
        String value = textArea.getText();
        try {
            TextArea textArea2 = this.taInOutMessage;
            if (textArea2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("taInOutMessage");
                textArea2 = null;
            }
            TextScrambler textScrambler = this.createScrambler();
            String string = this.getTheCurrentPassphrase();
            Intrinsics.checkNotNull(value);
            textArea2.setText(textScrambler.decrypt(string, value));
        }
        catch (Exception e) {
            Logz.INSTANCE.errorEx(e);
        }
    }

    private final void doScramble() {
        TextArea textArea = this.taInOutMessage;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("taInOutMessage");
            textArea = null;
        }
        String value = textArea.getText();
        try {
            TextArea textArea2 = this.taInOutMessage;
            if (textArea2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("taInOutMessage");
                textArea2 = null;
            }
            TextScrambler textScrambler = this.createScrambler();
            String string = this.getTheCurrentPassphrase();
            Intrinsics.checkNotNull(value);
            textArea2.setText(textScrambler.encrypt(string, value));
        }
        catch (Exception e) {
            Logz.INSTANCE.errorEx(e);
        }
    }

    private final String getTheCurrentPassphrase() {
        String string;
        CheckBox checkBox = this.showPwdCheckbox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException("showPwdCheckbox");
            checkBox = null;
        }
        if (checkBox.isSelected()) {
            TextField textField = this.passwordShow;
            if (textField == null) {
                Intrinsics.throwUninitializedPropertyAccessException("passwordShow");
                textField = null;
            }
            String string2 = textField.getText();
            Intrinsics.checkNotNull(string2);
            string = string2;
        } else {
            PasswordField passwordField = this.passwordField;
            if (passwordField == null) {
                Intrinsics.throwUninitializedPropertyAccessException("passwordField");
                passwordField = null;
            }
            String string3 = passwordField.getText();
            Intrinsics.checkNotNull(string3);
            string = string3;
        }
        return string;
    }

    private final TextScrambler createScrambler() {
        return new TextScrambler().withKeyObtentionIters(this.getKeyObIters());
    }

    private final int getKeyObIters() {
        int intVal;
        TextField textField = this.tfKoi;
        if (textField == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tfKoi");
            textField = null;
        }
        String string = textField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        String strVal = string;
        if (Stringop.INSTANCE.isPopulated(strVal) && (intVal = Stringop.INSTANCE.parseInt(strVal)) > 0) {
            return intVal;
        }
        return 10000;
    }

    private static final Unit createDynapane$lambda$0(Scrambler this$0) {
        this$0.doUnscramble();
        return Unit.INSTANCE;
    }

    private static final Unit createDynapane$lambda$1(Scrambler this$0) {
        this$0.doScramble();
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Companion.main(args2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/panopset/desk/security/Scrambler$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "desk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            new Scrambler().go();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

