/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import java.io.StringWriter;

public class Tile {
    private Tile[] splitz;
    private Splitter splitter;
    private int x;
    private int y;
    private int w;
    private int h;
    private int centerW;
    private int centerH;
    private int r;
    private int b;
    private String s;
    private final String nm;

    public Tile(String name) {
        this.nm = name;
    }

    public String getName() {
        return this.nm;
    }

    public String toString() {
        if (this.s == null) {
            StringWriter sw = new StringWriter();
            sw.append(this.nm);
            sw.append(":xyrbwh:").append(String.valueOf(this.x));
            sw.append(",").append(String.valueOf(this.y));
            sw.append(",").append(String.valueOf(this.r));
            sw.append(",").append(String.valueOf(this.b));
            sw.append(",").append(String.valueOf(this.w));
            sw.append(",").append(String.valueOf(this.h));
            this.s = sw.toString();
        }
        return this.s;
    }

    private void initSplitz(String name0, String name1) {
        if (this.isSplit()) {
            throw new RuntimeException("Can't split twice.");
        }
        this.splitz = new Tile[2];
        this.splitz[0] = new Tile(name0);
        this.splitz[1] = new Tile(name1);
    }

    public Tile[] splitHorizontal(int pct, String name0, String name1) {
        this.initSplitz(name0, name1);
        this.splitter = new PercentSplitter(this, pct){

            @Override
            public boolean isHorizontalSplit() {
                return true;
            }
        };
        this.updateSplitz();
        return this.splitz;
    }

    public Tile[] splitVertical(int pct, String name0, String name1) {
        this.initSplitz(name0, name1);
        this.splitter = new PercentSplitter(this, pct){

            @Override
            public boolean isHorizontalSplit() {
                return false;
            }
        };
        this.updateSplitz();
        return this.splitz;
    }

    public Tile[] splitVerticalExactHeight(int pixels, String name0, String name1) {
        this.initSplitz(name0, name1);
        this.splitter = new ExactSplitter(this, pixels){

            @Override
            public boolean isHorizontalSplit() {
                return false;
            }
        };
        this.updateSplitz();
        return this.splitz;
    }

    public Tile[] splitHorizontalExactWidth(int pixels, String name0, String name1) {
        this.initSplitz(name0, name1);
        this.splitter = new ExactSplitter(this, pixels){

            @Override
            public boolean isHorizontalSplit() {
                return true;
            }
        };
        this.updateSplitz();
        return this.splitz;
    }

    public boolean isSplit() {
        return this.splitz != null;
    }

    private void updateHorizontalSplit() {
        Tile left = this.splitz[0];
        Tile right = this.splitz[1];
        int[] widths = this.split(this.w);
        left.setLocation(this.x, this.y);
        left.setDimensions(widths[0], this.h);
        right.setLocation(this.x + widths[0], this.y);
        right.setDimensions(widths[1], this.h);
        right.updateSplitz();
        left.updateSplitz();
    }

    private int[] split(int span) {
        return this.splitter.split(span);
    }

    private void updateVerticalSplit() {
        Tile top = this.splitz[0];
        Tile bottom = this.splitz[1];
        int[] heights = this.split(this.h);
        top.setLocation(this.x, this.y);
        top.setDimensions(this.w, heights[0]);
        bottom.setLocation(this.x, this.y + heights[0]);
        bottom.setDimensions(this.w, heights[1]);
        top.updateSplitz();
        bottom.updateSplitz();
    }

    private void updateSplitz() {
        if (!this.isSplit()) {
            return;
        }
        if (this.splitter.isHorizontalSplit()) {
            this.updateHorizontalSplit();
        } else {
            this.updateVerticalSplit();
        }
    }

    public Tile setRectXYWH(int xloc, int yloc, int width, int height) {
        this.setLocation(xloc, yloc);
        this.setDimensions(width, height);
        return this;
    }

    public Tile setRectLTRB(int left, int top, int right, int bottom) {
        this.setLocation(left, top);
        this.setDimensions(right - left, bottom - top);
        return this;
    }

    public Tile setLocation(int xloc, int yloc) {
        this.x = xloc;
        this.y = yloc;
        return this;
    }

    public Tile setDimensions(int width, int height) {
        this.w = width;
        this.h = height;
        return this.calc();
    }

    private Tile calc() {
        this.s = null;
        this.b = this.y + this.h;
        this.r = this.x + this.w;
        this.centerW = this.x + this.w / 2;
        this.centerH = this.y + this.h / 2;
        this.updateSplitz();
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getCenterW() {
        return this.centerW;
    }

    public int getCenterH() {
        return this.centerH;
    }

    public int getHeight() {
        return this.h;
    }

    public int getLeft() {
        return this.x;
    }

    public int getRight() {
        return this.r;
    }

    public int getTop() {
        return this.y;
    }

    public int getBottom() {
        return this.b;
    }

    static interface Splitter {
        public boolean isHorizontalSplit();

        public int[] split(int var1);
    }

    static abstract class ExactSplitter
    implements Splitter {
        private final int pxs;

        public ExactSplitter(int pixels) {
            this.pxs = pixels;
        }

        @Override
        public int[] split(int span) {
            return new int[]{this.pxs, span - this.pxs};
        }
    }

    static abstract class PercentSplitter
    implements Splitter {
        private final int pct;

        public PercentSplitter(int percent) {
            if (percent > 100) {
                throw new ArrayIndexOutOfBoundsException(percent);
            }
            this.pct = percent;
        }

        @Override
        public int[] split(int span) {
            int rtn0 = span * this.pct / 100;
            return new int[]{rtn0, span - rtn0};
        }
    }
}

