/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.LogpanKt;
import com.panopset.compat.Logz;
import com.panopset.compat.Nls;
import com.panopset.compat.Randomop;
import com.panopset.compat.Stringop;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.spec.KeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u000b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0016\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\u0016\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/panopset/compat/TextScrambler;", "", "<init>", "()V", "wrapWidth", "", "keygenAlgorithm", "", "cipherAlgorithm", "keyAlgorithm", "iters", "createCipher", "Ljavax/crypto/Cipher;", "secretKeyFactory", "Ljavax/crypto/SecretKeyFactory;", "getSecretKeyFactory", "()Ljavax/crypto/SecretKeyFactory;", "encrypt", "password", "msg", "encrypt2bytes", "", "decrypt", "decryptFromBytes", "bytes", "withWrapWidth", "value", "withKeyObtentionIters", "withKeygenAlgorithm", "withCipherAlgorithm", "withKeyAlgorithm", "Companion", "compat"})
@SourceDebugExtension(value={"SMAP\nTextScrambler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextScrambler.kt\ncom/panopset/compat/TextScrambler\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,215:1\n108#2:216\n80#2,22:217\n*S KotlinDebug\n*F\n+ 1 TextScrambler.kt\ncom/panopset/compat/TextScrambler\n*L\n114#1:216\n114#1:217,22\n*E\n"})
public final class TextScrambler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int wrapWidth = 80;
    @NotNull
    private String keygenAlgorithm = "AES";
    @NotNull
    private String cipherAlgorithm = "AES/CBC/PKCS5PADDING";
    @NotNull
    private String keyAlgorithm = "PBKDF2WithHmacSHA512";
    private int iters = 10000;
    @Nullable
    private SecretKeyFactory secretKeyFactory;
    public static final int DEFAULT_WRAP_WIDTH = 80;
    @NotNull
    public static final String DEFAULT_KEYGEN_ALGORITHM = "AES";
    @NotNull
    public static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5PADDING";
    @NotNull
    public static final String DEFAULT_KEY_ALGORITHM = "PBKDF2WithHmacSHA512";
    public static final int DEFAULT_KEY_OBTENTION_ITERATIONS = 10000;

    private final Cipher createCipher() {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(this.cipherAlgorithm);
        }
        catch (Exception e) {
            Logz.INSTANCE.errorEx(e);
            throw new RuntimeException(e);
        }
        return cipher;
    }

    private final SecretKeyFactory getSecretKeyFactory() {
        if (this.secretKeyFactory == null) {
            SecretKeyFactory secretKeyFactory;
            TextScrambler textScrambler = this;
            try {
                TextScrambler textScrambler2 = textScrambler;
                secretKeyFactory = SecretKeyFactory.getInstance(this.keyAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                TextScrambler textScrambler3 = textScrambler;
                LogpanKt.errorExlg(e);
                throw new RuntimeException(e);
            }
            textScrambler2.secretKeyFactory = secretKeyFactory;
        }
        return this.secretKeyFactory;
    }

    @NotNull
    public final String encrypt(@NotNull String password, @NotNull String msg) {
        Intrinsics.checkNotNullParameter(password, "password");
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (!Stringop.INSTANCE.isPopulated(password)) {
            String errorMessage = Nls.INSTANCE.xlate("Please specify a password.");
            Logz.INSTANCE.warn(errorMessage);
            return errorMessage;
        }
        byte[] byArray = Base64.getUrlEncoder().encode(this.encrypt2bytes(password, msg));
        Intrinsics.checkNotNullExpressionValue(byArray, "encode(...)");
        byte[] byArray2 = byArray;
        String pkgStr = new String(byArray2, Charsets.UTF_8);
        return Stringop.INSTANCE.wrapFixedWidth(pkgStr, this.wrapWidth);
    }

    private final byte[] encrypt2bytes(String password, String msg) {
        byte[] salt = new byte[8];
        Randomop.INSTANCE.nextBytes(salt);
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        KeySpec spec = new PBEKeySpec(cArray, salt, this.iters, 128);
        SecretKeyFactory secretKeyFactory = this.getSecretKeyFactory();
        Intrinsics.checkNotNull(secretKeyFactory);
        SecretKeySpec secretKey = new SecretKeySpec(secretKeyFactory.generateSecret(spec).getEncoded(), this.keygenAlgorithm);
        Cipher cipher = this.createCipher();
        byte[] iv = new byte[16];
        Randomop.INSTANCE.nextBytes(iv);
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        cipher.init(1, (Key)secretKey, ivspec);
        String string = msg;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] encryptedData = cipher.doFinal(byArray);
        byte[] rtn2 = new byte[salt.length + iv.length + encryptedData.length];
        System.arraycopy(salt, 0, rtn2, 0, salt.length);
        System.arraycopy(iv, 0, rtn2, salt.length, iv.length);
        System.arraycopy(encryptedData, 0, rtn2, salt.length + iv.length, encryptedData.length);
        return rtn2;
    }

    @NotNull
    public final String decrypt(@NotNull String password, @NotNull String msg) {
        String string;
        Intrinsics.checkNotNullParameter(password, "password");
        Intrinsics.checkNotNullParameter(msg, "msg");
        try {
            String $this$trim$iv = msg;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String msgTrim = StringsKt.replace$default(StringsKt.replace$default(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), "\r", "", false, 4, null), "\n", "", false, 4, null);
            byte[] pkgBytes = Base64.getUrlDecoder().decode(msgTrim);
            Intrinsics.checkNotNull(pkgBytes);
            string = this.decryptFromBytes(password, pkgBytes);
        }
        catch (IllegalArgumentException ex) {
            String errorMsg = Nls.INSTANCE.xlate("Likely wrong password, or not an encrypted message, because") + ": " + ex.getMessage();
            Logz.INSTANCE.errorMsg(errorMsg, (Throwable)ex);
            return errorMsg;
        }
        return string;
    }

    @NotNull
    public final String decryptFromBytes(@NotNull String password, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(password, "password");
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        if (bytes.length < 25) {
            throw new Exception(Nls.INSTANCE.xlate("Not an encrypted message."));
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        int msgLength = bytes.length - 24;
        byte[] salt = new byte[8];
        byte[] iv = new byte[16];
        byte[] encr = new byte[msgLength];
        bb.get(salt, 0, 8);
        bb.get(iv, 0, 16);
        bb.get(encr, 0, msgLength);
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        KeySpec spec = new PBEKeySpec(cArray, salt, this.iters, 128);
        SecretKeyFactory secretKeyFactory = this.getSecretKeyFactory();
        Intrinsics.checkNotNull(secretKeyFactory);
        SecretKeySpec secretKey = new SecretKeySpec(secretKeyFactory.generateSecret(spec).getEncoded(), this.keygenAlgorithm);
        Cipher cipher = this.createCipher();
        cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
        byte[] data = cipher.doFinal(encr);
        Intrinsics.checkNotNull(data);
        return new String(data, Charsets.UTF_8);
    }

    @NotNull
    public final TextScrambler withWrapWidth(int value) {
        this.wrapWidth = value;
        return this;
    }

    @NotNull
    public final TextScrambler withKeyObtentionIters(int value) {
        this.iters = value;
        return this;
    }

    @NotNull
    public final TextScrambler withKeygenAlgorithm(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.keygenAlgorithm = value;
        return this;
    }

    @NotNull
    public final TextScrambler withCipherAlgorithm(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.cipherAlgorithm = value;
        return this;
    }

    @NotNull
    public final TextScrambler withKeyAlgorithm(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.keyAlgorithm = value;
        return this;
    }

    static {
        Security.setProperty("crypto.policy", "unlimited");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/panopset/compat/TextScrambler$Companion;", "", "<init>", "()V", "DEFAULT_WRAP_WIDTH", "", "DEFAULT_KEYGEN_ALGORITHM", "", "DEFAULT_CIPHER_ALGORITHM", "DEFAULT_KEY_ALGORITHM", "DEFAULT_KEY_OBTENTION_ITERATIONS", "compat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

