/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.Fileop;
import com.panopset.compat.LogEntry;
import com.panopset.compat.LogEntryKt;
import com.panopset.compat.LogopAlert;
import com.panopset.compat.Stringop;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\t\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\f\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0012\u0010\n\u001a\u00020\u00072\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010\u001a\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0012\u001a\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00072\u000e\u0010\u0015\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u0010H\u0002\u001a\u001a\u0010\f\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0012\u001a\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u0012\u001a\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0003H\u0002\u001a\u0006\u0010\u001e\u001a\u00020\u0005\u001a\u0006\u0010\u001f\u001a\u00020\u0007\u001a\b\u0010$\u001a\u00020\u0005H\u0002\u001a\u0010\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0003H\u0002\u001a\u000e\u0010'\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006("}, d2={"logger", "Ljava/util/logging/Logger;", "clearLogEntry", "Lcom/panopset/compat/LogEntry;", "standardWierdErrorMessage", "", "dspmsglg", "", "msg", "infolg", "warnlg", "debuglg", "errorMsglg", "auditlg", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errorExlg", "", "greenlg", "handlelg", "e", "message", "file", "Ljava/io/File;", "getStackTracelg", "throwable", "handleExceptionlg", "reportlg", "logRecord", "getEntryStackAsTextlg", "clearlg", "stacklg", "Ljava/util/Deque;", "getStacklg", "()Ljava/util/Deque;", "printHistorylg", "logaloglg", "logEntry", "getStackTraceAndCauseslg", "compat"})
public final class LogpanKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final LogEntry clearLogEntry;
    @NotNull
    public static final String standardWierdErrorMessage = "Unexpected error, if your pull request is accepted, we'll send you 1000 currently worthless Panopset shares.";
    @NotNull
    private static final Deque<LogEntry> stacklg;

    public static final void dspmsglg(@Nullable String msg) {
        LogpanKt.infolg(msg);
    }

    public static final void infolg(@Nullable String msg) {
        Level level = Level.INFO;
        Intrinsics.checkNotNullExpressionValue(level, "INFO");
        String string = LogpanKt.auditlg(msg);
        Intrinsics.checkNotNull(string);
        LogpanKt.reportlg(new LogEntry(LogopAlert.GREEN, level, string));
    }

    public static final void warnlg(@Nullable String msg) {
        Level level = Level.WARNING;
        Intrinsics.checkNotNullExpressionValue(level, "WARNING");
        String string = LogpanKt.auditlg(msg);
        Intrinsics.checkNotNull(string);
        LogpanKt.reportlg(new LogEntry(LogopAlert.YELLOW, level, string));
    }

    public static final void debuglg(@Nullable String msg) {
        Level level = Level.FINE;
        Intrinsics.checkNotNullExpressionValue(level, "FINE");
        String string = LogpanKt.auditlg(msg);
        Intrinsics.checkNotNull(string);
        LogpanKt.reportlg(new LogEntry(LogopAlert.ORANGE, level, string));
    }

    public static final void errorMsglg(@Nullable String msg) {
        Level level = Level.SEVERE;
        Intrinsics.checkNotNullExpressionValue(level, "SEVERE");
        String string = LogpanKt.auditlg(msg);
        Intrinsics.checkNotNull(string);
        LogpanKt.reportlg(new LogEntry(LogopAlert.RED, level, string));
    }

    private static final String auditlg(String msg) {
        return msg;
    }

    public static final void warnlg(@NotNull Exception ex) {
        Intrinsics.checkNotNullParameter(ex, "ex");
        LogpanKt.warnlg(ex.getMessage());
    }

    public static final void errorExlg(@NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter(ex, "ex");
        LogpanKt.handleExceptionlg(ex);
    }

    public static final void errorMsglg(@NotNull String msg, @NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(ex, "ex");
        LogpanKt.errorMsglg(msg);
        LogpanKt.handleExceptionlg(ex);
    }

    private static final void greenlg(String msg) {
        LogpanKt.dspmsglg(msg);
    }

    private static final void handlelg(Exception e) {
        Exception exception = e;
        Intrinsics.checkNotNull(exception);
        LogpanKt.handleExceptionlg(exception);
    }

    public static final void errorMsglg(@Nullable String message, @Nullable File file) {
        if (file == null) {
            LogpanKt.errorMsglg("Null file.");
            return;
        }
        LogpanKt.errorMsglg(message + ": " + Fileop.INSTANCE.getCanonicalPath(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String getStackTracelg(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        Closeable closeable = new StringWriter();
        Throwable throwable2 = null;
        try {
            String string;
            StringWriter sw = (StringWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = new PrintWriter(sw);
            Throwable throwable3 = null;
            try {
                PrintWriter pw = (PrintWriter)closeable2;
                boolean bl2 = false;
                throwable.printStackTrace(pw);
                pw.flush();
                String string2 = sw.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                string = string2;
            }
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        CloseableKt.closeFinally(closeable2, throwable3);
                        throw throwable5;
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
            }
            CloseableKt.closeFinally(closeable2, throwable3);
            String string3 = string;
            return string3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable2);
        }
    }

    public static final void errorMsglg(@NotNull File file, @NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(ex, "ex");
        LogpanKt.infolg(Fileop.INSTANCE.getCanonicalPath(file));
        LogpanKt.errorExlg(ex);
    }

    private static final void handleExceptionlg(Throwable ex) {
        logger.log(Level.SEVERE, ex.getMessage(), ex);
        Level level = Level.SEVERE;
        Intrinsics.checkNotNullExpressionValue(level, "SEVERE");
        String string = ex.getMessage();
        if (string == null) {
            string = standardWierdErrorMessage;
        }
        LogEntry logEntry = new LogEntry(LogopAlert.RED, level, string);
        LogpanKt.logaloglg(logEntry);
    }

    private static final void reportlg(LogEntry logRecord) {
        logger.log(logRecord.getLevel(), logRecord.getMessage());
        LogpanKt.logaloglg(logRecord);
    }

    @NotNull
    public static final String getEntryStackAsTextlg() {
        return LogpanKt.printHistorylg();
    }

    public static final void clearlg() {
        stacklg.clear();
    }

    @NotNull
    public static final Deque<LogEntry> getStacklg() {
        return stacklg;
    }

    private static final String printHistorylg() {
        StringWriter sw = new StringWriter();
        Iterator<LogEntry> iterator2 = stacklg.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<LogEntry> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            LogEntry lr = iterator3.next();
            sw.append(LogEntryKt.getTimestampFormat().format(lr.getTimestamp()));
            sw.append(lr.getMessage());
            sw.append("\n");
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final void logaloglg(LogEntry logEntry) {
        if (stacklg.size() > 10) {
            stacklg.removeLast();
        }
        stacklg.push(logEntry);
    }

    @NotNull
    public static final String getStackTraceAndCauseslg(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        StringWriter sw = new StringWriter();
        sw.append("See log");
        sw.append(": ");
        sw.append(throwable.getMessage());
        sw.append(Stringop.INSTANCE.getEol());
        sw.append("*************************");
        sw.append(Stringop.INSTANCE.getEol());
        sw.append(LogpanKt.getStackTracelg(throwable));
        sw.append(Stringop.INSTANCE.getEol());
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            sw.append("*************************");
            sw.append(Stringop.INSTANCE.getEol());
            sw.append(LogpanKt.getStackTracelg(cause));
            sw.append(Stringop.INSTANCE.getEol());
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    static {
        Logger logger = Logger.getGlobal();
        Intrinsics.checkNotNullExpressionValue(logger, "getGlobal(...)");
        LogpanKt.logger = logger;
        Level level = Level.INFO;
        Intrinsics.checkNotNullExpressionValue(level, "INFO");
        clearLogEntry = new LogEntry(LogopAlert.GREEN, level, "");
        stacklg = new ConcurrentLinkedDeque();
    }
}

