/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.HttpClientFactoryKt;
import com.panopset.compat.HttpCommKt;
import com.panopset.compat.HttpCommMethod;
import com.panopset.compat.HttpResponsePackage;
import com.panopset.compat.Logz;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0006\u0010\u001b\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0005\u00a8\u0006\u001c"}, d2={"Lcom/panopset/compat/HttpComm;", "", "urlStr", "", "<init>", "(Ljava/lang/String;)V", "isUrlEncoded", "", "headers", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "method", "Lcom/panopset/compat/HttpCommMethod;", "postData", "getPostData", "()Ljava/lang/String;", "setPostData", "exec", "Lcom/panopset/compat/HttpResponsePackage;", "constructConnection", "Ljava/net/HttpURLConnection;", "addHeader", "", "key", "value", "readResponseFromConnection", "con", "preassemble", "compat"})
public final class HttpComm {
    @NotNull
    private final String urlStr;
    private boolean isUrlEncoded;
    @NotNull
    private final HashMap<String, String> headers;
    @NotNull
    private HttpCommMethod method;
    @NotNull
    private String postData;

    public HttpComm(@NotNull String urlStr) {
        Intrinsics.checkNotNullParameter(urlStr, "urlStr");
        this.urlStr = urlStr;
        this.headers = new HashMap();
        this.method = HttpCommMethod.GET;
        this.postData = "";
    }

    @NotNull
    public final String getPostData() {
        return this.postData;
    }

    public final void setPostData(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.postData = string;
    }

    @NotNull
    public final HttpResponsePackage exec() {
        HttpURLConnection conn = this.constructConnection();
        conn.setRequestMethod(this.method.name());
        if (((CharSequence)this.postData).length() > 0) {
            if (this.method != HttpCommMethod.POST) {
                throw new RuntimeException("Unexpected error, if your pull request is accepted, we'll send you 1000 currently worthless Panopset shares.");
            }
            OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream());
            String finalPostData = this.isUrlEncoded ? URLEncoder.encode(this.postData, StandardCharsets.UTF_8.name()) : this.postData;
            osw.write(finalPostData);
            osw.flush();
        }
        HttpResponsePackage rtn2 = this.readResponseFromConnection(conn);
        return rtn2;
    }

    private final HttpURLConnection constructConnection() {
        URL url = new URI(this.urlStr).toURL();
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection rtn2 = (HttpURLConnection)uRLConnection;
        rtn2.setConnectTimeout(HttpClientFactoryKt.getTimeout());
        Iterator<Map.Entry<String, String>> iterator2 = this.headers.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> e;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (Intrinsics.areEqual(e.getKey(), "Content-Type") && Intrinsics.areEqual(e.getValue(), "application/x-www-form-urlencoded")) {
                this.isUrlEncoded = true;
            }
            rtn2.setRequestProperty(e.getKey(), e.getValue());
        }
        this.method.panopset(rtn2, this.headers);
        return rtn2;
    }

    public final void addHeader(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        if (((Map)this.headers).containsKey(key)) {
            Logz.INSTANCE.warn("Replacing " + key + ":" + this.headers.get(value) + " with " + this.headers.get(key) + "!");
        }
        ((Map)this.headers).put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpResponsePackage readResponseFromConnection(HttpURLConnection con) {
        URL uRL = con.getURL();
        if (uRL == null) {
            return HttpCommKt.access$createEmptyURLResponse();
        }
        URL url = uRL;
        String string = url.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String urlStr = string;
        if (((CharSequence)urlStr).length() == 0) {
            return HttpCommKt.access$createEmptyURLResponse();
        }
        int conResponseCode = -1;
        try {
            InputStream ins = con.getInputStream();
            double limit = (double)Runtime.getRuntime().freeMemory() * 0.8;
            conResponseCode = con.getResponseCode();
            if (conResponseCode != 200) {
                String string2 = con.getResponseMessage();
                Intrinsics.checkNotNullExpressionValue(string2, "getResponseMessage(...)");
                HttpResponsePackage httpResponsePackage = new HttpResponsePackage(conResponseCode, "Error occurred.", string2);
                return httpResponsePackage;
            }
            InputStreamReader isr = new InputStreamReader(ins);
            BufferedReader bfr = new BufferedReader(isr);
            StringWriter sw = new StringWriter();
            String s = bfr.readLine();
            int totalSize = 0;
            while (s != null && (double)totalSize < limit) {
                totalSize += s.length();
                if ((double)s.length() > limit) {
                    HttpResponsePackage httpResponsePackage = new HttpResponsePackage(conResponseCode, HttpClientFactoryKt.constrain(s), "Exceeded 80% of available memory: " + limit);
                    return httpResponsePackage;
                }
                sw.append(s);
                sw.append("\n");
                s = bfr.readLine();
            }
            bfr.close();
            String string3 = sw.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
            HttpResponsePackage httpResponsePackage = new HttpResponsePackage(conResponseCode, string3);
            return httpResponsePackage;
        }
        catch (Throwable t) {
            HttpResponsePackage httpResponsePackage = HttpCommKt.createErrorResponse(conResponseCode, t, urlStr);
            return httpResponsePackage;
        }
        finally {
            con.disconnect();
        }
    }

    public final void preassemble() {
        if (((CharSequence)this.postData).length() > 0) {
            this.method = HttpCommMethod.POST;
        }
    }
}

