/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.HiddenFolder;
import com.panopset.compat.Logz;
import com.panopset.compat.PersistentMapFile;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0006\u0010\n\u001a\u00020\u0005\u001a\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\r"}, d2={"pmf", "Lcom/panopset/compat/PersistentMapFile;", "getPmf", "()Lcom/panopset/compat/PersistentMapFile;", "saveToFile", "", "putValue", "key", "", "value", "globalPropsFlush", "globalPropsPut", "globalPropsGet", "compat"})
public final class GlobalPropertiesKt {
    @NotNull
    private static final PersistentMapFile pmf = new PersistentMapFile(new File(HiddenFolder.INSTANCE.getFullPathRelativeTo("global.properties")));

    @NotNull
    public static final PersistentMapFile getPmf() {
        return pmf;
    }

    private static final void saveToFile() {
        pmf.flush();
    }

    private static final void putValue(String key, String value) {
        pmf.put(key, value);
    }

    public static final void globalPropsFlush() {
        try {
            GlobalPropertiesKt.saveToFile();
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
        }
    }

    public static final void globalPropsPut(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        try {
            GlobalPropertiesKt.putValue(key, value);
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
        }
    }

    @NotNull
    public static final String globalPropsGet(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter(key, "key");
        try {
            string = pmf.get(key);
        }
        catch (IOException e) {
            Logz.INSTANCE.warn(key + " not found, " + e.getMessage());
            string = "";
        }
        return string;
    }
}

