/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.Logz;
import com.panopset.compat.Nls;
import com.panopset.compat.Streamop;
import com.panopset.compat.Stringop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\fJ!\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\fJ\u0016\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\fJ\u000e\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fJ\u000e\u0010\"\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010&\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u0005J\u0016\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\fJ\u0016\u0010'\u001a\u00020\t2\u0006\u0010*\u001a\u00020)2\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005J\u0016\u0010.\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005J\u000e\u00101\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u0005J\u000e\u00104\u001a\u0002052\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u00104\u001a\u0002052\u0006\u0010\n\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010/\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0007\u00a8\u00066"}, d2={"Lcom/panopset/compat/Fileop;", "", "<init>", "()V", "userHome", "Ljava/io/File;", "getUserHome", "()Ljava/io/File;", "touch", "", "file", "getStandardPath", "", "getParentDirectory", "fileExists", "", "dirExists", "dir", "createTempFile", "fileName", "write", "strs", "", "([Ljava/lang/String;Ljava/io/File;)V", "", "str", "prepFileForWriting", "getCanonicalPath", "isFileOneOfExtensions", "extsToTry", "getExtension", "combinePaths", "dirPath", "path", "readTextFile", "filePath", "readLines", "delete", "mkdirs", "copyInputStreamToFile", "inp", "Ljava/io/InputStream;", "inputStream", "moveFile", "ff", "tf", "copyFile", "TEMP_DIRECTORY", "getTEMP_DIRECTORY", "removeExtension", "checkParent", "targetFile", "loadProps", "Ljava/util/Properties;", "compat"})
@SourceDebugExtension(value={"SMAP\nFileop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fileop.kt\ncom/panopset/compat/Fileop\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,271:1\n1#2:272\n739#3,9:273\n37#4,2:282\n108#5:284\n80#5,22:285\n*S KotlinDebug\n*F\n+ 1 Fileop.kt\ncom/panopset/compat/Fileop\n*L\n123#1:273,9\n123#1:282,2\n125#1:284\n125#1:285,22\n*E\n"})
public final class Fileop {
    @NotNull
    public static final Fileop INSTANCE = new Fileop();
    @NotNull
    private static final File userHome = new File(System.getProperty("user.home"));
    @NotNull
    private static final File TEMP_DIRECTORY = new File(Stringop.INSTANCE.getUSH() + "/Documents/temp");

    private Fileop() {
    }

    @NotNull
    public final File getUserHome() {
        return userHome;
    }

    public final void touch(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (this.prepFileForWriting(file) && !file.createNewFile()) {
            Logz.INSTANCE.warn("Unable to create " + this.getCanonicalPath(file));
        }
    }

    @NotNull
    public final String getStandardPath(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return StringsKt.replace$default(this.getCanonicalPath(file), "\\", "/", false, 4, null);
    }

    @NotNull
    public final String getParentDirectory(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (file.exists()) {
            File fullFile = new File(this.getCanonicalPath(file));
            return this.getCanonicalPath(fullFile.getParentFile());
        }
        return this.getCanonicalPath(file.getParentFile());
    }

    public final boolean fileExists(@Nullable File file) {
        return file == null ? false : file.exists() && file.isFile() && file.canRead();
    }

    public final boolean dirExists(@NotNull File dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        return dir.exists() && dir.isDirectory() && dir.canRead();
    }

    @NotNull
    public final File createTempFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return new File(this.combinePaths(Stringop.INSTANCE.getTEMP_DIR_PATH(), fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull String[] strs, @NotNull File file) {
        Intrinsics.checkNotNullParameter(strs, "strs");
        Intrinsics.checkNotNullParameter(file, "file");
        if (!this.prepFileForWriting(file)) {
            return;
        }
        try {
            Closeable closeable = new FileWriter(file);
            Throwable throwable = null;
            try {
                FileWriter fw2 = (FileWriter)closeable;
                boolean bl = false;
                Closeable closeable2 = new BufferedWriter(fw2);
                Throwable throwable2 = null;
                try {
                    BufferedWriter bw = (BufferedWriter)closeable2;
                    boolean bl2 = false;
                    for (String s : strs) {
                        bw.write(s);
                        bw.write(Stringop.INSTANCE.getEol());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull List<String> strs, @NotNull File file) {
        Intrinsics.checkNotNullParameter(strs, "strs");
        Intrinsics.checkNotNullParameter(file, "file");
        if (!this.prepFileForWriting(file)) {
            return;
        }
        try {
            Closeable closeable = new FileWriter(file);
            Throwable throwable = null;
            try {
                FileWriter fw2 = (FileWriter)closeable;
                boolean bl = false;
                Closeable closeable2 = new BufferedWriter(fw2);
                Throwable throwable2 = null;
                try {
                    BufferedWriter bw = (BufferedWriter)closeable2;
                    boolean bl2 = false;
                    for (String s : strs) {
                        bw.write(s);
                        bw.write(Stringop.INSTANCE.getEol());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull String str, @NotNull File file) {
        Intrinsics.checkNotNullParameter(str, "str");
        Intrinsics.checkNotNullParameter(file, "file");
        if (!this.prepFileForWriting(file)) {
            return;
        }
        try {
            Closeable closeable = new FileWriter(file);
            Throwable throwable = null;
            try {
                FileWriter fw2 = (FileWriter)closeable;
                boolean bl = false;
                Closeable closeable2 = new BufferedWriter(fw2);
                Throwable throwable2 = null;
                try {
                    BufferedWriter bw = (BufferedWriter)closeable2;
                    boolean bl2 = false;
                    bw.write(str);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
        }
    }

    private final boolean prepFileForWriting(File file) {
        if (Stringop.INSTANCE.isBlank(file.getPath())) {
            Logz.INSTANCE.errorMsg("Can't write to blank file path.");
            return false;
        }
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            Logz.INSTANCE.errorMsg("Unable to write to file with no parent directory.");
            return false;
        }
        file.getParentFile().mkdirs();
        return true;
    }

    @NotNull
    public final String getCanonicalPath(@Nullable File file) {
        if (file == null) {
            return "";
        }
        String string = file.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue(string, "getCanonicalPath(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isFileOneOfExtensions(@NotNull File file, @NotNull String extsToTry) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(extsToTry, "extsToTry");
        String fileExtension = this.getExtension(file);
        if (StringsKt.contains$default((CharSequence)extsToTry, ",", false, 2, null)) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            Object object = extsToTry;
            Regex regex = new Regex(",");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] exts = thisCollection$iv.toArray(new String[0]);
            int n2 = exts.length;
            for (int i = 0; i < n2; ++i) {
                String ext;
                String $this$trim$iv = ext = exts[i];
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!StringsKt.equals(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), fileExtension, true)) continue;
                return true;
            }
            return false;
        }
        return StringsKt.equals(this.getExtension(file), extsToTry, true);
    }

    @NotNull
    public final String getExtension(@NotNull String fileName) {
        String string;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        int i = StringsKt.lastIndexOf$default((CharSequence)fileName, '.', 0, false, 6, null);
        if (i > 0) {
            String string2 = fileName.substring(i + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getExtension(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return this.getExtension(string);
    }

    @NotNull
    public final String combinePaths(@NotNull String dirPath, @NotNull String path) {
        Intrinsics.checkNotNullParameter(dirPath, "dirPath");
        Intrinsics.checkNotNullParameter(path, "path");
        return this.combinePaths(new File(dirPath), path);
    }

    @NotNull
    public final String combinePaths(@NotNull File dir, @NotNull String path) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(path, "path");
        String string = "%s%s%s";
        Object[] objectArray = new Object[]{this.getCanonicalPath(dir), Stringop.INSTANCE.getFSP(), path};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public final String readTextFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        return this.readTextFile(new File(filePath));
    }

    @NotNull
    public final String readTextFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (!file.exists()) {
            String string = "File %s doesn't exist.";
            Object[] objectArray = new Object[]{this.getCanonicalPath(file)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            Logz.INSTANCE.warn(string2);
            return "";
        }
        StringWriter sw = new StringWriter();
        try {
            Streamop.INSTANCE.copyChars(new FileReader(file), sw);
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorMsg(file, (Throwable)ex);
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final List<String> readLines(@NotNull File file) {
        List list;
        Intrinsics.checkNotNullParameter(file, "file");
        if (!file.exists()) {
            Logz.INSTANCE.errorMsg("File does not exist", file);
            return new ArrayList();
        }
        try {
            list = Streamop.INSTANCE.getLinesFromReader(new FileReader(file));
        }
        catch (FileNotFoundException ex) {
            Logz.INSTANCE.errorEx(ex);
            list = new ArrayList();
        }
        return list;
    }

    public final void delete(@NotNull File file) {
        File[] files;
        Intrinsics.checkNotNullParameter(file, "file");
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            Iterator<File> iterator2 = ArrayIteratorKt.iterator(files);
            while (iterator2.hasNext()) {
                File f = iterator2.next();
                Intrinsics.checkNotNull(f);
                this.delete(f);
            }
        }
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                Logz.INSTANCE.errorEx(e);
            }
        }
    }

    public final void mkdirs(@NotNull File path) {
        Intrinsics.checkNotNullParameter(path, "path");
        if (!path.mkdirs()) {
            Logz.INSTANCE.errorMsg(Nls.INSTANCE.xlate("Unable to create path to") + "," + this.getCanonicalPath(path));
        }
    }

    public final void copyInputStreamToFile(@NotNull InputStream inp, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(inp, "inp");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        this.copyInputStreamToFile(inp, new File(fileName));
    }

    public final void copyInputStreamToFile(@NotNull InputStream inputStream, @NotNull File file) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(file, "file");
        Streamop.INSTANCE.streamToWriter(inputStream, new FileWriter(file));
    }

    public final void moveFile(@NotNull File ff, @NotNull File tf) {
        Intrinsics.checkNotNullParameter(ff, "ff");
        Intrinsics.checkNotNullParameter(tf, "tf");
        Files.move(ff.toPath(), tf.toPath(), new CopyOption[0]);
    }

    public final void copyFile(@NotNull File ff, @NotNull File tf) {
        Intrinsics.checkNotNullParameter(ff, "ff");
        Intrinsics.checkNotNullParameter(tf, "tf");
        try {
            Files.copy(ff.toPath(), tf.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Logz.INSTANCE.errorEx(e);
        }
    }

    @NotNull
    public final File getTEMP_DIRECTORY() {
        return TEMP_DIRECTORY;
    }

    @NotNull
    public final String removeExtension(@NotNull String str) {
        String string;
        Intrinsics.checkNotNullParameter(str, "str");
        int i = StringsKt.lastIndexOf$default((CharSequence)str, ".", 0, false, 6, null);
        if (i > -1) {
            String string2 = str.substring(0, i);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        } else {
            string = str;
        }
        return string;
    }

    public final boolean checkParent(@NotNull File targetFile) {
        Intrinsics.checkNotNullParameter(targetFile, "targetFile");
        File parent = targetFile.getParentFile();
        return parent.exists() ? true : parent.mkdirs();
    }

    @NotNull
    public final Properties loadProps(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return this.loadProps(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Properties loadProps(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        Properties rtn2 = new Properties();
        try {
            Closeable closeable = new FileReader(file);
            Throwable throwable = null;
            try {
                FileReader fileReader = (FileReader)closeable;
                boolean bl = false;
                Closeable closeable2 = new BufferedReader(fileReader);
                Throwable throwable2 = null;
                try {
                    BufferedReader it = (BufferedReader)closeable2;
                    boolean bl2 = false;
                    rtn2.load(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception ex) {
            Logz.INSTANCE.errorMsg(file, (Throwable)ex);
        }
        return rtn2;
    }
}

