/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.Fileop;
import com.panopset.compat.Nls;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0017"}, d2={"summit", "", "fis", "Ljava/io/FileInputStream;", "algorithm", "digestFromStream", "md", "Ljava/security/MessageDigest;", "convertBytesToHex", "byts", "", "convertBytToHex", "byt", "", "getDigestOf", "file", "Ljava/io/File;", "byteCount", "md5", "sha1", "sha256", "sha384", "sha512", "compat"})
@SourceDebugExtension(value={"SMAP\nChecksumFun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChecksumFun.kt\ncom/panopset/compat/ChecksumFunKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class ChecksumFunKt {
    private static final String summit(FileInputStream fis, String algorithm) {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        Intrinsics.checkNotNull(md);
        return ChecksumFunKt.digestFromStream(md, fis);
    }

    private static final String digestFromStream(MessageDigest md, FileInputStream fis) {
        byte[] dataBytes = new byte[1024];
        int nread = 0;
        while (true) {
            int n;
            int it = n = fis.read(dataBytes);
            boolean bl = false;
            nread = it;
            if (n == -1) break;
            md.update(dataBytes, 0, nread);
        }
        byte[] mdbytes = md.digest();
        Intrinsics.checkNotNull(mdbytes);
        return ChecksumFunKt.convertBytesToHex(mdbytes);
    }

    @NotNull
    public static final String convertBytesToHex(@NotNull byte[] byts) {
        Intrinsics.checkNotNullParameter(byts, "byts");
        StringBuilder sb = new StringBuilder();
        for (byte byt : byts) {
            sb.append(ChecksumFunKt.convertBytToHex(byt));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public static final String convertBytToHex(byte byt) {
        String string = Integer.toString((byt & 0xFF) + 256, CharsKt.checkRadix(16));
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String string2 = string.substring(1);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return string2;
    }

    private static final String getDigestOf(File file, String algorithm) {
        return Files.isReadable(file.toPath()) ? ChecksumFunKt.summit(new FileInputStream(file), algorithm) : Nls.INSTANCE.xlate("Can not read") + " " + Fileop.INSTANCE.getCanonicalPath(file);
    }

    @NotNull
    public static final String byteCount(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        String string = "%,d";
        Object[] objectArray = new Object[]{file.length()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public static final String md5(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return ChecksumFunKt.getDigestOf(file, "MD5");
    }

    @NotNull
    public static final String sha1(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return ChecksumFunKt.getDigestOf(file, "SHA-1");
    }

    @NotNull
    public static final String sha256(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return ChecksumFunKt.getDigestOf(file, "SHA-256");
    }

    @NotNull
    public static final String sha384(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return ChecksumFunKt.getDigestOf(file, "SHA-384");
    }

    @NotNull
    public static final String sha512(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return ChecksumFunKt.getDigestOf(file, "SHA-512");
    }
}

