/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.Card;
import com.panopset.blackjackEngine.CardDefinition;
import com.panopset.blackjackEngine.Deck;
import com.panopset.blackjackEngine.DeckPile;
import com.panopset.compat.Logz;
import com.panopset.compat.Randomop;
import com.panopset.compat.Streamop;
import com.panopset.compat.Stringop;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tJ\u0019\u0010\u001c\u001a\u00020\u00162\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010\u001f\u001a\u00020\u00162\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00140 J\u0018\u0010!\u001a\u00020\u00162\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0 H\u0002J\u0006\u0010\"\u001a\u00020\u0003J\u0006\u0010#\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/panopset/blackjackEngine/Shoe;", "", "numberOfDecks", "", "<init>", "(I)V", "getNumberOfDecks", "()I", "stackedDeck", "", "getStackedDeck", "()Ljava/lang/String;", "setStackedDeck", "(Ljava/lang/String;)V", "value", "", "isBlue", "()Z", "cards", "", "Lcom/panopset/blackjackEngine/Card;", "shuffle", "", "deal", "cut", "stackedDeckForTesting", "isTheDeckStacked", "stackTheDeckFromDeckStacker", "stackTheDeckFromArray", "", "([Ljava/lang/String;)V", "stackTheDeckFromList", "", "sddx", "remaining", "dumpStack", "blackjackEngine"})
public final class Shoe {
    private final int numberOfDecks;
    @NotNull
    private String stackedDeck;
    private boolean isBlue;
    @NotNull
    private final List<Card> cards;
    @NotNull
    private final List<Card> stackedDeckForTesting;

    public Shoe(int numberOfDecks) {
        this.numberOfDecks = numberOfDecks;
        this.stackedDeck = "";
        this.cards = new ArrayList();
        this.stackedDeckForTesting = new ArrayList();
        this.shuffle();
    }

    public final int getNumberOfDecks() {
        return this.numberOfDecks;
    }

    @NotNull
    public final String getStackedDeck() {
        return this.stackedDeck;
    }

    public final void setStackedDeck(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.stackedDeck = string;
    }

    public final boolean isBlue() {
        return this.isBlue;
    }

    public final void shuffle() {
        this.cards.clear();
        this.isBlue = DeckPile.INSTANCE.pull();
        List decks = new ArrayList();
        int n = this.numberOfDecks;
        for (int i = 0; i < n; ++i) {
            decks.add(new Deck(this.isBlue));
        }
        while (!((Collection)decks).isEmpty()) {
            int deckIndex = Randomop.INSTANCE.random(0, decks.size() - 1);
            Deck randomDeck = (Deck)decks.get(deckIndex);
            this.cards.add(randomDeck.deal());
            if (randomDeck.remaining() != 0) continue;
            decks.remove(deckIndex);
        }
        if (Stringop.INSTANCE.isPopulated(this.stackedDeck)) {
            this.stackTheDeckFromDeckStacker(this.stackedDeck);
        }
    }

    @NotNull
    public final Card deal() {
        if (!((Collection)this.stackedDeckForTesting).isEmpty()) {
            Logz.INSTANCE.warn("Stacked deck in use, for testing.");
            return this.stackedDeckForTesting.remove(0);
        }
        if (this.cards.size() < this.cut()) {
            this.shuffle();
        }
        return this.cards.remove(0);
    }

    public final int cut() {
        return 20;
    }

    public final boolean isTheDeckStacked() {
        return !((Collection)this.stackedDeckForTesting).isEmpty();
    }

    public final void stackTheDeckFromDeckStacker(@NotNull String stackedDeck) {
        Intrinsics.checkNotNullParameter(stackedDeck, "stackedDeck");
        this.sddx((List<String>)Streamop.INSTANCE.getLinesFromReader(new StringReader(stackedDeck)));
    }

    public final void stackTheDeckFromArray(@NotNull String[] stackedDeck) {
        Intrinsics.checkNotNullParameter(stackedDeck, "stackedDeck");
        this.sddx(Stringop.INSTANCE.arrayToList(stackedDeck));
    }

    public final void stackTheDeckFromList(@NotNull List<Card> stackedDeck) {
        Intrinsics.checkNotNullParameter(stackedDeck, "stackedDeck");
        this.stackedDeckForTesting.clear();
        this.stackedDeckForTesting.addAll((Collection<Card>)stackedDeck);
    }

    private final void sddx(List<String> stackedDeck) {
        List shoeCards = new ArrayList();
        for (String s : stackedDeck) {
            CardDefinition cd;
            CardDefinition cardDefinition = cd = CardDefinition.Companion.find(s);
            Intrinsics.checkNotNull((Object)cardDefinition);
            shoeCards.add(new Card(cardDefinition, false, 2, null));
        }
        this.stackTheDeckFromList(shoeCards);
    }

    public final int remaining() {
        return this.cards.size();
    }

    @NotNull
    public final String dumpStack() {
        StringWriter sw = new StringWriter();
        for (Card card : this.stackedDeckForTesting) {
            String string = "<<%s";
            Object[] objectArray = new Object[]{card};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            sw.append(string2);
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

