/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackCard;
import com.panopset.blackjackEngine.Hand;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\nJ\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/panopset/blackjackEngine/HandDealer;", "", "<init>", "()V", "dealer", "(Lcom/panopset/blackjackEngine/HandDealer;)V", "hand", "Lcom/panopset/blackjackEngine/Hand;", "getCards", "", "Lcom/panopset/blackjackEngine/BlackjackCard;", "isFinal", "", "hasCards", "dealCard", "", "blackjackCard", "getHandValue", "", "getFirstCard", "getSecondCard", "isSoft", "stand", "isNatural21", "upCard", "getUpCard", "()Lcom/panopset/blackjackEngine/BlackjackCard;", "downCard", "getDownCard", "blackjackEngine"})
public final class HandDealer {
    @NotNull
    private final Hand hand;

    public HandDealer() {
        this.hand = new Hand();
    }

    public HandDealer(@NotNull HandDealer dealer) {
        Intrinsics.checkNotNullParameter(dealer, "dealer");
        this();
        Iterator<BlackjackCard> iterator2 = dealer.hand.getIterator();
        ArrayList<BlackjackCard> cardsToAddToHand = new ArrayList<BlackjackCard>();
        while (iterator2.hasNext()) {
            BlackjackCard card = iterator2.next();
            cardsToAddToHand.add(card);
        }
        Iterator iterator3 = cardsToAddToHand.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
        Iterator iterator4 = iterator3;
        while (iterator4.hasNext()) {
            BlackjackCard card = (BlackjackCard)iterator4.next();
            this.hand.getCards().add(card);
        }
    }

    @NotNull
    public final List<BlackjackCard> getCards() {
        return this.hand.getCards();
    }

    public final boolean isFinal() {
        return this.hand.isFinal();
    }

    public final boolean hasCards() {
        return this.hand.hasCards();
    }

    public final void dealCard(@NotNull BlackjackCard blackjackCard) {
        Intrinsics.checkNotNullParameter(blackjackCard, "blackjackCard");
        this.hand.dealCard(blackjackCard);
    }

    public final int getHandValue() {
        return this.hand.getValue();
    }

    @NotNull
    public final BlackjackCard getFirstCard() {
        return this.hand.getCards().get(0);
    }

    @NotNull
    public final BlackjackCard getSecondCard() {
        return this.hand.getCards().get(1);
    }

    public final boolean isSoft() {
        return this.hand.isSoft();
    }

    public final void stand() {
        this.hand.stand();
    }

    public final boolean isNatural21() {
        return this.hand.isNatural21();
    }

    @NotNull
    public final BlackjackCard getUpCard() {
        return this.hand.getCards().get(1);
    }

    @NotNull
    public final BlackjackCard getDownCard() {
        return this.hand.getCards().get(0);
    }
}

