/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackCard;
import com.panopset.blackjackEngine.BlackjackConfiguration;
import com.panopset.blackjackEngine.Configurable;
import com.panopset.blackjackEngine.CountingSystem;
import com.panopset.compat.Logz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0017J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0017J\u000e\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\bJ\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\bH\u0002J\u000e\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0017J\u0006\u0010'\u001a\u00020\tJ\b\u0010(\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0006\u0010*\u001a\u00020\u0015J\u0006\u0010+\u001a\u00020\u0015R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\n\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\t0\t \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010&\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/panopset/blackjackEngine/CountingSystems;", "Lcom/panopset/blackjackEngine/Configurable;", "blackjackConfiguration", "Lcom/panopset/blackjackEngine/BlackjackConfiguration;", "<init>", "(Lcom/panopset/blackjackEngine/BlackjackConfiguration;)V", "systemCatalog", "", "", "Lcom/panopset/blackjackEngine/CountingSystem;", "keys", "Ljava/util/SortedSet;", "kotlin.jvm.PlatformType", "Ljava/util/SortedSet;", "keyNames", "Ljava/util/ArrayList;", "getKeyNames", "()Ljava/util/ArrayList;", "setKeyNames", "(Ljava/util/ArrayList;)V", "populateKeyNames", "", "getTrueCount", "", "count", "blackjackCard", "Lcom/panopset/blackjackEngine/BlackjackCard;", "populate", "setSystemByKeyNamePosition", "position", "updateByIndex", "i", "getKeyNamePosition", "keyName", "findSelectionNbr", "key", "findSelectionKey", "selection", "selected", "findSelected", "pointOfNoReturn", "setCountingSystem", "resetCount", "reset", "blackjackEngine"})
public final class CountingSystems
extends Configurable {
    @NotNull
    private Map<String, CountingSystem> systemCatalog;
    private SortedSet<CountingSystem> keys;
    @NotNull
    private ArrayList<String> keyNames;
    @Nullable
    private CountingSystem selected;

    public CountingSystems(@NotNull BlackjackConfiguration blackjackConfiguration) {
        Intrinsics.checkNotNullParameter(blackjackConfiguration, "blackjackConfiguration");
        super(blackjackConfiguration);
        SortedMap sortedMap = Collections.synchronizedSortedMap(new TreeMap());
        Intrinsics.checkNotNullExpressionValue(sortedMap, "synchronizedSortedMap(...)");
        this.systemCatalog = sortedMap;
        this.keys = Collections.synchronizedSortedSet(new TreeSet());
        this.keyNames = new ArrayList();
        this.populate();
        this.populateKeyNames();
        this.selected = this.systemCatalog.get("Hi-Lo");
    }

    @NotNull
    public final ArrayList<String> getKeyNames() {
        return this.keyNames;
    }

    public final void setKeyNames(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.keyNames = arrayList;
    }

    private final void populateKeyNames() {
        Iterator<Map.Entry<String, CountingSystem>> iterator2 = this.systemCatalog.entrySet().iterator();
        while (iterator2.hasNext()) {
            CountingSystem value = iterator2.next().getValue();
            this.keys.add(value);
        }
        for (CountingSystem cs : this.keys) {
            this.keyNames.add(cs.getName());
        }
    }

    public final int getTrueCount() {
        return this.findSelected().getCount();
    }

    public final void count(@NotNull BlackjackCard blackjackCard) {
        Intrinsics.checkNotNullParameter(blackjackCard, "blackjackCard");
        this.findSelected().count(blackjackCard);
    }

    private final void populate() {
        this.systemCatalog.clear();
        int index = 0;
        Iterator<String> iterator2 = this.getBlackjackConfiguration().getCountingSystemData().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String dta;
            String s;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (s.length() <= 31 || StringsKt.indexOf$default((CharSequence)s, "#", 0, false, 6, null) == 0) continue;
            String string = s.substring(30);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String key = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Intrinsics.checkNotNullExpressionValue(s.substring(0, 30), "substring(...)");
            this.systemCatalog.put(key, new CountingSystem(key, dta, index++));
        }
    }

    public final void setSystemByKeyNamePosition(int position) {
        this.setCountingSystem(position);
    }

    public final void updateByIndex(int i) {
        this.setSystemByKeyNamePosition(i);
    }

    public final int getKeyNamePosition(@NotNull String keyName) {
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        return this.findSelectionNbr(keyName);
    }

    private final int findSelectionNbr(String key) {
        Iterator<Map.Entry<String, CountingSystem>> iterator2 = this.systemCatalog.entrySet().iterator();
        while (iterator2.hasNext()) {
            CountingSystem value = iterator2.next().getValue();
            if (!Intrinsics.areEqual(value.getName(), key)) continue;
            return value.getSelection();
        }
        return this.findSelectionNbr("Hi-Lo");
    }

    @NotNull
    public final String findSelectionKey(int selection) {
        Iterator<Map.Entry<String, CountingSystem>> iterator2 = this.systemCatalog.entrySet().iterator();
        while (iterator2.hasNext()) {
            CountingSystem value = iterator2.next().getValue();
            if (value.getSelection() != selection) continue;
            return value.getName();
        }
        return "Hi-Lo";
    }

    @NotNull
    public final CountingSystem findSelected() {
        CountingSystem countingSystem = this.selected;
        if (countingSystem == null && (countingSystem = this.systemCatalog.get("Hi-Lo")) == null) {
            countingSystem = this.pointOfNoReturn();
        }
        return countingSystem;
    }

    private final CountingSystem pointOfNoReturn() {
        Logz.INSTANCE.errorMsg("Failed to load counting systems from resource cs.txt.");
        return new CountingSystem("Hi-Lo", "+1 +1 +1 +1 +1  0  0  0 -1 -1 Hi-Lo", 4);
    }

    private final void setCountingSystem(int position) {
        this.selected = this.systemCatalog.get(this.findSelectionKey(position));
    }

    public final void resetCount() {
        this.findSelected().resetCount();
    }

    public final void reset() {
        this.populate();
        this.selected = this.systemCatalog.get("Hi-Lo");
        this.resetCount();
    }
}

