/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.games.blackjack;

import com.panopset.blackjackEngine.BlackjackConfigDefault;
import com.panopset.blackjackEngine.BlackjackGameEngine;
import com.panopset.compat.Logz;
import com.panopset.compat.Stringop;
import com.panopset.desk.games.bj.BlackjackFxControls;
import com.panopset.fxapp.FxDoc;
import java.util.ArrayList;
import javafx.scene.control.TextArea;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/panopset/marin/games/blackjack/BlackjackGameEngineFactory;", "", "<init>", "()V", "create", "Lcom/panopset/blackjackEngine/BlackjackGameEngine;", "ctls", "Lcom/panopset/desk/games/bj/BlackjackFxControls;", "desk"})
public final class BlackjackGameEngineFactory {
    @NotNull
    public final BlackjackGameEngine create(@NotNull BlackjackFxControls ctls) {
        Intrinsics.checkNotNullParameter(ctls, "ctls");
        FxDoc fxDoc = ctls.getFxDoc();
        BlackjackConfigDefault blackjackConfigDefault = new BlackjackConfigDefault(ctls){
            private final BlackjackConfigDefault blackjackConfigDefault;
            final /* synthetic */ BlackjackFxControls $ctls;
            {
                this.$ctls = $ctls;
                this.blackjackConfigDefault = new BlackjackConfigDefault();
            }

            public final BlackjackConfigDefault getBlackjackConfigDefault() {
                return this.blackjackConfigDefault;
            }

            public boolean isDoubleAfterSplitAllowed() {
                return this.$ctls.getDoubleAfterSplit().isSelected();
            }

            public boolean isResplitAcesAllowed() {
                return this.$ctls.getResplitAces().isSelected();
            }

            public ArrayList<String> getStrategyData() {
                ArrayList<String> dft = super.getStrategyData();
                TextArea ta = this.$ctls.getTaBasicStrategy();
                String text = ta.getText();
                if (Stringop.INSTANCE.isBlank(text)) {
                    return dft;
                }
                Intrinsics.checkNotNull(text);
                ArrayList<String> rtn2 = Stringop.INSTANCE.stringToList(text);
                if (!Intrinsics.areEqual(rtn2, dft)) {
                    Logz.INSTANCE.warn("Custom (or out of date) strategy data in use.  Go to config to reset.");
                }
                return rtn2;
            }

            public void setStrategyData(ArrayList<String> strategyData) {
                Intrinsics.checkNotNullParameter(strategyData, "strategyData");
                super.setStrategyData(strategyData);
            }

            public ArrayList<String> getCountingSystemData() {
                ArrayList<String> dft = super.getCountingSystemData();
                TextArea ta = this.$ctls.getTaCountingSystems();
                String text = ta.getText();
                if (Stringop.INSTANCE.isBlank(text)) {
                    return dft;
                }
                Intrinsics.checkNotNull(text);
                ArrayList<String> rtn2 = Stringop.INSTANCE.stringToList(text);
                if (!Intrinsics.areEqual(rtn2, dft)) {
                    Logz.INSTANCE.warn("Custom (or out of date) counting system data in use.  Go to config to reset.");
                }
                return rtn2;
            }

            public void setCountingSystemData(ArrayList<String> countingSystemData) {
                Intrinsics.checkNotNullParameter(countingSystemData, "countingSystemData");
                super.setCountingSystemData(countingSystemData);
            }

            public int getSeats() {
                String string = this.$ctls.getCbSeats().getValue();
                Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
                return Stringop.INSTANCE.parseInt(string, 1);
            }

            public int getDecks() {
                String string = this.$ctls.getCbDecks().getValue();
                Intrinsics.checkNotNullExpressionValue(string, "getValue(...)");
                return Stringop.INSTANCE.parseInt(string, 1);
            }

            public boolean isDealerHitSoft17() {
                return this.$ctls.getDealerHitsSoft17().isSelected();
            }

            public boolean isBlackjack6to5() {
                return this.$ctls.getRule65().isSelected();
            }

            public boolean isEvenMoneyOnBlackjackVace() {
                return this.$ctls.getRuleEvenMoney().isSelected();
            }

            public boolean isLateSurrenderAllowed() {
                return this.$ctls.getRuleLateSurrender().isSelected();
            }

            public boolean isEuropeanStyle() {
                return this.$ctls.getRuleEuropeanStyle().isSelected();
            }

            public boolean isFastDeal() {
                return this.$ctls.getRuleFastDeal().isSelected();
            }

            public boolean isBasicStrategyVariationsOnly() {
                return this.$ctls.getRuleVariations().isSelected();
            }

            public boolean isShowCount() {
                return this.$ctls.getRuleShowCount().isSelected();
            }

            public void setShowCount(boolean isShowCount) {
                super.setShowCount(isShowCount);
            }

            public void toggleShowCount() {
                this.$ctls.getRuleShowCount().setSelected(!this.$ctls.getRuleShowCount().isSelected());
            }

            public int getLargeBetInWholeDollars() {
                String string = this.$ctls.getLargeBet().getText();
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                return Stringop.INSTANCE.parseInt(string, this.blackjackConfigDefault.getLargeBetInWholeDollars());
            }

            public int getTargetStakeInWholeDollars() {
                String string = this.$ctls.getTargetStake().getText();
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                return Stringop.INSTANCE.parseInt(string, this.blackjackConfigDefault.getTargetStakeInWholeDollars());
            }

            public int getMinimumBetInWholeDollars() {
                String string = this.$ctls.getMinimumBet().getText();
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                return Stringop.INSTANCE.parseInt(string, this.blackjackConfigDefault.getMinimumBetInWholeDollars());
            }

            public int getBetIncrementInWholeDollars() {
                String string = this.$ctls.getMinimumBet().getText();
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                return Stringop.INSTANCE.parseInt(string, this.blackjackConfigDefault.getBetIncrementInWholeDollars());
            }

            public int getReloadAmountInWholeDollars() {
                String string = this.$ctls.getReloadAmount().getText();
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                return Stringop.INSTANCE.parseInt(string, this.blackjackConfigDefault.getReloadAmountInWholeDollars());
            }

            public int getStrategicVeryPositiveCount() {
                String rtn2 = this.$ctls.getCountPositive().getText();
                Intrinsics.checkNotNull(rtn2);
                if (((CharSequence)rtn2).length() == 0) {
                    return super.getStrategicVeryPositiveCount();
                }
                return Integer.parseInt(rtn2);
            }

            public int getStrategicVeryNegativeCount() {
                String rtn2 = this.$ctls.getCountNegative().getText();
                Intrinsics.checkNotNull(rtn2);
                if (((CharSequence)rtn2).length() == 0) {
                    return super.getStrategicVeryNegativeCount();
                }
                return Integer.parseInt(rtn2);
            }

            public boolean isBetIdeaDoubleAfterBust() {
                return this.$ctls.getBetIdeaDoubleAfterBust().isSelected();
            }

            public boolean isBetIdeaLetItRideAfterTwoWins() {
                return this.$ctls.getBetideaLetItRide().isSelected();
            }
        };
        BlackjackGameEngine rtn2 = new BlackjackGameEngine(ctls, fxDoc, blackjackConfigDefault){
            final /* synthetic */ BlackjackFxControls $ctls;
            {
                this.$ctls = $ctls;
                super($super_call_param$1, $super_call_param$2);
            }

            public void exec(String action) {
                Intrinsics.checkNotNullParameter(action, "action");
                super.exec(action);
                this.$ctls.update();
            }
        };
        return rtn2;
    }
}

