/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.games.blackjack;

import com.panopset.blackjackEngine.BlackjackGameEngine;
import com.panopset.blackjackEngine.CycleSnapshot;
import com.panopset.compat.LogDisplayer;
import com.panopset.compat.Zombie;
import com.panopset.desk.games.bj.BlackjackFxControls;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.fxapp.FxDoc;
import com.panopset.marin.games.blackjack.FeltPainter;
import java.util.Locale;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.KeyEvent;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010'\u001a\u00020\u0015H\u0002J\b\u0010(\u001a\u00020\u001bH\u0002J\u0006\u0010)\u001a\u00020\u0015J\n\u0010+\u001a\u0004\u0018\u00010\u001dH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010*\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/panopset/marin/games/blackjack/BlackjackGameController;", "", "ctls", "Lcom/panopset/desk/games/bj/BlackjackFxControls;", "<init>", "(Lcom/panopset/desk/games/bj/BlackjackFxControls;)V", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "getFxDoc", "()Lcom/panopset/fxapp/FxDoc;", "bge", "Lcom/panopset/blackjackEngine/BlackjackGameEngine;", "getBge", "()Lcom/panopset/blackjackEngine/BlackjackGameEngine;", "felt", "Ljavafx/scene/canvas/Canvas;", "getFelt", "()Ljavafx/scene/canvas/Canvas;", "setFelt", "(Ljavafx/scene/canvas/Canvas;)V", "handleKey", "", "keyEvent", "Ljavafx/scene/input/KeyEvent;", "fontSize", "", "gameStarted", "", "paintedSnapshot", "Lcom/panopset/blackjackEngine/CycleSnapshot;", "dirty", "timer", "Ljavafx/animation/AnimationTimer;", "lastUpdate", "", "getLastUpdate", "()J", "setLastUpdate", "(J)V", "startPaintCycle", "isDirty", "update", "binding", "paintFelt", "fp", "Lcom/panopset/marin/games/blackjack/FeltPainter;", "desk"})
public final class BlackjackGameController {
    @NotNull
    private final FxDoc fxDoc;
    @NotNull
    private final BlackjackGameEngine bge;
    @NotNull
    private Canvas felt;
    private int fontSize;
    private boolean gameStarted;
    @Nullable
    private CycleSnapshot paintedSnapshot;
    private boolean dirty;
    @NotNull
    private AnimationTimer timer;
    private long lastUpdate;
    private boolean binding;
    @NotNull
    private FeltPainter fp;

    public BlackjackGameController(@NotNull BlackjackFxControls ctls) {
        Intrinsics.checkNotNullParameter(ctls, "ctls");
        this.fxDoc = ctls.getFxDoc();
        this.bge = ctls.getBge();
        this.felt = new Canvas();
        Zombie.INSTANCE.addStopAction(() -> BlackjackGameController._init_$lambda$0(this));
        if (this.bge.getBankroll().getReloadAmount() == 0) {
            this.bge.frontEndPreInitCheck();
        }
        this.startPaintCycle();
        this.dirty = true;
        this.timer = new AnimationTimer(this){
            final /* synthetic */ BlackjackGameController this$0;
            {
                this.this$0 = $receiver;
            }

            public void handle(long now) {
                if (now - this.this$0.getLastUpdate() > 5000000L) {
                    BlackjackGameController.access$paintFelt(this.this$0);
                    this.this$0.setLastUpdate(now);
                }
            }
        };
        this.fp = new FeltPainter();
    }

    @NotNull
    public final FxDoc getFxDoc() {
        return this.fxDoc;
    }

    @NotNull
    public final BlackjackGameEngine getBge() {
        return this.bge;
    }

    @NotNull
    public final Canvas getFelt() {
        return this.felt;
    }

    public final void setFelt(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter(canvas, "<set-?>");
        this.felt = canvas;
    }

    private final void handleKey(KeyEvent keyEvent) {
        String string = keyEvent.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        String action = string3;
        if (this.bge.isAutomaticRunning() && !Intrinsics.areEqual(action, "t")) {
            this.bge.exec("t");
            return;
        }
        this.bge.exec(action);
    }

    public final long getLastUpdate() {
        return this.lastUpdate;
    }

    public final void setLastUpdate(long l) {
        this.lastUpdate = l;
    }

    private final void startPaintCycle() {
        Platform.runLater(() -> BlackjackGameController.startPaintCycle$lambda$1(this));
    }

    private final boolean isDirty() {
        if (!this.dirty) {
            if (!Intrinsics.areEqual(this.paintedSnapshot, this.bge.getLastActionSnapshot())) {
                this.paintedSnapshot = this.bge.getLastActionSnapshot();
                this.dirty = true;
            }
            if (this.fontSize != FontManagerFX.INSTANCE.getSize()) {
                this.fontSize = FontManagerFX.INSTANCE.getSize();
                this.dirty = true;
            }
        }
        return this.dirty;
    }

    public final void update() {
        this.dirty = true;
    }

    private final CycleSnapshot paintFelt() {
        if (this.binding) {
            return null;
        }
        int layoutHeight = (int)this.felt.getParent().getLayoutBounds().getHeight();
        int layoutWidth = (int)this.felt.getParent().getLayoutBounds().getWidth();
        if (layoutHeight < 10 || layoutWidth < 10) {
            return null;
        }
        this.felt.setWidth(layoutWidth);
        this.felt.setHeight(layoutHeight);
        GraphicsContext g = this.felt.getGraphicsContext2D();
        if (!Zombie.INSTANCE.isActive()) {
            g.setFill(Color.DARKRED);
            g.fillRect(0.0, 0.0, layoutWidth, layoutHeight);
            return null;
        }
        CycleSnapshot rtn2 = this.bge.getLastActionSnapshot();
        if (!this.gameStarted) {
            this.felt.getScene().setOnKeyPressed(arg_0 -> BlackjackGameController.paintFelt$lambda$2(this, arg_0));
            this.gameStarted = true;
        }
        if (!this.isDirty()) {
            return null;
        }
        LogDisplayer logDisplayer = this.fxDoc;
        Intrinsics.checkNotNull(g);
        this.fp.draw(logDisplayer, rtn2, g, layoutWidth, layoutHeight);
        this.dirty = false;
        return rtn2;
    }

    private static final void _init_$lambda$0(BlackjackGameController this$0) {
        this$0.timer.stop();
    }

    private static final void startPaintCycle$lambda$1(BlackjackGameController this$0) {
        this$0.timer.start();
    }

    private static final void paintFelt$lambda$2(BlackjackGameController this$0, KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter(keyEvent, "keyEvent");
        this$0.handleKey(keyEvent);
    }

    public static final /* synthetic */ CycleSnapshot access$paintFelt(BlackjackGameController $this) {
        return $this.paintFelt();
    }
}

