/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.gp;

import com.panopset.compat.Logz;
import com.panopset.gp.TextFileProcessor;
import com.panopset.gp.TextFileProcessorKt;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/panopset/gp/FileCompare;", "", "<init>", "()V", "filesAreSame", "", "one", "Ljava/io/File;", "two", "flywheel"})
public final class FileCompare {
    @NotNull
    public static final FileCompare INSTANCE = new FileCompare();

    private FileCompare() {
    }

    public final boolean filesAreSame(@NotNull File one, @NotNull File two) {
        Intrinsics.checkNotNullParameter(one, "one");
        Intrinsics.checkNotNullParameter(two, "two");
        try {
            TextFileProcessor tfp1 = TextFileProcessorKt.textFileIterator(one);
            TextFileProcessor tfp2 = TextFileProcessorKt.textFileIterator(two);
            while (tfp1.hasNext() && tfp2.hasNext()) {
                String str2;
                String str1 = tfp1.next();
                if (Intrinsics.areEqual(str1, str2 = tfp2.next())) continue;
                String string = "str1: %s\n         str2: %s";
                Object[] objectArray = new Object[]{str1, str2};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                Logz.INSTANCE.warn(string2);
                return false;
            }
            if (tfp1.hasNext() || tfp2.hasNext()) {
                return false;
            }
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
        }
        return true;
    }
}

