/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.fxapp;

import com.panopset.compat.HexopsKt;
import com.panopset.compat.Logz;
import com.panopset.compat.Stringop;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanComponentFactoryKt;
import java.util.HashMap;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0017j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/panopset/fxapp/ReturnCharTitledPane;", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "<init>", "(Lcom/panopset/fxapp/FxDoc;)V", "getFxDoc", "()Lcom/panopset/fxapp/FxDoc;", "pane", "Ljavafx/scene/control/TitledPane;", "getPane", "()Ljavafx/scene/control/TitledPane;", "tg", "Ljavafx/scene/control/ToggleGroup;", "returnCharactersDoNothing", "Ljavafx/scene/control/RadioButton;", "windowsToUnix", "unixToWindows", "showUpdate", "", "getSelectedReturnCharacter", "", "cacheMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getSelectionDescription", "createReturnCharacterDescription", "rc", "fxapp"})
public final class ReturnCharTitledPane {
    @NotNull
    private final FxDoc fxDoc;
    @NotNull
    private final TitledPane pane;
    @NotNull
    private final ToggleGroup tg;
    @NotNull
    private final RadioButton returnCharactersDoNothing;
    @NotNull
    private final RadioButton windowsToUnix;
    @NotNull
    private final RadioButton unixToWindows;
    @NotNull
    private final HashMap<String, String> cacheMap;

    public ReturnCharTitledPane(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.fxDoc = fxDoc;
        this.pane = PanComponentFactoryKt.createPanTitledPane("Return Characters");
        this.tg = new ToggleGroup();
        this.returnCharactersDoNothing = PanComponentFactoryKt.createPanRadioButton(this.tg, "fxidReturnCharactersDoNothing", this.fxDoc, "Do nothing   ", "System return characters.");
        this.windowsToUnix = PanComponentFactoryKt.createPanRadioButton(this.tg, "fxidWindowsToUnix", this.fxDoc, "lf   ", "UNIX style line breaks, aka \\n.");
        this.unixToWindows = PanComponentFactoryKt.createPanRadioButton(this.tg, "fxidUnixToWindows", this.fxDoc, "crlf   ", "Windows style line breaks, aka \\r\\n.");
        this.returnCharactersDoNothing.setOnAction(arg_0 -> ReturnCharTitledPane._init_$lambda$0(this, arg_0));
        this.windowsToUnix.setOnAction(arg_0 -> ReturnCharTitledPane._init_$lambda$1(this, arg_0));
        this.unixToWindows.setOnAction(arg_0 -> ReturnCharTitledPane._init_$lambda$2(this, arg_0));
        this.cacheMap = new HashMap();
        this.pane.setTooltip(new Tooltip("Use this control panel to force a specific line separator. If do nothing is selected, the system line separator will be used."));
        Node[] nodeArray = new Node[]{this.returnCharactersDoNothing, this.windowsToUnix, this.unixToWindows};
        this.pane.setContent(PanComponentFactoryKt.createPanHBox(nodeArray));
        if (!(this.returnCharactersDoNothing.isSelected() || this.windowsToUnix.isSelected() || this.unixToWindows.isSelected())) {
            this.returnCharactersDoNothing.setSelected(true);
        }
    }

    @NotNull
    public final FxDoc getFxDoc() {
        return this.fxDoc;
    }

    @NotNull
    public final TitledPane getPane() {
        return this.pane;
    }

    private final void showUpdate() {
        Stringop.INSTANCE.setEol(this.getSelectedReturnCharacter());
        Logz.INSTANCE.info("Selected return character is now " + this.getSelectionDescription());
    }

    private final String getSelectedReturnCharacter() {
        if (this.tg.getSelectedToggle() == this.returnCharactersDoNothing) {
            return Stringop.INSTANCE.getEol();
        }
        if (this.tg.getSelectedToggle() == this.windowsToUnix) {
            return "\n";
        }
        if (this.tg.getSelectedToggle() == this.unixToWindows) {
            return "\r\n";
        }
        return Stringop.INSTANCE.getEol();
    }

    /*
     * WARNING - void declaration
     */
    private final String getSelectionDescription() {
        String string;
        String rc = this.getSelectedReturnCharacter();
        if (this.cacheMap.containsKey(rc)) {
            string = this.cacheMap.get(rc);
            if (string == null) {
                string = this.createReturnCharacterDescription(rc);
            }
        } else {
            void var2_2;
            String rtn2 = this.createReturnCharacterDescription(rc);
            ((Map)this.cacheMap).put(rc, rtn2);
            string = var2_2;
        }
        return string;
    }

    private final String createReturnCharacterDescription(String rc) {
        return "\"" + HexopsKt.panStringToBackSlashes(rc) + "\", hex: " + HexopsKt.panStringToHex(rc) + ".";
    }

    private static final void _init_$lambda$0(ReturnCharTitledPane this$0, ActionEvent it) {
        this$0.showUpdate();
    }

    private static final void _init_$lambda$1(ReturnCharTitledPane this$0, ActionEvent it) {
        this$0.showUpdate();
    }

    private static final void _init_$lambda$2(ReturnCharTitledPane this$0, ActionEvent it) {
        this$0.showUpdate();
    }
}

