/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.fxapp;

import com.panopset.compat.GlobalPropertiesKt;
import com.panopset.compat.LogEntry;
import com.panopset.compat.LogopAlert;
import com.panopset.compat.Logz;
import com.panopset.fxapp.FontSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.MenuBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020#J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0007J\u0006\u0010+\u001a\u00020\u0007J\u0006\u0010,\u001a\u00020\u0007J\u0006\u0010-\u001a\u00020\u0007J\u0006\u0010.\u001a\u00020\u0007J\u0006\u0010/\u001a\u00020\u0007J\u000e\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020\u0017J\u000e\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020\u001bJ\u000e\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u001fJ\u000e\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020\u0011J\u000e\u0010;\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010B\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010C\u001a\u00020#2\u0006\u0010D\u001a\u00020&H\u0002J\u0016\u0010E\u001a\u00020)2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020GR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015R \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0013\"\u0004\b!\u0010\u0015R\u0011\u00108\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0011\u0010<\u001a\u00020=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020=8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010?\u00a8\u0006H"}, d2={"Lcom/panopset/fxapp/FontManagerFX;", "", "<init>", "()V", "fontSize", "Lcom/panopset/fxapp/FontSize;", "monospace", "Ljavafx/scene/text/Font;", "boldArial", "plainArial", "boldSerif", "plainSerif", "borderTitle", "logEntry", "Lcom/panopset/compat/LogEntry;", "mbs", "", "Ljavafx/scene/control/MenuBar;", "getMbs", "()Ljava/util/List;", "setMbs", "(Ljava/util/List;)V", "nodes", "Ljavafx/scene/Node;", "getNodes", "setNodes", "tabPanes", "Ljavafx/scene/control/TabPane;", "getTabPanes", "setTabPanes", "tabs", "Ljavafx/scene/control/Tab;", "getTabs", "setTabs", "getCurrentFontSizeName", "", "getMonoStyle", "i", "", "getCurrentBaseStyle", "updateAllFontSizes", "", "getMonospace", "getBoldArial", "getBoldSerif", "getPlainArial", "getPlainSerif", "getBorderTitle", "register", "control", "registerTabPane", "tabPane", "registerTab", "tab", "registerMenubar", "menuBar", "size", "getSize", "()I", "setFontSize", "imgRatio", "", "getImgRatio", "()D", "svgRatio", "getSvgRatio", "getCurrentMessageStyle", "getStyleFor", "fontSizeValue", "setMenubarLogRecord", "menubarStatusMessage", "Ljavafx/scene/control/TextField;", "fxapp"})
public final class FontManagerFX {
    @NotNull
    public static final FontManagerFX INSTANCE;
    @NotNull
    private static FontSize fontSize;
    @NotNull
    private static Font monospace;
    @NotNull
    private static Font boldArial;
    @NotNull
    private static Font plainArial;
    @NotNull
    private static Font boldSerif;
    @NotNull
    private static Font plainSerif;
    @NotNull
    private static Font borderTitle;
    @NotNull
    private static LogEntry logEntry;
    @NotNull
    private static List<MenuBar> mbs;
    @NotNull
    private static List<Node> nodes;
    @NotNull
    private static List<TabPane> tabPanes;
    @NotNull
    private static List<Tab> tabs;

    private FontManagerFX() {
    }

    @NotNull
    public final List<MenuBar> getMbs() {
        return mbs;
    }

    public final void setMbs(@NotNull List<MenuBar> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        mbs = list;
    }

    @NotNull
    public final List<Node> getNodes() {
        return nodes;
    }

    public final void setNodes(@NotNull List<Node> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        nodes = list;
    }

    @NotNull
    public final List<TabPane> getTabPanes() {
        return tabPanes;
    }

    public final void setTabPanes(@NotNull List<TabPane> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        tabPanes = list;
    }

    @NotNull
    public final List<Tab> getTabs() {
        return tabs;
    }

    public final void setTabs(@NotNull List<Tab> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        tabs = list;
    }

    @NotNull
    public final String getCurrentFontSizeName() {
        return fontSize.name();
    }

    private final String getMonoStyle(int i) {
        String string = "-fx-font-size: %dpx; -fx-font-family: 'monospaced';";
        Object[] objectArray = new Object[]{i};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public final String getCurrentBaseStyle() {
        return this.getStyleFor(fontSize.getValue());
    }

    public final void updateAllFontSizes() {
        String style = this.getStyleFor(fontSize.getValue());
        String stylem = this.getMonoStyle(fontSize.getValue());
        for (MenuBar mb : mbs) {
            mb.setStyle(style);
        }
        for (Node node : nodes) {
            if (node instanceof TextInputControl) {
                if (Intrinsics.areEqual("menubarStatusMessage", node.getId())) {
                    Platform.runLater(() -> FontManagerFX.updateAllFontSizes$lambda$0(node));
                    continue;
                }
                node.setStyle(stylem);
                continue;
            }
            node.setStyle(style);
        }
        for (TabPane tabPane : tabPanes) {
            tabPane.setStyle(style);
        }
        for (Tab tab : tabs) {
            tab.setStyle(style);
        }
        String string = "%d";
        Object[] objectArray = new Object[]{fontSize.getValue()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        GlobalPropertiesKt.globalPropsPut("fontsize", string2);
        monospace = new Font("Monospace", fontSize.getValue());
        boldArial = Font.font("Arial", FontWeight.BOLD, (double)fontSize.getValue());
        plainArial = new Font("Arial", fontSize.getValue());
        boldSerif = Font.font("Serif", FontWeight.BOLD, (double)fontSize.getValue());
        plainSerif = new Font("Serif", fontSize.getValue());
        borderTitle = Font.font("Arial", FontPosture.ITALIC, (double)fontSize.getValue());
    }

    @NotNull
    public final Font getMonospace() {
        return monospace;
    }

    @NotNull
    public final Font getBoldArial() {
        return boldArial;
    }

    @NotNull
    public final Font getBoldSerif() {
        return boldSerif;
    }

    @NotNull
    public final Font getPlainArial() {
        return plainArial;
    }

    @NotNull
    public final Font getPlainSerif() {
        return plainSerif;
    }

    @NotNull
    public final Font getBorderTitle() {
        return borderTitle;
    }

    public final void register(@NotNull Node control) {
        Intrinsics.checkNotNullParameter(control, "control");
        if (!nodes.contains(control)) {
            nodes.add(control);
            if (control instanceof TextInputControl) {
                control.setStyle(this.getMonoStyle(fontSize.getValue()));
            } else {
                control.setStyle(this.getStyleFor(fontSize.getValue()));
            }
        }
    }

    public final void registerTabPane(@NotNull TabPane tabPane) {
        Intrinsics.checkNotNullParameter(tabPane, "tabPane");
        if (tabPanes.contains(tabPane)) {
            Logz.INSTANCE.debug("Ignoring duplicate FontManagerFX registration of tabPane " + tabPane.getId());
        } else {
            tabPanes.add(tabPane);
        }
    }

    @NotNull
    public final Tab registerTab(@NotNull Tab tab) {
        Intrinsics.checkNotNullParameter(tab, "tab");
        if (tabs.contains(tab)) {
            Logz.INSTANCE.debug("Ignoring duplicate FontManagerFX registration of tab " + tab.getId());
        } else {
            tabs.add(tab);
        }
        return tab;
    }

    public final void registerMenubar(@NotNull MenuBar menuBar) {
        Intrinsics.checkNotNullParameter(menuBar, "menuBar");
        if (mbs.contains(menuBar)) {
            Logz.INSTANCE.debug("Ignoring duplicate FontManagerFX registration of menubar " + menuBar.getId());
        } else {
            mbs.add(menuBar);
        }
    }

    public final int getSize() {
        return fontSize.getValue();
    }

    public final void setFontSize(@NotNull FontSize fontSize) {
        Intrinsics.checkNotNullParameter((Object)fontSize, "fontSize");
        FontManagerFX.fontSize = fontSize;
        this.updateAllFontSizes();
    }

    public final double getImgRatio() {
        return fontSize.getImgRatio();
    }

    public final double getSvgRatio() {
        return fontSize.getSvgRatio();
    }

    private final String getCurrentMessageStyle(LogEntry logEntry) {
        String colorStyle = "-fx-background-color: #000000; -fx-text-fill: #99ff99;";
        if (logEntry.getAlert() == LogopAlert.PURPLE) {
            colorStyle = "-fx-background-color: #000000;-fx-text-fill: #dd33dd;";
        } else if (logEntry.getAlert() == LogopAlert.BLUE) {
            colorStyle = "-fx-background-color: #000000;-fx-text-fill: #0000ff;";
        } else if (logEntry.getAlert() == LogopAlert.RED) {
            colorStyle = "-fx-background-color: #000000;-fx-text-fill: #ff3333;";
        } else if (logEntry.getAlert() == LogopAlert.ORANGE) {
            colorStyle = "-fx-background-color: #000000;-fx-text-fill: #ffaa00;";
        } else if (logEntry.getAlert() == LogopAlert.YELLOW) {
            colorStyle = "-fx-background-color: #000000;-fx-text-fill: #ffff66;";
        } else if (logEntry.getAlert() == LogopAlert.GREEN) {
            colorStyle = "-fx-background-color: #000000; -fx-text-fill: #99ff99;";
        }
        return colorStyle + this.getStyleFor(this.getSize());
    }

    private final String getStyleFor(int fontSizeValue) {
        String string = "-fx-font-size: %dpx;";
        Object[] objectArray = new Object[]{fontSizeValue};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    public final void setMenubarLogRecord(@NotNull LogEntry logEntry, @NotNull TextField menubarStatusMessage) {
        Intrinsics.checkNotNullParameter(logEntry, "logEntry");
        Intrinsics.checkNotNullParameter(menubarStatusMessage, "menubarStatusMessage");
        FontManagerFX.logEntry = logEntry;
        Platform.runLater(() -> FontManagerFX.setMenubarLogRecord$lambda$1(menubarStatusMessage, logEntry));
    }

    private static final void updateAllFontSizes$lambda$0(Node $node) {
        Node node = $node;
        Intrinsics.checkNotNull(node, "null cannot be cast to non-null type javafx.scene.control.TextField");
        INSTANCE.setMenubarLogRecord(logEntry, (TextField)node);
    }

    private static final void setMenubarLogRecord$lambda$1(TextField $menubarStatusMessage, LogEntry $logEntry) {
        $menubarStatusMessage.setStyle(INSTANCE.getCurrentMessageStyle($logEntry));
        $menubarStatusMessage.setText($logEntry.getMessage());
    }

    static {
        FontSize fontSize;
        INSTANCE = new FontManagerFX();
        FontManagerFX.fontSize = FontSize.Companion.getDEFAULT_SIZE();
        monospace = new Font("Monospace", FontManagerFX.fontSize.getValue());
        Font font = Font.font("Arial", FontWeight.BOLD, (double)FontManagerFX.fontSize.getValue());
        Intrinsics.checkNotNullExpressionValue(font, "font(...)");
        boldArial = font;
        plainArial = new Font("Arial", FontManagerFX.fontSize.getValue());
        Font font2 = Font.font("Serif", FontWeight.BOLD, (double)FontManagerFX.fontSize.getValue());
        Intrinsics.checkNotNullExpressionValue(font2, "font(...)");
        boldSerif = font2;
        plainSerif = new Font("Serif", FontManagerFX.fontSize.getValue());
        Font font3 = Font.font("Arial", FontPosture.ITALIC, (double)FontManagerFX.fontSize.getValue());
        Intrinsics.checkNotNullExpressionValue(font3, "font(...)");
        borderTitle = font3;
        Level level = Level.INFO;
        Intrinsics.checkNotNullExpressionValue(level, "INFO");
        logEntry = new LogEntry(LogopAlert.GREEN, level, "");
        try {
            String savedFontSizeValue = StringsKt.replace$default(GlobalPropertiesKt.globalPropsGet("fontsize"), "\"", "", false, 4, null);
            if (((CharSequence)savedFontSizeValue).length() == 0) {
                FontSize.Companion.getDEFAULT_SIZE();
            }
            fontSize = FontSize.Companion.findFromValue(savedFontSizeValue);
        }
        catch (NumberFormatException ex) {
            Logz.INSTANCE.errorEx(ex);
            fontSize = FontSize.Companion.getDEFAULT_SIZE();
        }
        FontManagerFX.fontSize = fontSize;
        mbs = new ArrayList();
        nodes = new ArrayList();
        tabPanes = new ArrayList();
        tabs = new ArrayList();
    }
}

