/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.fxapp;

import com.panopset.compat.HiddenFolder;
import com.panopset.compat.Logz;
import com.panopset.fxapp.AppDDSFX;
import com.panopset.fxapp.BrandedApp;
import com.panopset.fxapp.DeskApp4FX;
import com.panopset.fxapp.DeskApp4XFactory;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.fxapp.FontSize;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.JavaFXapp;
import com.panopset.fxapp.PanApplication;
import com.panopset.fxapp.PanCheckboxMenu;
import com.panopset.fxapp.PanCheckboxMenuFactory;
import com.panopset.fxapp.PanCheckboxMenuItem;
import com.panopset.fxapp.PanComponentFactoryKt;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001,B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\fH&J\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0006J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u001b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0%2\u0006\u0010&\u001a\u00020'J;\u0010(\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2!\u0010$\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\f0)2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/panopset/fxapp/BrandedApp;", "Lcom/panopset/fxapp/PanApplication;", "Lcom/panopset/fxapp/AppDDSFX;", "<init>", "()V", "deskApp4X", "Lcom/panopset/fxapp/DeskApp4FX;", "createDynapane", "Ljavafx/scene/layout/Pane;", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "updateVersionMessage", "", "go", "createPane", "deskApp4FX", "createFaviconImage", "Ljavafx/scene/image/Image;", "createStandardMenubarBorderPane", "Ljavafx/scene/layout/BorderPane;", "createMenuBar", "Ljavafx/scene/layout/HBox;", "createMenuBarStatusPane", "menuBarStatusMessage", "Ljavafx/scene/control/TextField;", "createMenuBarFx", "Ljavafx/scene/control/MenuBar;", "addAppMenus", "menus", "Ljavafx/collections/ObservableList;", "Ljavafx/scene/control/Menu;", "createFileMenu", "createFontMenu", "createHelpMenu", "createMenuItem", "Ljavafx/scene/control/MenuItem;", "doRequestedAction", "Lkotlin/Function0;", "text", "", "createFileMenuItem", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "ThemeButtonWrapper", "fxapp"})
public abstract class BrandedApp
extends PanApplication
implements AppDDSFX {
    private DeskApp4FX deskApp4X;

    @NotNull
    public abstract Pane createDynapane(@NotNull FxDoc var1);

    public abstract void updateVersionMessage();

    public final void go() {
        String string = ((Object)StringsKt.trim((CharSequence)this.getCompanyName())).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        HiddenFolder.INSTANCE.setCompanyName(StringsKt.replace$default(string, " ", "_", false, 4, null));
        DeskApp4XFactory.INSTANCE.withPanApplication(this).withBrandedApp(this).withAppDDSFX(this);
        JavaFXapp.INSTANCE.setDds(this);
        JavaFXapp.INSTANCE.doLaunch();
    }

    @Override
    @NotNull
    public final Pane createPane(@NotNull FxDoc fxDoc, @NotNull DeskApp4FX deskApp4FX) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        Intrinsics.checkNotNullParameter(deskApp4FX, "deskApp4FX");
        Pane rtn2 = DeskApp4XFactory.INSTANCE.getBrandedApp().createDynapane(fxDoc);
        return rtn2;
    }

    @Override
    @Nullable
    public final Image createFaviconImage() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string, "getSimpleName(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        String logoName = "/" + string3 + ".png";
        InputStream inputStream = this.getClass().getResourceAsStream(logoName);
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream("/logo16.png");
        }
        if (inputStream == null) {
            Logz.INSTANCE.errorMsg("Could not find image " + logoName);
            return null;
        }
        return new Image(inputStream);
    }

    @NotNull
    public final BorderPane createStandardMenubarBorderPane(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        BorderPane borderPane = new BorderPane();
        borderPane.setTop(this.createMenuBar(fxDoc));
        return borderPane;
    }

    private final HBox createMenuBar(FxDoc fxDoc) {
        HBox panMenuBar = new HBox();
        fxDoc.setMenuBarStatusMessage(PanComponentFactoryKt.createPanOutputTextField());
        panMenuBar.getChildren().add(this.createMenuBarFx(fxDoc));
        panMenuBar.getChildren().add(new ThemeButtonWrapper(fxDoc, fxDoc.getMenuBarStatusMessage()).getButton());
        panMenuBar.getChildren().add(this.createMenuBarStatusPane(fxDoc.getMenuBarStatusMessage()));
        this.updateVersionMessage();
        return panMenuBar;
    }

    private final HBox createMenuBarStatusPane(TextField menuBarStatusMessage) {
        HBox menuBarStatusPane = new HBox();
        menuBarStatusMessage.setFocusTraversable(false);
        menuBarStatusMessage.setEditable(false);
        menuBarStatusMessage.setId("menubarStatusMessage");
        FontManagerFX.INSTANCE.register(menuBarStatusMessage);
        HBox.setHgrow(menuBarStatusPane, Priority.ALWAYS);
        HBox.setHgrow(menuBarStatusMessage, Priority.ALWAYS);
        menuBarStatusPane.getChildren().add(menuBarStatusMessage);
        return menuBarStatusPane;
    }

    private final MenuBar createMenuBarFx(FxDoc fxDoc) {
        MenuBar menuBar = new MenuBar();
        menuBar.getMenus().add(this.createFileMenu(fxDoc));
        ObservableList<Menu> observableList = menuBar.getMenus();
        Intrinsics.checkNotNullExpressionValue(observableList, "getMenus(...)");
        this.addAppMenus(fxDoc, observableList);
        menuBar.getMenus().add(this.createFontMenu());
        menuBar.getMenus().add(this.createHelpMenu(fxDoc));
        FontManagerFX.INSTANCE.registerMenubar(menuBar);
        return menuBar;
    }

    public void addAppMenus(@NotNull FxDoc fxDoc, @NotNull ObservableList<Menu> menus) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        Intrinsics.checkNotNullParameter(menus, "menus");
    }

    private final Menu createFileMenu(FxDoc fxDoc) {
        Menu menu = new Menu("_File");
        menu.getItems().add(this.createFileMenuItem(fxDoc, BrandedApp::createFileMenu$lambda$0, "_New"));
        menu.getItems().add(this.createFileMenuItem(fxDoc, BrandedApp::createFileMenu$lambda$1, "_Open"));
        menu.getItems().add(this.createFileMenuItem(fxDoc, arg_0 -> BrandedApp.createFileMenu$lambda$2(fxDoc, arg_0), "_Save"));
        menu.getItems().add(this.createFileMenuItem(fxDoc, arg_0 -> BrandedApp.createFileMenu$lambda$3(fxDoc, arg_0), "Save as"));
        menu.getItems().add(this.createFileMenuItem(fxDoc, arg_0 -> BrandedApp.createFileMenu$lambda$4(fxDoc, arg_0), "_Close"));
        menu.getItems().add(this.createFileMenuItem(fxDoc, BrandedApp::createFileMenu$lambda$5, "_Quit"));
        menu.setMnemonicParsing(true);
        return menu;
    }

    private final Menu createFontMenu() {
        PanCheckboxMenuFactory cmf2 = new PanCheckboxMenuFactory(){

            public void assignAction(PanCheckboxMenuItem panCheckboxMenuItem, PanCheckboxMenu panCheckboxMenu2) {
                Intrinsics.checkNotNullParameter(panCheckboxMenuItem, "panCheckboxMenuItem");
                Intrinsics.checkNotNullParameter(panCheckboxMenu2, "panCheckboxMenu");
                panCheckboxMenuItem.getCheckboxMenuItem().setOnAction(arg_0 -> createFontMenu.cmf.1.assignAction$lambda$0(panCheckboxMenuItem, panCheckboxMenu2, arg_0));
            }

            public boolean isThisMatch(PanCheckboxMenuItem panCheckboxMenuItem, String value) {
                Intrinsics.checkNotNullParameter(panCheckboxMenuItem, "panCheckboxMenuItem");
                Intrinsics.checkNotNullParameter(value, "value");
                return Intrinsics.areEqual(FontSize.Companion.findFromName(value).name(), panCheckboxMenuItem.getCheckboxMenuItem().getText());
            }

            public void populateListOfMenuItemNames(ArrayList<String> menuItemNames) {
                Intrinsics.checkNotNullParameter(menuItemNames, "menuItemNames");
                for (FontSize fontSize : FontSize.getEntries()) {
                    menuItemNames.add(fontSize.name());
                }
            }

            private static final void assignAction$lambda$0(PanCheckboxMenuItem $panCheckboxMenuItem, PanCheckboxMenu $panCheckboxMenu, ActionEvent it) {
                String string = $panCheckboxMenuItem.getCheckboxMenuItem().getText();
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                FontManagerFX.INSTANCE.setFontSize(FontSize.Companion.findFromName(string2));
                String string3 = $panCheckboxMenuItem.getCheckboxMenuItem().getText();
                Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
                $panCheckboxMenu.setTheCurrentSelection(string3);
            }
        };
        return cmf2.constructWithInitialValue(FontManagerFX.INSTANCE.getCurrentFontSizeName()).getMenu();
    }

    private final Menu createHelpMenu(FxDoc fxDoc) {
        Menu menu = new Menu("Help");
        menu.getItems().add(this.createMenuItem(() -> BrandedApp.createHelpMenu$lambda$6(fxDoc), "Show log"));
        menu.getItems().add(this.createMenuItem(() -> BrandedApp.createHelpMenu$lambda$7(fxDoc), "About"));
        return menu;
    }

    @NotNull
    public final MenuItem createMenuItem(@NotNull Function0<Unit> doRequestedAction, @NotNull String text) {
        Intrinsics.checkNotNullParameter(doRequestedAction, "doRequestedAction");
        Intrinsics.checkNotNullParameter(text, "text");
        MenuItem rtn2 = new MenuItem();
        rtn2.setOnAction(arg_0 -> BrandedApp.createMenuItem$lambda$8(doRequestedAction, arg_0));
        rtn2.setText(text);
        rtn2.setMnemonicParsing(true);
        return rtn2;
    }

    private final MenuItem createFileMenuItem(FxDoc fxDoc, Function1<? super FxDoc, Unit> doRequestedAction, String text) {
        MenuItem menuItem = new MenuItem();
        menuItem.setOnAction(arg_0 -> BrandedApp.createFileMenuItem$lambda$9(doRequestedAction, fxDoc, arg_0));
        menuItem.setText(text);
        menuItem.setMnemonicParsing(true);
        return menuItem;
    }

    private static final Unit createFileMenu$lambda$0(FxDoc it) {
        Intrinsics.checkNotNullParameter(it, "it");
        JavaFXapp.INSTANCE.newWindow();
        return Unit.INSTANCE;
    }

    private static final Unit createFileMenu$lambda$1(FxDoc it) {
        Intrinsics.checkNotNullParameter(it, "it");
        JavaFXapp.INSTANCE.openWindowFromFile();
        return Unit.INSTANCE;
    }

    private static final Unit createFileMenu$lambda$2(FxDoc $fxDoc, FxDoc it) {
        Intrinsics.checkNotNullParameter(it, "it");
        JavaFXapp.INSTANCE.saveWindow($fxDoc);
        return Unit.INSTANCE;
    }

    private static final Unit createFileMenu$lambda$3(FxDoc $fxDoc, FxDoc it) {
        Intrinsics.checkNotNullParameter(it, "it");
        JavaFXapp.INSTANCE.saveWindowAs($fxDoc);
        return Unit.INSTANCE;
    }

    private static final Unit createFileMenu$lambda$4(FxDoc $fxDoc, FxDoc it) {
        Intrinsics.checkNotNullParameter(it, "it");
        JavaFXapp.INSTANCE.closeWindow($fxDoc);
        return Unit.INSTANCE;
    }

    private static final Unit createFileMenu$lambda$5(FxDoc it) {
        Intrinsics.checkNotNullParameter(it, "it");
        JavaFXapp.INSTANCE.panExit();
        return Unit.INSTANCE;
    }

    private static final Unit createHelpMenu$lambda$6(FxDoc $fxDoc) {
        JavaFXapp.INSTANCE.showLogPanel($fxDoc);
        return Unit.INSTANCE;
    }

    private static final Unit createHelpMenu$lambda$7(FxDoc $fxDoc) {
        JavaFXapp.INSTANCE.showAboutPanel($fxDoc);
        return Unit.INSTANCE;
    }

    private static final void createMenuItem$lambda$8(Function0 $doRequestedAction, ActionEvent it) {
        $doRequestedAction.invoke();
    }

    private static final void createFileMenuItem$lambda$9(Function1 $doRequestedAction, FxDoc $fxDoc, ActionEvent it) {
        $doRequestedAction.invoke($fxDoc);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/panopset/fxapp/BrandedApp$ThemeButtonWrapper;", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "menuBarStatusMessage", "Ljavafx/scene/control/TextField;", "<init>", "(Lcom/panopset/fxapp/FxDoc;Ljavafx/scene/control/TextField;)V", "button", "Ljavafx/scene/control/Button;", "getButton", "()Ljavafx/scene/control/Button;", "setDarkTheme", "", "setLightTheme", "fxapp"})
    public static final class ThemeButtonWrapper {
        @NotNull
        private final TextField menuBarStatusMessage;
        @NotNull
        private final Button button;

        public ThemeButtonWrapper(@NotNull FxDoc fxDoc, @NotNull TextField menuBarStatusMessage) {
            Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
            Intrinsics.checkNotNullParameter(menuBarStatusMessage, "menuBarStatusMessage");
            this.menuBarStatusMessage = menuBarStatusMessage;
            this.button = new Button();
            this.button.setText("printer");
            this.button.setOnAction(arg_0 -> ThemeButtonWrapper._init_$lambda$0(this, fxDoc, arg_0));
            FontManagerFX.INSTANCE.register(this.button);
        }

        @NotNull
        public final Button getButton() {
            return this.button;
        }

        private final void setDarkTheme(FxDoc fxDoc, Button button) {
            button.setText("printer");
            fxDoc.getScene().getRoot().setStyle("-fx-base:black");
            this.menuBarStatusMessage.setStyle(FontManagerFX.INSTANCE.getCurrentBaseStyle() + "; -fx-text-fill: #00dd00");
        }

        private final void setLightTheme(FxDoc fxDoc, Button button) {
            button.setText("screen");
            fxDoc.getScene().getRoot().setStyle("");
            this.menuBarStatusMessage.setStyle(FontManagerFX.INSTANCE.getCurrentBaseStyle() + "; -fx-text-fill: #339933");
        }

        private static final void _init_$lambda$0(ThemeButtonWrapper this$0, FxDoc $fxDoc, ActionEvent it) {
            String string = this$0.button.getText();
            Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
            if (StringsKt.indexOf$default((CharSequence)string, "een", 0, false, 6, null) > -1) {
                this$0.setDarkTheme($fxDoc, this$0.button);
            } else {
                this$0.setLightTheme($fxDoc, this$0.button);
            }
        }
    }
}

