/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/panopset/flywheel/TemplateLine;", "", "line", "", "templateCharIndex", "", "templateLineNumber", "<init>", "(Ljava/lang/String;II)V", "(Ljava/lang/String;)V", "getLine", "()Ljava/lang/String;", "getTemplateCharIndex", "()I", "getTemplateLineNumber", "toString", "flywheel"})
public final class TemplateLine {
    @NotNull
    private final String line;
    private final int templateCharIndex;
    private final int templateLineNumber;

    public TemplateLine(@NotNull String line, int templateCharIndex, int templateLineNumber) {
        Intrinsics.checkNotNullParameter(line, "line");
        this.line = line;
        this.templateCharIndex = templateCharIndex;
        this.templateLineNumber = templateLineNumber;
    }

    @NotNull
    public final String getLine() {
        return this.line;
    }

    public final int getTemplateCharIndex() {
        return this.templateCharIndex;
    }

    public final int getTemplateLineNumber() {
        return this.templateLineNumber;
    }

    public TemplateLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter(line, "line");
        this(line, 0, 0);
    }

    @NotNull
    public String toString() {
        String string = " line#: %5d, char#: 5%d line: %s";
        Object[] objectArray = new Object[]{this.templateLineNumber, this.templateCharIndex, this.line};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }
}

