/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Stringop;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u0018*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0002\u0017\u0018B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000e\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/panopset/flywheel/NamedMap;", "K", "V", "", "name", "", "map", "", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getMap", "()Ljava/util/Map;", "put", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "size", "", "getSize", "()I", "KeyReporter", "Companion", "flywheel"})
public final class NamedMap<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Map<K, V> map;
    @NotNull
    private static final KeyReporter keyReporter = new KeyReporter();

    public NamedMap(@NotNull String name, @NotNull Map<K, V> map) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(map, "map");
        this.name = name;
        this.map = map;
    }

    public /* synthetic */ NamedMap(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = Collections.synchronizedMap(new HashMap());
        }
        this(string, map);
    }

    @NotNull
    public final Map<K, V> getMap() {
        return this.map;
    }

    public final void put(K key, V value) {
        keyReporter.reportDefinedKey(this.name, String.valueOf(key));
        this.map.put(key, value);
    }

    @Nullable
    public final V get(K key) {
        keyReporter.reportUsedKey(this.name, String.valueOf(key));
        return this.map.get(key);
    }

    public final int getSize() {
        return this.map.size();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/panopset/flywheel/NamedMap$Companion;", "", "<init>", "()V", "reportUnusedKeys", "", "keyReporter", "Lcom/panopset/flywheel/NamedMap$KeyReporter;", "getKeyReporter", "()Lcom/panopset/flywheel/NamedMap$KeyReporter;", "flywheel"})
    public static final class Companion {
        private Companion() {
        }

        public final void reportUnusedKeys() {
            this.getKeyReporter().reportUnusedKeys();
        }

        @NotNull
        public final KeyReporter getKeyReporter() {
            return keyReporter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\tR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/panopset/flywheel/NamedMap$KeyReporter;", "", "<init>", "()V", "getKeyReport", "Lcom/panopset/flywheel/NamedMap$KeyReporter$KeyReport;", "source", "", "reportUsedKey", "", "key", "reportDefinedKey", "reportUnusedKeys", "keyReports", "", "KeyReport", "Companion", "flywheel"})
    public static final class KeyReporter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, KeyReport> keyReports;
        public static final int MAXIMUM_NUMERICS = 100;

        public KeyReporter() {
            SortedMap sortedMap = Collections.synchronizedSortedMap(new TreeMap());
            Intrinsics.checkNotNullExpressionValue(sortedMap, "synchronizedSortedMap(...)");
            this.keyReports = sortedMap;
        }

        @NotNull
        public final KeyReport getKeyReport(@NotNull String source) {
            Intrinsics.checkNotNullParameter(source, "source");
            KeyReport rtn2 = this.keyReports.get(source);
            if (rtn2 == null) {
                rtn2 = new KeyReport();
                this.keyReports.put(source, rtn2);
            }
            return rtn2;
        }

        public final void reportUsedKey(@NotNull String source, @NotNull String key) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(key, "key");
            KeyReport keyReport = this.getKeyReport(source);
            if (!keyReport.getUsedKeys().contains(key)) {
                keyReport.getUsedKeys().add(key);
            }
        }

        public final void reportDefinedKey(@NotNull String source, @NotNull String key) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(key, "key");
            KeyReport keyReport = this.getKeyReport(source);
            if (!keyReport.getDefinedKeys().contains(key)) {
                keyReport.getDefinedKeys().add(key);
            }
        }

        public final void reportUnusedKeys() {
            StringWriter sw = new StringWriter();
            for (String source : this.keyReports.keySet()) {
                StringWriter hdr = new StringWriter();
                hdr.append("*********").append(source).append(":");
                hdr.append(Stringop.INSTANCE.getEol());
                KeyReport keyReport = this.getKeyReport(source);
                for (String s : keyReport.getUsedKeys()) {
                    keyReport.getDefinedKeys().remove(s);
                }
                for (int i = 0; i < 100; ++i) {
                    keyReport.getDefinedKeys().remove("" + i);
                }
                keyReport.getDefinedKeys().remove("com.panopset.flywheel.file");
                keyReport.getDefinedKeys().remove("com.panopset.flywheel.script");
                keyReport.getDefinedKeys().remove("com.panopset.flywheel.splits");
                keyReport.getDefinedKeys().remove("com.panopset.flywheel.target");
                keyReport.getDefinedKeys().remove("com.panopset.flywheel.template");
                keyReport.getDefinedKeys().remove("com.panopset.flywheel.tokens");
                boolean firstTime = true;
                for (String s : keyReport.getDefinedKeys()) {
                    if (firstTime) {
                        sw.append(hdr.toString());
                        firstTime = false;
                    }
                    sw.append(s);
                    sw.append(Stringop.INSTANCE.getEol());
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/panopset/flywheel/NamedMap$KeyReporter$Companion;", "", "<init>", "()V", "MAXIMUM_NUMERICS", "", "flywheel"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/panopset/flywheel/NamedMap$KeyReporter$KeyReport;", "", "<init>", "()V", "usedKeys", "", "", "getUsedKeys", "()Ljava/util/List;", "definedKeys", "", "getDefinedKeys", "()Ljava/util/Set;", "flywheel"})
        public static final class KeyReport {
            @NotNull
            private final List<String> usedKeys = new ArrayList();
            @NotNull
            private final Set<String> definedKeys;

            public KeyReport() {
                SortedSet sortedSet = Collections.synchronizedSortedSet(new TreeSet());
                Intrinsics.checkNotNullExpressionValue(sortedSet, "synchronizedSortedSet(...)");
                this.definedKeys = sortedSet;
            }

            @NotNull
            public final List<String> getUsedKeys() {
                return this.usedKeys;
            }

            @NotNull
            public final Set<String> getDefinedKeys() {
                return this.definedKeys;
            }
        }
    }
}

