/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.SplitterKt;
import com.panopset.compat.Stringop;
import com.panopset.flywheel.Flywheel;
import com.panopset.flywheel.FlywheelBuilder;
import com.panopset.flywheel.LineFeedRules;
import com.panopset.flywheel.LineFeedRulesKt;
import com.panopset.flywheel.TokenVariableFactory;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001$B\u001f\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020\u0004H\u0002J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\"2\u0006\u0010#\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u001e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\t\u00a8\u0006%"}, d2={"Lcom/panopset/flywheel/FlywheelListDriver;", "", "inputList", "", "", "templateStr", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "getTemplateStr", "()Ljava/lang/String;", "splitz", "getSplitz", "setSplitz", "(Ljava/lang/String;)V", "tokens", "getTokens", "setTokens", "lineFeedRules", "Lcom/panopset/flywheel/LineFeedRules;", "getLineFeedRules", "()Lcom/panopset/flywheel/LineFeedRules;", "setLineFeedRules", "(Lcom/panopset/flywheel/LineFeedRules;)V", "getInputList", "", "setInputList", "", "value", "hasSplitz", "", "output", "getOutput", "processInput", "createInputMapFrom", "", "inputLine", "Builder", "flywheel"})
public final class FlywheelListDriver {
    @NotNull
    private List<String> inputList;
    @NotNull
    private final String templateStr;
    @NotNull
    private String splitz;
    @NotNull
    private String tokens;
    @NotNull
    private LineFeedRules lineFeedRules;

    private FlywheelListDriver(List<String> inputList, String templateStr) {
        this.inputList = inputList;
        this.templateStr = templateStr;
        this.splitz = "";
        this.tokens = "";
        this.lineFeedRules = LineFeedRulesKt.getFULL_BREAKS();
    }

    @NotNull
    public final String getTemplateStr() {
        return this.templateStr;
    }

    @NotNull
    public final String getSplitz() {
        return this.splitz;
    }

    public final void setSplitz(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.splitz = string;
    }

    @NotNull
    public final String getTokens() {
        return this.tokens;
    }

    public final void setTokens(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.tokens = string;
    }

    @NotNull
    public final LineFeedRules getLineFeedRules() {
        return this.lineFeedRules;
    }

    public final void setLineFeedRules(@NotNull LineFeedRules lineFeedRules) {
        Intrinsics.checkNotNullParameter(lineFeedRules, "<set-?>");
        this.lineFeedRules = lineFeedRules;
    }

    private final List<String> getInputList() {
        return this.inputList;
    }

    public final void setInputList(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.inputList = value;
    }

    private final boolean hasSplitz() {
        return ((CharSequence)this.splitz).length() > 0;
    }

    @NotNull
    public final synchronized String getOutput() {
        String string;
        if (this.hasSplitz()) {
            StringWriter sw = new StringWriter();
            for (String s : this.getInputList()) {
                Iterable chunks = SplitterKt.fixedLengths(this.splitz).split(s);
                List chunky = new ArrayList();
                for (String chunk : chunks) {
                    chunky.add(chunk);
                }
                this.setInputList(chunky);
                sw.append(this.processInput());
                sw.append(Stringop.INSTANCE.getEol());
            }
            String string2 = sw.toString();
            Intrinsics.checkNotNull(string2);
            string = string2;
        } else {
            string = this.processInput();
        }
        return string;
    }

    private final String processInput() {
        StringWriter sw = new StringWriter();
        for (String s : this.getInputList()) {
            if (StringsKt.isBlank(s)) continue;
            Flywheel flywheel2 = new FlywheelBuilder().map(this.createInputMapFrom(s)).inputList((List<String>)Stringop.INSTANCE.stringToList(this.templateStr)).withLineFeedRules(this.lineFeedRules).withWriter(sw).construct();
            flywheel2.exec();
            if (flywheel2.isStopped()) {
                String string = "Stopped: %s";
                Object[] objectArray = new Object[]{flywheel2.getControl().getStopReason()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                return string2;
            }
            if (!flywheel2.getTemplate().getTemplateRules().getListBreaks()) continue;
            sw.append(Stringop.INSTANCE.getEol());
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final Map<String, String> createInputMapFrom(String inputLine) {
        Map rtn2 = new HashMap();
        rtn2.put("l", inputLine);
        if (Stringop.INSTANCE.isPopulated(inputLine)) {
            int i = 0;
            StringTokenizer st = new StringTokenizer(inputLine, " ");
            while (st.hasMoreTokens()) {
                String string;
                Map map = rtn2;
                String string2 = "w%d";
                Object[] objectArray = new Object[]{i++};
                Intrinsics.checkNotNullExpressionValue(String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), "format(...)");
                string2 = st.nextToken();
                map.put(string, string2);
            }
            new TokenVariableFactory().addTokensToMap(rtn2, inputLine, this.tokens);
        }
        return rtn2;
    }

    public /* synthetic */ FlywheelListDriver(List inputList, String templateStr, DefaultConstructorMarker $constructor_marker) {
        this(inputList, templateStr);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001f\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0002\u0010\bB!\b\u0016\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\n\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0002\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0006R\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/panopset/flywheel/FlywheelListDriver$Builder;", "", "<init>", "()V", "inputList", "", "", "templateStr", "(Ljava/util/List;Ljava/lang/String;)V", "inputArray", "", "([Ljava/lang/String;Ljava/lang/String;)V", "fp", "Lcom/panopset/flywheel/FlywheelListDriver;", "getFp", "()Lcom/panopset/flywheel/FlywheelListDriver;", "setFp", "(Lcom/panopset/flywheel/FlywheelListDriver;)V", "build", "withLineFeedRules", "lineFeedRules", "Lcom/panopset/flywheel/LineFeedRules;", "withSplitz", "value", "withTokens", "flywheel"})
    public static final class Builder {
        public FlywheelListDriver fp;

        public Builder() {
        }

        public Builder(@NotNull List<String> inputList, @NotNull String templateStr) {
            Intrinsics.checkNotNullParameter(inputList, "inputList");
            Intrinsics.checkNotNullParameter(templateStr, "templateStr");
            this();
            this.setFp(new FlywheelListDriver(inputList, templateStr, null));
        }

        public Builder(@NotNull String[] inputArray, @NotNull String templateStr) {
            Intrinsics.checkNotNullParameter(inputArray, "inputArray");
            Intrinsics.checkNotNullParameter(templateStr, "templateStr");
            this();
            List<String> list = Arrays.asList(Arrays.copyOf(inputArray, inputArray.length));
            Intrinsics.checkNotNullExpressionValue(list, "asList(...)");
            this.setFp(new FlywheelListDriver(list, templateStr, null));
        }

        @NotNull
        public final FlywheelListDriver getFp() {
            FlywheelListDriver flywheelListDriver = this.fp;
            if (flywheelListDriver != null) {
                return flywheelListDriver;
            }
            Intrinsics.throwUninitializedPropertyAccessException("fp");
            return null;
        }

        public final void setFp(@NotNull FlywheelListDriver flywheelListDriver) {
            Intrinsics.checkNotNullParameter(flywheelListDriver, "<set-?>");
            this.fp = flywheelListDriver;
        }

        @NotNull
        public final FlywheelListDriver build() {
            if (this.getFp().inputList.isEmpty()) {
                this.getFp().inputList.add("");
            }
            return this.getFp();
        }

        @NotNull
        public final Builder withLineFeedRules(@NotNull LineFeedRules lineFeedRules) {
            Intrinsics.checkNotNullParameter(lineFeedRules, "lineFeedRules");
            this.getFp().setLineFeedRules(lineFeedRules);
            return this;
        }

        @NotNull
        public final Builder withSplitz(@NotNull String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            this.getFp().setSplitz(value);
            return this;
        }

        @NotNull
        public final Builder withTokens(@NotNull String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            this.getFp().setTokens(value);
            return this;
        }
    }
}

