/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.flywheel.Template;
import com.panopset.flywheel.TemplateLine;
import com.panopset.flywheel.UniqueIdFactory;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001d\u001a\u00020\u001eH&J\b\u0010\u001f\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/panopset/flywheel/Command;", "", "template", "Lcom/panopset/flywheel/Template;", "templateLine", "Lcom/panopset/flywheel/TemplateLine;", "<init>", "(Lcom/panopset/flywheel/Template;Lcom/panopset/flywheel/TemplateLine;)V", "getTemplate", "()Lcom/panopset/flywheel/Template;", "getTemplateLine", "()Lcom/panopset/flywheel/TemplateLine;", "id", "", "getId", "()I", "next", "getNext", "()Lcom/panopset/flywheel/Command;", "setNext", "(Lcom/panopset/flywheel/Command;)V", "prev", "getPrev", "setPrev", "resolve", "", "sw", "Ljava/io/StringWriter;", "resolveCommand", "getDescription", "", "toString", "flywheel"})
public abstract class Command {
    @NotNull
    private final Template template;
    @NotNull
    private final TemplateLine templateLine;
    private final int id;
    @Nullable
    private Command next;
    @Nullable
    private Command prev;

    public Command(@NotNull Template template, @NotNull TemplateLine templateLine) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(templateLine, "templateLine");
        this.template = template;
        this.templateLine = templateLine;
        this.id = UniqueIdFactory.INSTANCE.getId();
    }

    @NotNull
    public final Template getTemplate() {
        return this.template;
    }

    @NotNull
    public final TemplateLine getTemplateLine() {
        return this.templateLine;
    }

    public final int getId() {
        return this.id;
    }

    @Nullable
    public final Command getNext() {
        return this.next;
    }

    public final void setNext(@Nullable Command command) {
        this.next = command;
    }

    @Nullable
    public final Command getPrev() {
        return this.prev;
    }

    public final void setPrev(@Nullable Command command) {
        this.prev = command;
    }

    public abstract void resolve(@NotNull StringWriter var1);

    public final void resolveCommand(@NotNull StringWriter sw) {
        Intrinsics.checkNotNullParameter(sw, "sw");
        this.resolve(sw);
    }

    @NotNull
    public abstract String getDescription();

    @NotNull
    public String toString() {
        String cn = this.getClass().getSimpleName();
        Intrinsics.checkNotNull(cn);
        String string = cn.substring(7);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return StringsKt.replace$default(this.id + ": " + string + " " + this.getDescription(), "\n", "", false, 4, null);
    }
}

