/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities.skyscraper;

import com.panopset.compat.Fileop;
import com.panopset.compat.FileopKt;
import com.panopset.compat.HiddenFolder;
import com.panopset.compat.Logz;
import com.panopset.compat.Stringop;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\u00020\u00012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u001a\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"loadEnvironments", "", "envMap", "", "", "validExtensions", "", "extension", "establishBaseDirectory", "Ljava/io/File;", "PANOPSET_SKYSCRAPER_ENVS", "defaultBaseDir", "getDefaultBaseDir", "()Ljava/io/File;", "desk"})
public final class EnvFactoryKt {
    @NotNull
    public static final String PANOPSET_SKYSCRAPER_ENVS = "PANOPSET_SKYSCRAPER_ENVS";
    @NotNull
    private static final File defaultBaseDir = new File(HiddenFolder.INSTANCE.getFullPathRelativeTo("skyscraper" + Stringop.INSTANCE.getFSP() + "envs"));

    public static final void loadEnvironments(@NotNull Map<String, Map<String, String>> envMap) {
        Intrinsics.checkNotNullParameter(envMap, "envMap");
        File baseDirectory = EnvFactoryKt.establishBaseDirectory();
        File[] fileArray = baseDirectory.listFiles();
        if (fileArray == null) {
            return;
        }
        File[] listOfFiles = fileArray;
        envMap.clear();
        for (File prefFile : listOfFiles) {
            Intrinsics.checkNotNull(prefFile);
            if (!EnvFactoryKt.validExtensions(FilesKt.getExtension(prefFile))) continue;
            Properties props = new Properties();
            props.load(new BufferedInputStream(new FileInputStream(prefFile)));
            envMap.put(FilesKt.getNameWithoutExtension(prefFile), FileopKt.props2map(props));
        }
    }

    private static final boolean validExtensions(String extension) {
        String lcx;
        String string = extension.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return switch (lcx = string) {
            case "" -> true;
            case "txt" -> true;
            case "properties" -> true;
            case "preferences" -> true;
            default -> false;
        };
    }

    @NotNull
    public static final File establishBaseDirectory() {
        String userDefinedBaseDir = System.getenv().get(PANOPSET_SKYSCRAPER_ENVS);
        CharSequence charSequence = userDefinedBaseDir;
        if (!(charSequence == null || charSequence.length() == 0)) {
            File userDir4envs = new File(userDefinedBaseDir);
            if (userDir4envs.exists()) {
                if (userDir4envs.isDirectory()) {
                    if (userDir4envs.canRead()) {
                        return userDir4envs;
                    }
                    Logz.INSTANCE.warn("PANOPSET_SKYSCRAPER_ENVS defined directory " + Fileop.INSTANCE.getCanonicalPath(userDir4envs) + " can not be read, please check permissions. Reverting to default.");
                } else {
                    Logz.INSTANCE.warn("PANOPSET_SKYSCRAPER_ENVS defined directory " + Fileop.INSTANCE.getCanonicalPath(userDir4envs) + " is not a directory. Reverting to default.");
                }
            } else {
                Logz.INSTANCE.warn("PANOPSET_SKYSCRAPER_ENVS defined directory " + Fileop.INSTANCE.getCanonicalPath(userDir4envs) + " does not exist. Reverting to default.");
            }
        }
        return defaultBaseDir;
    }

    @NotNull
    public static final File getDefaultBaseDir() {
        return defaultBaseDir;
    }
}

