/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities.fwtabs;

import com.panopset.compat.Fileop;
import com.panopset.compat.Logz;
import com.panopset.flywheel.ListAudit;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanComponentFactoryKt;
import com.panopset.fxapp.PanDirSelectorPanel;
import java.io.File;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/panopset/desk/utilities/fwtabs/TabListAudit;", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "<init>", "(Lcom/panopset/fxapp/FxDoc;)V", "getFxDoc", "()Lcom/panopset/fxapp/FxDoc;", "laDirSelect", "Lcom/panopset/fxapp/PanDirSelectorPanel;", "laRunButton", "Ljavafx/scene/control/Button;", "auditTa", "Ljavafx/scene/control/TextArea;", "createTab", "Ljavafx/scene/control/Tab;", "process", "", "desk"})
public final class TabListAudit {
    @NotNull
    private final FxDoc fxDoc;
    private PanDirSelectorPanel laDirSelect;
    private Button laRunButton;
    private TextArea auditTa;

    public TabListAudit(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.fxDoc = fxDoc;
    }

    @NotNull
    public final FxDoc getFxDoc() {
        return this.fxDoc;
    }

    @NotNull
    public final Tab createTab() {
        this.laDirSelect = new PanDirSelectorPanel(this.fxDoc, "ladirselect");
        this.auditTa = PanComponentFactoryKt.createPanTextArea("Click the \"Run\" button", "Results will appear here.");
        this.laRunButton = PanComponentFactoryKt.createPanButton(this.fxDoc, () -> TabListAudit.createTab$lambda$0(this), "_Run", true, "Audit a directory that contains text files of lists.");
        Tab rtn2 = FontManagerFX.INSTANCE.registerTab(new Tab("List Audit"));
        BorderPane bp = new BorderPane();
        Node[] nodeArray = new Node[2];
        nodeArray[0] = PanComponentFactoryKt.createPanLabel("Select a directory that has list files that you wish to compare.  Then click run to generate a csv formatted report.");
        Node[] nodeArray2 = new Node[2];
        PanDirSelectorPanel panDirSelectorPanel = this.laDirSelect;
        if (panDirSelectorPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("laDirSelect");
            panDirSelectorPanel = null;
        }
        nodeArray2[0] = panDirSelectorPanel.getPane();
        Button button = this.laRunButton;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException("laRunButton");
            button = null;
        }
        nodeArray2[1] = button;
        nodeArray[1] = PanComponentFactoryKt.createPanHBox(nodeArray2);
        bp.setTop(PanComponentFactoryKt.createPanVBox(nodeArray));
        TextArea textArea = this.auditTa;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("auditTa");
            textArea = null;
        }
        bp.setCenter(PanComponentFactoryKt.createPanScrollPane(textArea));
        rtn2.setContent(bp);
        return rtn2;
    }

    private final void process() {
        PanDirSelectorPanel panDirSelectorPanel = this.laDirSelect;
        if (panDirSelectorPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("laDirSelect");
            panDirSelectorPanel = null;
        }
        File dir = panDirSelectorPanel.createDir();
        ListAudit listAudit = new ListAudit();
        if (!dir.exists()) {
            Logz.INSTANCE.errorMsg("Does not exist.", dir);
            return;
        }
        if (!dir.isDirectory()) {
            Logz.INSTANCE.errorMsg("Not a directory.", dir);
            return;
        }
        File[] fileArray = dir.listFiles();
        Intrinsics.checkNotNull(fileArray);
        for (File f : fileArray) {
            if (!f.isFile()) continue;
            String string = f.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            Intrinsics.checkNotNull(f);
            listAudit.add(string, Fileop.INSTANCE.readLines(f));
        }
        TextArea textArea = this.auditTa;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("auditTa");
            textArea = null;
        }
        textArea.setText(listAudit.getReportText());
    }

    private static final Unit createTab$lambda$0(TabListAudit this$0) {
        this$0.process();
        return Unit.INSTANCE;
    }
}

