/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities;

import com.panopset.compat.Logz;
import com.panopset.desk.utilities.lowerclass.VersionParser;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanComponentFactoryKt;
import com.panopset.fxapp.PanFileOrDirSelectorPanel;
import com.panopset.marin.fx.PanopsetBrandedAppTran;
import java.io.File;
import java.io.IOException;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/panopset/desk/utilities/LowerClass;", "Lcom/panopset/marin/fx/PanopsetBrandedAppTran;", "<init>", "()V", "lcReport", "Ljavafx/scene/control/Button;", "lcOut", "Ljavafx/scene/control/TextArea;", "lcFileOrDirSelect", "Lcom/panopset/fxapp/PanFileOrDirSelectorPanel;", "lcDetails", "Ljavafx/scene/control/CheckBox;", "getApplicationDisplayName", "", "getDescription", "createDynapane", "Ljavafx/scene/layout/Pane;", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "createCenter", "Ljavafx/scene/layout/BorderPane;", "refresh", "", "createVersionParser", "Lcom/panopset/desk/utilities/lowerclass/VersionParser;", "file", "Ljava/io/File;", "Companion", "desk"})
public final class LowerClass
extends PanopsetBrandedAppTran {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Button lcReport;
    private TextArea lcOut;
    private PanFileOrDirSelectorPanel lcFileOrDirSelect;
    private CheckBox lcDetails;

    @Override
    @NotNull
    public String getApplicationDisplayName() {
        return "Lower Class";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Generate a report on minimum JDKs for the class files found in a jar, or a repository directory.";
    }

    @Override
    @NotNull
    public Pane createDynapane(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.lcReport = PanComponentFactoryKt.createPanButton(fxDoc, () -> LowerClass.createDynapane$lambda$0(this), "Report", false, "Generate report.");
        this.lcOut = PanComponentFactoryKt.createPanTextArea("Report on selected file or directory to appear here.", "Please click the Report button, after selecting jar file or class directory.");
        this.lcFileOrDirSelect = new PanFileOrDirSelectorPanel(fxDoc, "lcFileOrDirSelect");
        this.lcDetails = PanComponentFactoryKt.createPanCheckBox(fxDoc, "lcDetails", "details");
        BorderPane b = this.createStandardMenubarBorderPane(fxDoc);
        b.setCenter(this.createCenter());
        return b;
    }

    private final BorderPane createCenter() {
        Button button;
        BorderPane bp = new BorderPane();
        Node[] nodeArray = new Node[3];
        PanFileOrDirSelectorPanel panFileOrDirSelectorPanel = this.lcFileOrDirSelect;
        if (panFileOrDirSelectorPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lcFileOrDirSelect");
            panFileOrDirSelectorPanel = null;
        }
        nodeArray[0] = panFileOrDirSelectorPanel.getPane();
        Node node = this.lcDetails;
        if (node == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lcDetails");
            node = nodeArray[1] = null;
        }
        if ((button = this.lcReport) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lcReport");
            button = null;
        }
        nodeArray[2] = button;
        bp.setTop(PanComponentFactoryKt.createPanHBox(nodeArray));
        TextArea textArea = this.lcOut;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lcOut");
            textArea = null;
        }
        bp.setCenter(PanComponentFactoryKt.createPanScrollPane(textArea));
        return bp;
    }

    private final void refresh() {
        TextArea textArea = this.lcOut;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lcOut");
            textArea = null;
        }
        textArea.setText("");
        Button button = this.lcReport;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lcReport");
            button = null;
        }
        if (button.isDisabled()) {
            Logz.INSTANCE.warn("Please wait for running process to complete.");
            return;
        }
        Button button2 = this.lcReport;
        if (button2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lcReport");
            button2 = null;
        }
        button2.setDisable(true);
        Platform.runLater(() -> LowerClass.refresh$lambda$1(this));
    }

    private final VersionParser createVersionParser(File file) {
        return file.exists() && file.canRead() ? new VersionParser(file) : new VersionParser();
    }

    private static final Unit createDynapane$lambda$0(LowerClass this$0) {
        this$0.refresh();
        return Unit.INSTANCE;
    }

    private static final void refresh$lambda$1(LowerClass this$0) {
        Button button;
        PanFileOrDirSelectorPanel panFileOrDirSelectorPanel = this$0.lcFileOrDirSelect;
        if (panFileOrDirSelectorPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lcFileOrDirSelect");
            panFileOrDirSelectorPanel = null;
        }
        File file = panFileOrDirSelectorPanel.createFile();
        VersionParser vp0 = this$0.createVersionParser(file);
        try {
            CheckBox checkBox = this$0.lcDetails;
            if (checkBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException("lcDetails");
                checkBox = null;
            }
            if (checkBox.isSelected()) {
                if (file.isDirectory()) {
                    Logz.INSTANCE.warn("Details not available on a directory report.");
                    TextArea textArea = this$0.lcOut;
                    if (textArea == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("lcOut");
                        textArea = null;
                    }
                    textArea.appendText(vp0.getSummaryReport());
                } else {
                    TextArea textArea = this$0.lcOut;
                    if (textArea == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("lcOut");
                        textArea = null;
                    }
                    textArea.appendText(vp0.getSummaryReport());
                }
            } else {
                TextArea textArea = this$0.lcOut;
                if (textArea == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("lcOut");
                    textArea = null;
                }
                textArea.appendText(vp0.getSummaryReport());
            }
        }
        catch (IOException ex) {
            Logz.INSTANCE.errorEx(ex);
        }
        if ((button = this$0.lcReport) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lcReport");
            button = null;
        }
        button.setDisable(false);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Companion.main(args2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/panopset/desk/utilities/LowerClass$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "desk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            new LowerClass().go();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

