/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.DumpTruck;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a0\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e\u001a6\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0005\u001a\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0001\u001a \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0001\u001a\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u001c"}, d2={"panStringToHex", "", "str", "panCharToHex", "c", "", "panStringToBackSlashes", "loadStringToDumpTruck", "Lcom/panopset/compat/DumpTruck;", "text", "start", "max", "width", "isSpace", "", "loadInputStreamToDumpTruck", "ip", "Ljava/io/InputStream;", "requestedWidth", "isSpaces", "streamLength", "toDumpTruck", "s", "hasMore", "i", "backSlashOf", "hexRep", "isInBackSlashRange", "compat"})
public final class HexopsKt {
    @NotNull
    public static final String panStringToHex(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        StringWriter sw = new StringWriter();
        PrimitiveIterator.OfInt ofInt = str.chars().iterator();
        while (ofInt.hasNext()) {
            Integer c = ofInt.next();
            Intrinsics.checkNotNull(c);
            sw.append(HexopsKt.panCharToHex(c));
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public static final String panCharToHex(int c) {
        String string = "%02X";
        Object[] objectArray = new Object[]{c};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public static final String panStringToBackSlashes(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        StringWriter sw = new StringWriter();
        PrimitiveIterator.OfInt ofInt = str.chars().iterator();
        while (ofInt.hasNext()) {
            Integer c = ofInt.next();
            Intrinsics.checkNotNull(c);
            String hexRep = HexopsKt.panCharToHex(c);
            sw.append(HexopsKt.backSlashOf(c, hexRep));
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public static final DumpTruck loadStringToDumpTruck(@Nullable String text, int start, int max, int width, boolean isSpace) {
        String baisInp;
        String string = text;
        if (string == null) {
            string = "";
        }
        String string2 = baisInp = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        ByteArrayInputStream bais = new ByteArrayInputStream(byArray);
        return HexopsKt.loadInputStreamToDumpTruck(bais, start, max, width, isSpace, baisInp.length());
    }

    @NotNull
    public static final DumpTruck loadInputStreamToDumpTruck(@NotNull InputStream ip, int start, int max, int requestedWidth, boolean isSpaces, int streamLength) {
        int i;
        Intrinsics.checkNotNullParameter(ip, "ip");
        ArrayList<String> srcLineList = new ArrayList<String>();
        ArrayList<String> chrLineList = new ArrayList<String>();
        ArrayList<String> hexLineList = new ArrayList<String>();
        int width = requestedWidth < 1 ? streamLength : requestedWidth;
        try {
            BufferedInputStream bis = ip instanceof BufferedInputStream ? (BufferedInputStream)ip : new BufferedInputStream(ip);
            i = 0;
            int lineByteCount = 0;
            if (start > 0) {
                if ((long)start > (long)streamLength) {
                    return HexopsKt.toDumpTruck("File length of " + streamLength + " is smaller than the start position");
                }
                bis.skip(start);
            }
            int c = bis.read();
            while (HexopsKt.hasMore(i++, max, c)) {
                StringWriter srcLineBuffer = new StringWriter();
                StringWriter chrLineBuffer = new StringWriter();
                StringWriter hexLineBuffer = new StringWriter();
                do {
                    if (lineByteCount > 0 && isSpaces) {
                        srcLineBuffer.append(" ");
                        chrLineBuffer.append(" ");
                        hexLineBuffer.append(" ");
                    }
                    String hexRepOfCurrentChar = HexopsKt.panCharToHex(c);
                    hexLineBuffer.append(hexRepOfCurrentChar);
                    chrLineBuffer.append(HexopsKt.backSlashOf(c, hexRepOfCurrentChar));
                    c = bis.read();
                } while (++lineByteCount < width && c != -1);
                srcLineList.add(srcLineBuffer.toString());
                chrLineList.add(chrLineBuffer.toString());
                hexLineList.add(hexLineBuffer.toString());
                lineByteCount = 0;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        StringWriter sw = new StringWriter();
        int n = ((Collection)srcLineList).size();
        for (i = 0; i < n; ++i) {
            StringsKt.append((Appendable)sw, new CharSequence[0]);
        }
        return new DumpTruck((List<String>)srcLineList, (List<String>)chrLineList, (List<String>)hexLineList);
    }

    @NotNull
    public static final DumpTruck toDumpTruck(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        return new DumpTruck(s, "", "");
    }

    private static final boolean hasMore(int i, int max, int c) {
        return c != -1 && max > 0 && i >= max ? true : c != -1;
    }

    @NotNull
    public static final String backSlashOf(int c, @NotNull String hexRep) {
        Intrinsics.checkNotNullParameter(hexRep, "hexRep");
        String backSlasher = !HexopsKt.isInBackSlashRange(c) ? "" : (Intrinsics.areEqual("09", hexRep) ? "\\t" : (Intrinsics.areEqual("08", hexRep) ? "\\b" : (Intrinsics.areEqual("0A", hexRep) ? "\\n" : (Intrinsics.areEqual("0D", hexRep) ? "\\r" : (Intrinsics.areEqual("0C", hexRep) ? "\\f" : "")))));
        StringWriter sw = new StringWriter();
        if (((CharSequence)backSlasher).length() > 0) {
            v0 = sw.append(backSlasher);
        } else {
            sw.append(" ");
            char ch = (char)c;
            v0 = Character.isWhitespace(ch) ? sw.append(" ") : sw.append(String.valueOf((char)c));
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final boolean isInBackSlashRange(int c) {
        return c < 14;
    }
}

