/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackConfiguration;
import com.panopset.blackjackEngine.Configurable;
import com.panopset.blackjackEngine.Situation;
import com.panopset.blackjackEngine.StratCat;
import com.panopset.blackjackEngine.StrategyLine;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0002R(\u0010\n\u001a\u001c\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0014\u001a\u001c\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/panopset/blackjackEngine/Strategy;", "Lcom/panopset/blackjackEngine/Configurable;", "blackjackConfiguration", "Lcom/panopset/blackjackEngine/BlackjackConfiguration;", "<init>", "(Lcom/panopset/blackjackEngine/BlackjackConfiguration;)V", "getRecommendation", "", "s", "Lcom/panopset/blackjackEngine/Situation;", "sls", "", "Lcom/panopset/blackjackEngine/StratCat;", "", "Lcom/panopset/blackjackEngine/StrategyLine;", "hardHeader", "softHeader", "splitHeader", "getHeaderFor", "cat", "strategyLines", "getStrategyLines", "()Ljava/util/Map;", "populateStrategyLineMap", "", "findStrategyLine", "shouldSplit", "", "findSplitStrategyLine", "findSoftStrategyLine", "findHardStrategyLine", "createStrategyLineMap", "blackjackEngine"})
public final class Strategy
extends Configurable {
    @Nullable
    private Map<StratCat, ? extends Map<String, StrategyLine>> sls;
    @NotNull
    private String hardHeader;
    @NotNull
    private String softHeader;
    @NotNull
    private String splitHeader;

    public Strategy(@NotNull BlackjackConfiguration blackjackConfiguration) {
        Intrinsics.checkNotNullParameter(blackjackConfiguration, "blackjackConfiguration");
        super(blackjackConfiguration);
        this.hardHeader = "";
        this.softHeader = "";
        this.splitHeader = "";
    }

    @NotNull
    public final String getRecommendation(@NotNull Situation s) {
        StrategyLine line;
        Intrinsics.checkNotNullParameter(s, "s");
        StrategyLine strategyLine = line = this.findStrategyLine(s);
        Intrinsics.checkNotNull(strategyLine);
        return strategyLine.getAction(s);
    }

    @NotNull
    public final String getHeaderFor(@Nullable StratCat cat) {
        StratCat stratCat = cat;
        return switch (stratCat == null ? -1 : WhenMappings.$EnumSwitchMapping$0[stratCat.ordinal()]) {
            case 1 -> this.softHeader;
            case 2 -> this.splitHeader;
            default -> this.hardHeader;
        };
    }

    @Nullable
    public final Map<StratCat, Map<String, StrategyLine>> getStrategyLines() {
        if (this.sls == null) {
            this.sls = this.createStrategyLineMap();
            this.populateStrategyLineMap();
        }
        return this.sls;
    }

    private final void populateStrategyLineMap() {
        StratCat reading = StratCat.NONE;
        Iterator<String> iterator2 = Objects.requireNonNull(this.getBlackjackConfiguration().getStrategyData()).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            StrategyLine sl;
            String s;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (s.length() < 1) continue;
            String string = s.substring(0, 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            if (Intrinsics.areEqual(string, "#")) continue;
            String string2 = StratCat.HARD.toString();
            String string3 = s.substring(0, 4);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            if (StringsKt.equals(string2, string3, true)) {
                reading = StratCat.HARD;
                this.hardHeader = s;
                continue;
            }
            String string4 = StratCat.SOFT.toString();
            String string5 = s.substring(0, 4);
            Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
            if (StringsKt.equals(string4, string5, true)) {
                reading = StratCat.SOFT;
                this.softHeader = s;
                continue;
            }
            String string6 = StratCat.SPLIT.toString();
            String string7 = s.substring(0, 5);
            Intrinsics.checkNotNullExpressionValue(string7, "substring(...)");
            if (StringsKt.equals(string6, string7, true)) {
                reading = StratCat.SPLIT;
                this.splitHeader = s;
                continue;
            }
            if (StratCat.HARD == reading) {
                sl = new StrategyLine(StratCat.HARD, s, this.getBlackjackConfiguration());
                Map<StratCat, ? extends Map<String, StrategyLine>> map = this.sls;
                Intrinsics.checkNotNull(map);
                Map<String, StrategyLine> map2 = map.get((Object)StratCat.HARD);
                Intrinsics.checkNotNull(map2);
                map2.put(sl.getKey(), sl);
                continue;
            }
            if (StratCat.SOFT == reading) {
                sl = new StrategyLine(StratCat.SOFT, s, this.getBlackjackConfiguration());
                Map<StratCat, ? extends Map<String, StrategyLine>> map = this.sls;
                Intrinsics.checkNotNull(map);
                Map<String, StrategyLine> map3 = map.get((Object)StratCat.SOFT);
                Intrinsics.checkNotNull(map3);
                map3.put(sl.getKey(), sl);
                continue;
            }
            sl = new StrategyLine(StratCat.SPLIT, s, this.getBlackjackConfiguration());
            Map<StratCat, ? extends Map<String, StrategyLine>> map = this.sls;
            Intrinsics.checkNotNull(map);
            Map<String, StrategyLine> map4 = map.get((Object)StratCat.SPLIT);
            Intrinsics.checkNotNull(map4);
            map4.put(sl.getKey(), sl);
        }
    }

    @Nullable
    public final StrategyLine findStrategyLine(@NotNull Situation s) {
        StrategyLine strategyLine;
        Intrinsics.checkNotNullParameter(s, "s");
        if (s.getHandPlayer() == null) {
            return null;
        }
        StrategyLine rtn2 = null;
        if (this.shouldSplit(s)) {
            rtn2 = this.findSplitStrategyLine(s);
        }
        if (rtn2 != null) {
            return rtn2;
        }
        if (s.getHandPlayer().isSoft()) {
            rtn2 = this.findSoftStrategyLine(s);
        }
        if ((strategyLine = rtn2) == null) {
            strategyLine = this.findHardStrategyLine(s);
        }
        return strategyLine;
    }

    private final boolean shouldSplit(Situation s) {
        if (s.getHandPlayer() == null) {
            return false;
        }
        if (s.getHandPlayer().isInitialDeal() && s.getHandPlayer().isCardFacesSplittable()) {
            int v = s.getHandPlayer().getFirstCard().getHardValue();
            return v != 5 && v != 10;
        }
        return false;
    }

    private final StrategyLine findSplitStrategyLine(Situation s) {
        if (s.getHandPlayer() == null) {
            return null;
        }
        int cv = s.getHandPlayer().getFirstCard().getHardValue();
        Object key = cv + "," + cv;
        if (Intrinsics.areEqual(key, "1,1")) {
            key = "A,A";
        }
        Map<StratCat, Map<String, StrategyLine>> map = this.getStrategyLines();
        Intrinsics.checkNotNull(map);
        Map<String, StrategyLine> map2 = map.get((Object)StratCat.SPLIT);
        Intrinsics.checkNotNull(map2);
        return map2.get(key);
    }

    private final StrategyLine findSoftStrategyLine(Situation s) {
        if (s.getHandPlayer() == null) {
            return null;
        }
        int v = s.getHandPlayer().getHandValue();
        String key = v > 19 ? "20+" : String.valueOf(v);
        Map<StratCat, Map<String, StrategyLine>> map = this.getStrategyLines();
        Intrinsics.checkNotNull(map);
        Map<String, StrategyLine> map2 = map.get((Object)StratCat.SOFT);
        Intrinsics.checkNotNull(map2);
        return map2.get(key);
    }

    private final StrategyLine findHardStrategyLine(Situation s) {
        if (s.getHandPlayer() == null) {
            return null;
        }
        int v = s.getHandPlayer().getHandValue();
        String key = v > 17 ? "18+" : (v < 8 ? "7" : String.valueOf(v));
        Map<StratCat, Map<String, StrategyLine>> map = this.getStrategyLines();
        Intrinsics.checkNotNull(map);
        Map<String, StrategyLine> map2 = map.get((Object)StratCat.HARD);
        Intrinsics.checkNotNull(map2);
        return map2.get(key);
    }

    private final Map<StratCat, Map<String, StrategyLine>> createStrategyLineMap() {
        Map rtn2 = new EnumMap(StratCat.class);
        rtn2.put(StratCat.HARD, new HashMap());
        rtn2.put(StratCat.SOFT, new HashMap());
        rtn2.put(StratCat.SPLIT, new HashMap());
        return rtn2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StratCat.values().length];
            try {
                nArray[StratCat.SOFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StratCat.SPLIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

