/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackConfiguration;
import com.panopset.blackjackEngine.BlackjackGameEngine;
import com.panopset.blackjackEngine.BlackjackMessages;
import com.panopset.blackjackEngine.HandDealer;
import com.panopset.blackjackEngine.HandPlayer;
import com.panopset.blackjackEngine.Player;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/panopset/blackjackEngine/Settlement;", "", "player", "Lcom/panopset/blackjackEngine/Player;", "bge", "Lcom/panopset/blackjackEngine/BlackjackGameEngine;", "msg", "Lcom/panopset/blackjackEngine/BlackjackMessages;", "<init>", "(Lcom/panopset/blackjackEngine/Player;Lcom/panopset/blackjackEngine/BlackjackGameEngine;Lcom/panopset/blackjackEngine/BlackjackMessages;)V", "blackjackPayoff", "", "handDealer", "Lcom/panopset/blackjackEngine/HandDealer;", "blackjackConfiguration", "Lcom/panopset/blackjackEngine/BlackjackConfiguration;", "settlePlayer", "", "settleHand", "handPlayer", "Lcom/panopset/blackjackEngine/HandPlayer;", "settleForEvenMoney", "settleNormalHand", "settleNonBustedHand", "settleNotEuropeanStyleBlackjackHand", "settleNotSurrenderedHand", "blackjackEngine"})
public final class Settlement {
    @NotNull
    private final Player player;
    @NotNull
    private final BlackjackGameEngine bge;
    @NotNull
    private final BlackjackMessages msg;
    private final double blackjackPayoff;
    @NotNull
    private final HandDealer handDealer;
    @NotNull
    private final BlackjackConfiguration blackjackConfiguration;

    public Settlement(@NotNull Player player, @NotNull BlackjackGameEngine bge, @NotNull BlackjackMessages msg) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(bge, "bge");
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.player = player;
        this.bge = bge;
        this.msg = msg;
        this.blackjackConfiguration = this.bge.getConfig();
        this.handDealer = this.bge.getCycle().getDealer();
        this.blackjackPayoff = this.bge.getConfig().isBlackjack6to5() ? 1.2 : 1.5;
    }

    public final void settlePlayer() {
        Iterator<HandPlayer> iterator2 = this.player.getHands().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<HandPlayer> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            HandPlayer handPlayer;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            this.settleHand(handPlayer);
        }
    }

    private final void settleHand(HandPlayer handPlayer) {
        if (handPlayer.isSelectedEvenMoney()) {
            this.settleForEvenMoney(handPlayer);
        } else {
            this.settleNormalHand(handPlayer);
        }
    }

    private final void settleForEvenMoney(HandPlayer handPlayer) {
        this.bge.incrementStreak();
        handPlayer.setMessage(this.msg.getEvenMsg());
        handPlayer.getWager().setInitialPayoff(handPlayer.getWager().getInitialBet());
    }

    private final void settleNormalHand(HandPlayer handPlayer) {
        if (handPlayer.isBusted()) {
            this.bge.setPriorHandBustedFlag();
        } else {
            this.settleNonBustedHand(handPlayer);
        }
    }

    private final void settleNonBustedHand(HandPlayer handPlayer) {
        if (this.handDealer.isNatural21() && this.blackjackConfiguration.isEuropeanStyle()) {
            handPlayer.setMessage(this.msg.getLostMsg());
            handPlayer.getWager().lost();
        } else {
            this.settleNotEuropeanStyleBlackjackHand(handPlayer);
        }
    }

    private final void settleNotEuropeanStyleBlackjackHand(HandPlayer handPlayer) {
        if (handPlayer.isSurrendered()) {
            handPlayer.getWager().lost();
            handPlayer.getWager().setInitialPayoff(handPlayer.getWager().getInitialBet() / 2);
        } else {
            this.settleNotSurrenderedHand(handPlayer);
        }
    }

    private final void settleNotSurrenderedHand(HandPlayer handPlayer) {
        if (handPlayer.getHandValue() == this.handDealer.getHandValue()) {
            if (handPlayer.isNatural21()) {
                this.bge.incrementStreak();
                if (this.handDealer.isNatural21()) {
                    handPlayer.setMessage(this.msg.getPushMsg());
                } else {
                    handPlayer.setMessage(this.msg.getBlackjackMsg());
                    handPlayer.getWager().setInitialPayoff((int)(this.blackjackPayoff * (double)handPlayer.getWager().getInitialBet()));
                }
            } else {
                handPlayer.setMessage(this.msg.getPushMsg());
                this.bge.incrementStreak();
            }
        } else if (this.handDealer.getHandValue() > 21 || handPlayer.getHandValue() > this.handDealer.getHandValue()) {
            this.bge.incrementStreak();
            if (handPlayer.isNatural21()) {
                handPlayer.setMessage(this.msg.getBlackjackMsg());
                handPlayer.getWager().setInitialPayoff((int)(this.blackjackPayoff * (double)handPlayer.getWager().getInitialBet()));
            } else {
                handPlayer.setMessage(this.msg.getWonMsg());
                handPlayer.getWager().setInitialPayoff(handPlayer.getWager().getInitialBet());
                handPlayer.getWager().setDoubledPayoff(handPlayer.getWager().getDoubledBet());
            }
        } else {
            handPlayer.setMessage(this.msg.getLostMsg());
            handPlayer.getWager().lost();
            this.bge.resetStreak();
        }
    }
}

