/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackCard;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013J\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fJ\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0006\u0010\u001e\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020\tJ\u0006\u0010 \u001a\u00020\u001bJ\b\u0010#\u001a\u00020$H\u0016R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\nR\u001a\u0010!\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\n\"\u0004\b\"\u0010\f\u00a8\u0006&"}, d2={"Lcom/panopset/blackjackEngine/Hand;", "", "<init>", "()V", "value", "", "getValue", "()I", "isSoft", "", "()Z", "setSoft", "(Z)V", "cards", "", "Lcom/panopset/blackjackEngine/BlackjackCard;", "getCards", "()Ljava/util/List;", "getIterator", "", "isNatural21", "getHardValueOf", "i", "hasCards", "isInitialDeal", "remove", "dealCard", "", "card", "setValue", "isDone", "isBusted", "stand", "isFinal", "setFinal", "toString", "", "Companion", "blackjackEngine"})
public final class Hand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int value;
    private boolean isSoft;
    @NotNull
    private final List<BlackjackCard> cards = new ArrayList();
    private boolean isFinal;
    public static final int MAX = 21;

    public final int getValue() {
        return this.value;
    }

    public final boolean isSoft() {
        return this.isSoft;
    }

    public final void setSoft(boolean bl) {
        this.isSoft = bl;
    }

    @NotNull
    public final List<BlackjackCard> getCards() {
        return this.cards;
    }

    @NotNull
    public final Iterator<BlackjackCard> getIterator() {
        ArrayList<BlackjackCard> rtn2 = new ArrayList<BlackjackCard>();
        for (BlackjackCard card : this.cards) {
            rtn2.add(card);
        }
        Iterator<BlackjackCard> iterator2 = rtn2.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        return iterator2;
    }

    public final boolean isNatural21() {
        return this.isInitialDeal() && this.value == 21;
    }

    public final int getHardValueOf(int i) {
        return this.cards.get(i).getHardValue();
    }

    public final boolean hasCards() {
        return !((Collection)this.cards).isEmpty();
    }

    public final boolean isInitialDeal() {
        return this.hasCards() && this.cards.size() == 2;
    }

    @NotNull
    public final BlackjackCard remove(int i) {
        return this.cards.remove(i);
    }

    public final void dealCard(@NotNull BlackjackCard card) {
        Intrinsics.checkNotNullParameter(card, "card");
        this.cards.add(card);
        if (this.cards.size() > 1) {
            this.setValue();
        }
    }

    private final void setValue() {
        this.value = 0;
        int margin = 0;
        this.isSoft = false;
        for (BlackjackCard card : this.cards) {
            this.value += card.getHardValue();
            if (!card.isAce()) continue;
            margin += 10;
        }
        while (this.value < 12 && margin > 0) {
            this.value += 10;
            margin -= 10;
            this.isSoft = true;
        }
    }

    public final boolean isDone() {
        return this.isBusted() || this.value == 21;
    }

    public final boolean isBusted() {
        boolean rtn2;
        boolean bl = rtn2 = this.value > 21;
        if (rtn2) {
            this.stand();
        }
        return rtn2;
    }

    public final void stand() {
        this.isFinal = true;
    }

    public final boolean isFinal() {
        return this.isFinal;
    }

    public final void setFinal(boolean bl) {
        this.isFinal = bl;
    }

    @NotNull
    public String toString() {
        StringWriter sw = new StringWriter();
        String string = "*HAND>>* %d: ";
        Object[] objectArray = new Object[]{this.value};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        sw.append(string2);
        boolean firstTime = true;
        for (BlackjackCard card : this.cards) {
            if (firstTime) {
                firstTime = false;
            } else {
                sw.append(" ");
            }
            sw.append(card.toString());
        }
        String string3 = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/panopset/blackjackEngine/Hand$Companion;", "", "<init>", "()V", "MAX", "", "blackjackEngine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

