/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackCard;
import com.panopset.blackjackEngine.Card;
import com.panopset.blackjackEngine.CountingSystems;
import com.panopset.blackjackEngine.Shoe;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0019J\u0006\u0010\u001e\u001a\u00020\u0005J\u0006\u0010\u001f\u001a\u00020\u0005J\u0014\u0010 \u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\u0006\u0010$\u001a\u00020\u001cJ\u0019\u0010%\u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0&\u00a2\u0006\u0002\u0010'J\u000e\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u001cR$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/panopset/blackjackEngine/BlackjackShoe;", "", "<init>", "()V", "value", "", "numberOfDecks", "getNumberOfDecks", "()I", "setNumberOfDecks", "(I)V", "shoe", "Lcom/panopset/blackjackEngine/Shoe;", "getShoe", "()Lcom/panopset/blackjackEngine/Shoe;", "setShoe", "(Lcom/panopset/blackjackEngine/Shoe;)V", "isTheDeckStacked", "", "deal", "Lcom/panopset/blackjackEngine/BlackjackCard;", "isShowing", "countingSystems", "Lcom/panopset/blackjackEngine/CountingSystems;", "show", "", "blackjackCard", "stackTheDeckFromDeckStacker", "", "shuffle", "remaining", "cut", "stackTheDeckFromList", "cards", "", "Lcom/panopset/blackjackEngine/Card;", "dumpStack", "stackTheDeckFromArray", "", "([Ljava/lang/String;)V", "stackTheDeckFromEOLseparatedText", "stackRawData", "blackjackEngine"})
public final class BlackjackShoe {
    @NotNull
    public static final BlackjackShoe INSTANCE = new BlackjackShoe();
    private static int numberOfDecks = 1;
    @NotNull
    private static Shoe shoe = new Shoe(numberOfDecks);

    private BlackjackShoe() {
    }

    public final int getNumberOfDecks() {
        return numberOfDecks;
    }

    public final void setNumberOfDecks(int value) {
        numberOfDecks = value;
        if (shoe.getNumberOfDecks() != value) {
            shoe = new Shoe(numberOfDecks);
        }
    }

    @NotNull
    public final Shoe getShoe() {
        return shoe;
    }

    public final void setShoe(@NotNull Shoe shoe) {
        Intrinsics.checkNotNullParameter(shoe, "<set-?>");
        BlackjackShoe.shoe = shoe;
    }

    public final boolean isTheDeckStacked() {
        return shoe.isTheDeckStacked();
    }

    @NotNull
    public final BlackjackCard deal(boolean isShowing, @NotNull CountingSystems countingSystems) {
        Intrinsics.checkNotNullParameter(countingSystems, "countingSystems");
        BlackjackCard blackjackCard = new BlackjackCard(shoe.deal());
        if (isShowing) {
            blackjackCard.show();
            countingSystems.count(blackjackCard);
        }
        return blackjackCard;
    }

    public final void show(@NotNull BlackjackCard blackjackCard, @NotNull CountingSystems countingSystems) {
        Intrinsics.checkNotNullParameter(blackjackCard, "blackjackCard");
        Intrinsics.checkNotNullParameter(countingSystems, "countingSystems");
        blackjackCard.show();
        countingSystems.count(blackjackCard);
    }

    public final void stackTheDeckFromDeckStacker(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        shoe.stackTheDeckFromDeckStacker(value);
    }

    public final void shuffle() {
        shoe.shuffle();
    }

    public final int remaining() {
        return shoe.remaining();
    }

    public final int cut() {
        return shoe.cut();
    }

    public final void stackTheDeckFromList(@NotNull List<Card> cards) {
        Intrinsics.checkNotNullParameter(cards, "cards");
        shoe.stackTheDeckFromList(cards);
    }

    @NotNull
    public final String dumpStack() {
        return shoe.dumpStack();
    }

    public final void stackTheDeckFromArray(@NotNull String[] cards) {
        Intrinsics.checkNotNullParameter(cards, "cards");
        shoe.stackTheDeckFromArray(cards);
    }

    public final void stackTheDeckFromEOLseparatedText(@NotNull String stackRawData) {
        Intrinsics.checkNotNullParameter(stackRawData, "stackRawData");
        shoe.stackTheDeckFromDeckStacker(stackRawData);
    }
}

