/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.marin.bootstrap;

import com.panopset.compat.Fileop;
import com.panopset.compat.Logz;
import com.panopset.compat.Stringop;
import com.panopset.desk.DeployProperties;
import com.panopset.flywheel.FlywheelBuilder;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0003H\u0002J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/panopset/marin/bootstrap/VersionClassGenerator;", "", "srcDirectory", "", "versionString", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "updateVersion", "", "updatePoms", "updateProject", "project", "updatePom", "pp", "replaceFirstLine", "path", "lineToReplaceContaining", "fullReplacementLine", "updateAppVersionClass", "", "getBuildString", "getVersionString", "Companion", "desk"})
public final class VersionClassGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String srcDirectory;
    @NotNull
    private String versionString;

    public VersionClassGenerator(@NotNull String srcDirectory, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter(srcDirectory, "srcDirectory");
        Intrinsics.checkNotNullParameter(versionString, "versionString");
        this.srcDirectory = srcDirectory;
        this.versionString = versionString;
    }

    private final void updateVersion() {
        if (this.updateAppVersionClass()) {
            this.updatePoms();
        }
    }

    private final void updatePoms() {
        this.updatePom(this.srcDirectory + "/shoring/pom.xml");
        this.updateProject("compat");
        this.updateProject("blackjackEngine");
        this.updateProject("flywheel");
        this.updateProject("fxapp");
        this.updateProject("desk");
        this.updatePom(this.srcDirectory + "/legacy/pom.xml");
    }

    private final void updateProject(String project) {
        String pp = this.srcDirectory + "/shoring/" + project + "/pom.xml";
        this.updatePom(pp);
    }

    private final void updatePom(String pp) {
        System.out.println((Object)("Updating: " + pp));
        String fr = "<version>";
        String tm = "<version>%s</version>";
        String vr = this.getVersionString();
        Object[] objectArray = new Object[]{vr};
        String string = String.format(tm, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        this.replaceFirstLine(pp, fr, string);
    }

    private final void replaceFirstLine(String path, String lineToReplaceContaining, String fullReplacementLine) {
        List<String> strs;
        File file = new File(path);
        List<String> source = Fileop.INSTANCE.readLines(file);
        if (Intrinsics.areEqual(source, strs = Stringop.INSTANCE.replaceFirstLinePreserveIndentation(source, lineToReplaceContaining, fullReplacementLine))) {
            String string = "No changes to %s, skipping...";
            Object[] objectArray = new Object[]{path};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            Logz.INSTANCE.info(string2);
        } else {
            Fileop.INSTANCE.write(strs, file);
            String string = "%s, updated with %s.";
            Object[] objectArray = new Object[]{path, fullReplacementLine};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            Logz.INSTANCE.info(string3);
        }
    }

    private final boolean updateAppVersionClass() {
        File vf = new File(this.srcDirectory + "/shoring/compat/src/main/kotlin/com/panopset/compat/AppVersion.kt");
        if (!vf.getParentFile().exists()) {
            Logz.INSTANCE.errorMsg("Parent directory not found", vf);
            return false;
        }
        String result = new FlywheelBuilder().scriptFilePath(this.srcDirectory + "/../docs/templates/version.tmplt").map("panopset_desk_version", this.getVersionString()).map("panopset_desk_build", this.getBuildString()).construct().exec();
        if (Stringop.INSTANCE.isPopulated(result)) {
            Fileop.INSTANCE.write(result, vf);
        }
        return true;
    }

    private final String getBuildString() {
        String string = new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    private final String getVersionString() {
        return this.versionString;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Companion.main(args2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/panopset/marin/bootstrap/VersionClassGenerator$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "desk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            new VersionClassGenerator(args2[0], new DeployProperties().getPanopsetVersion()).updateVersion();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

