/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.fxapp;

import com.panopset.compat.Fileop;
import com.panopset.compat.Stringop;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.JavaFXapp;
import com.panopset.fxapp.PanComponentFactoryKt;
import java.io.File;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/panopset/fxapp/PanFileSelectorPanel;", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "fxId", "", "<init>", "(Lcom/panopset/fxapp/FxDoc;Ljava/lang/String;)V", "createFile", "Ljava/io/File;", "inputFile", "Ljavafx/scene/control/TextField;", "getInputFile", "()Ljavafx/scene/control/TextField;", "pane", "Ljavafx/scene/layout/HBox;", "getPane", "()Ljavafx/scene/layout/HBox;", "getInitialDirectoryFrom", "path", "clear", "", "fxapp"})
public final class PanFileSelectorPanel {
    @NotNull
    private final TextField inputFile;
    @NotNull
    private final HBox pane;

    public PanFileSelectorPanel(@NotNull FxDoc fxDoc, @NotNull String fxId) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        Intrinsics.checkNotNullParameter(fxId, "fxId");
        this.inputFile = PanComponentFactoryKt.createPanInputTextFieldHGrow(fxDoc, fxId, "Please choose a file.", "Selected file full path.");
        this.pane = new HBox();
        this.pane.getChildren().add(PanComponentFactoryKt.createPanButton(fxDoc, () -> PanFileSelectorPanel._init_$lambda$0(this), "File", false, "Select file."));
        HBox.setHgrow(this.pane, Priority.ALWAYS);
        this.pane.getChildren().add(this.inputFile);
        PanComponentFactoryKt.decorateFileInputTextForMouse(this.inputFile);
    }

    @NotNull
    public final File createFile() {
        return new File(this.inputFile.getText());
    }

    @NotNull
    public final TextField getInputFile() {
        return this.inputFile;
    }

    @NotNull
    public final HBox getPane() {
        return this.pane;
    }

    private final File getInitialDirectoryFrom(String path) {
        File oldFile;
        String string = this.inputFile.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        if (((CharSequence)string).length() > 0 && (oldFile = new File(path)).exists()) {
            File file;
            if (oldFile.isFile()) {
                File file2 = oldFile.getParentFile();
                Intrinsics.checkNotNull(file2);
                file = file2;
            } else {
                file = oldFile;
            }
            return file;
        }
        return new File(Stringop.INSTANCE.getUSH());
    }

    public final void clear() {
        this.inputFile.setText("");
    }

    private static final Unit _init_$lambda$0(PanFileSelectorPanel this$0) {
        FileChooser fc = new FileChooser();
        String string = this$0.inputFile.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        fc.setInitialDirectory(this$0.getInitialDirectoryFrom(string));
        File file = fc.showOpenDialog(JavaFXapp.INSTANCE.findStage());
        if (file.exists() && file.isFile()) {
            this$0.inputFile.setText(Fileop.INSTANCE.getCanonicalPath(file));
            this$0.inputFile.setTooltip(new Tooltip("Selected file full path."));
        }
        return Unit.INSTANCE;
    }
}

