/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Fileop;
import com.panopset.flywheel.Flywheel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\fJ\u0006\u0010\"\u001a\u00020#J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bJ\u0013\u0010(\u001a\u00020&2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010*\u001a\u00020\u001dH\u0016R\u001a\u0010\r\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010'\u00a8\u0006\t"}, d2={"Lcom/panopset/flywheel/SourceFile;", "", "<init>", "()V", "sourceFile", "Ljava/io/File;", "basePath", "", "(Ljava/io/File;Ljava/lang/String;)V", "flywheel", "Lcom/panopset/flywheel/Flywheel;", "sourceFileRelativePath", "(Lcom/panopset/flywheel/Flywheel;Ljava/lang/String;)V", "relativePath", "getRelativePath", "()Ljava/lang/String;", "setRelativePath", "(Ljava/lang/String;)V", "file", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "canonicalPath", "getCanonicalPath", "setCanonicalPath", "sourceLines", "", "value", "", "depth", "getDepth", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "reset", "", "getTheSourceLines", "isValid", "", "()Z", "equals", "other", "hashCode"})
public final class SourceFile {
    public String relativePath;
    public File file;
    public String canonicalPath;
    @NotNull
    private List<String> sourceLines;
    @Nullable
    private Integer depth;

    public SourceFile() {
        this.sourceLines = new ArrayList();
    }

    @NotNull
    public final String getRelativePath() {
        String string = this.relativePath;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("relativePath");
        return null;
    }

    public final void setRelativePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.relativePath = string;
    }

    @NotNull
    public final File getFile() {
        File file = this.file;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException("file");
        return null;
    }

    public final void setFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "<set-?>");
        this.file = file;
    }

    @NotNull
    public final String getCanonicalPath() {
        String string = this.canonicalPath;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("canonicalPath");
        return null;
    }

    public final void setCanonicalPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.canonicalPath = string;
    }

    @Nullable
    public final Integer getDepth() {
        if (this.depth == null) {
            this.depth = 0;
            String temp = this.getRelativePath();
            int idx = StringsKt.indexOf$default((CharSequence)temp, "/", 0, false, 6, null);
            while (idx > -1) {
                Integer n = this.depth;
                Intrinsics.checkNotNull(n);
                this.depth = n + 1;
                Intrinsics.checkNotNullExpressionValue(temp.substring(idx + 1), "substring(...)");
                idx = StringsKt.indexOf$default((CharSequence)temp, "/", 0, false, 6, null);
            }
        }
        return this.depth;
    }

    public final void reset() {
        this.sourceLines = new ArrayList();
    }

    @NotNull
    public final List<String> getTheSourceLines() {
        if (this.sourceLines.isEmpty()) {
            this.sourceLines = Fileop.INSTANCE.readLines(this.getFile());
        }
        return this.sourceLines;
    }

    public SourceFile(@NotNull File sourceFile, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        this();
        this.setFile(sourceFile);
        this.setCanonicalPath(Fileop.INSTANCE.getCanonicalPath(this.getFile()));
        String string = this.getCanonicalPath().substring(basePath.length() + 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        this.setRelativePath(string);
    }

    public SourceFile(@NotNull Flywheel flywheel2, @NotNull String sourceFileRelativePath) {
        Intrinsics.checkNotNullParameter(flywheel2, "flywheel");
        Intrinsics.checkNotNullParameter(sourceFileRelativePath, "sourceFileRelativePath");
        this();
        this.setRelativePath(sourceFileRelativePath);
        this.setFile(new File(flywheel2.getBaseDirectoryPath() + "/" + this.getRelativePath()));
        this.setCanonicalPath(Fileop.INSTANCE.getCanonicalPath(this.getFile()));
    }

    public final boolean isValid() {
        return this.getFile().exists() && this.getFile().canRead();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(other.getClass(), this.getClass())) {
            return false;
        }
        SourceFile test = (SourceFile)other;
        return Intrinsics.areEqual(this.getCanonicalPath(), test.getCanonicalPath()) && Intrinsics.areEqual(this.getRelativePath(), test.getRelativePath());
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }
}

