/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.flywheel.Command;
import com.panopset.flywheel.CommandFile;
import com.panopset.flywheel.FlywheelException;
import com.panopset.flywheel.ImpliedQuit;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/panopset/flywheel/ImpliedQuitFilter;", "", "<init>", "()V", "addImpliedQuits", "", "Lcom/panopset/flywheel/Command;", "commands", "insertImpliedQuitBefore", "", "command", "flywheel"})
public final class ImpliedQuitFilter {
    @NotNull
    public final List<Command> addImpliedQuits(@NotNull List<? extends Command> commands) {
        Intrinsics.checkNotNullParameter(commands, "commands");
        List rtn2 = new ArrayList();
        Command first = null;
        boolean checkOnce = false;
        for (Command command : commands) {
            if (first == null) {
                first = command;
            }
            if (command instanceof CommandFile) {
                this.insertImpliedQuitBefore(command);
                command.getTemplate().setCommandFile((CommandFile)command);
            }
            if (command.getNext() != null || command.getTemplate().getCommandFile() == null) continue;
            if (checkOnce) {
                throw new FlywheelException("Structure error.");
            }
            ImpliedQuit iq = new ImpliedQuit(command.getTemplate());
            command.setNext(iq);
            iq.setPrev(command);
            checkOnce = true;
        }
        for (Command command = first; command != null; command = command.getNext()) {
            rtn2.add(command);
        }
        return rtn2;
    }

    private final void insertImpliedQuitBefore(Command command) {
        if (command.getTemplate().getCommandFile() == null) {
            return;
        }
        ImpliedQuit iq = new ImpliedQuit(command.getTemplate());
        iq.setNext(command);
        if (command.getPrev() != null) {
            iq.setPrev(command.getPrev());
            Command command2 = command.getPrev();
            Intrinsics.checkNotNull(command2);
            command2.setNext(iq);
        }
    }
}

