/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.compat.Logz;
import com.panopset.flywheel.Flywheel;
import com.panopset.flywheel.FlywheelException;
import com.panopset.flywheel.ReflectionInvoker;
import com.panopset.flywheel.Template;
import com.panopset.flywheel.TemplateDirectiveCommand;
import com.panopset.flywheel.TemplateLine;
import java.io.StringWriter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/panopset/flywheel/CommandExecute;", "Lcom/panopset/flywheel/TemplateDirectiveCommand;", "templateLine", "Lcom/panopset/flywheel/TemplateLine;", "innerPiece", "", "template", "Lcom/panopset/flywheel/Template;", "<init>", "(Lcom/panopset/flywheel/TemplateLine;Ljava/lang/String;Lcom/panopset/flywheel/Template;)V", "resolve", "", "sw", "Ljava/io/StringWriter;", "Companion", "flywheel"})
public final class CommandExecute
extends TemplateDirectiveCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String shortHtmlText = "${&#064; capitalize(name)}";
    @Nullable
    private static Flywheel flywheel;

    public CommandExecute(@NotNull TemplateLine templateLine, @NotNull String innerPiece, @NotNull Template template) {
        Intrinsics.checkNotNullParameter(templateLine, "templateLine");
        Intrinsics.checkNotNullParameter(innerPiece, "innerPiece");
        Intrinsics.checkNotNullParameter(template, "template");
        super(templateLine, innerPiece, template);
    }

    @Override
    public void resolve(@NotNull StringWriter sw) {
        Intrinsics.checkNotNullParameter(sw, "sw");
        flywheel = this.getTemplate().getFlywheel();
        try {
            String str = this.getParams();
            int incr = StringsKt.lastIndexOf$default((CharSequence)str, ".", 0, false, 6, null);
            if (incr > -1) {
                String string = str.substring(0, incr);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                String key = string;
                Object obj = this.getTemplate().getFlywheel().getRegisteredObjects().get(key);
                if (obj != null) {
                    ReflectionInvoker.Builder builder = new ReflectionInvoker.Builder(this.getTemplate().getFlywheel()).objx(obj);
                    String string2 = str.substring(incr + 1);
                    Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                    sw.append(builder.methodAndParms(string2).mapProvider(this.getTemplate().getFlywheel()).construct().exec(this.getTemplate().getFlywheel()));
                    return;
                }
            }
            String rtn2 = new ReflectionInvoker.Builder(this.getTemplate().getFlywheel()).classMethodAndParms(this.getParams()).mapProvider(this.getTemplate().getFlywheel()).construct().exec(this.getTemplate().getFlywheel());
            String string = "%s %s: %s";
            Object[] objectArray = new Object[]{this.getTemplate().getTemplateSource().getName(), this.getTemplateLine().toString(), rtn2};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            Logz.INSTANCE.debug(string3);
            sw.append(rtn2);
        }
        catch (FlywheelException ex) {
            Logz.INSTANCE.errorEx(ex);
            Logz.INSTANCE.warn(this.getTemplate().getRelativePath());
            if (this.getTemplate().getCommandFile() != null) {
                Logz.INSTANCE.warn("Output file: " + this.getTemplate().getCommandFile());
                Logz.INSTANCE.warn("source: " + this.getTemplateLine());
            }
            Flywheel flywheel2 = this.getTemplate().getFlywheel();
            String string = ex.getMessage();
            if (string == null) {
                string = "Unexpected error, if your pull request is accepted, we'll send you 1000 currently worthless Panopset shares.";
            }
            flywheel2.stop(string);
            String string4 = "Failure executing %s.";
            Object[] objectArray = new Object[]{this.getTemplateLine()};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
            String errorMessage = string5;
            this.getTemplate().getFlywheel().stop(errorMessage);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0006"}, d2={"Lcom/panopset/flywheel/CommandExecute$Companion;", "", "<init>", "()V", "shortHtmlText", "", "flywheel", "Lcom/panopset/flywheel/Flywheel;", "getFlywheel", "()Lcom/panopset/flywheel/Flywheel;", "setFlywheel", "(Lcom/panopset/flywheel/Flywheel;)V"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Flywheel getFlywheel() {
            return flywheel;
        }

        public final void setFlywheel(@Nullable Flywheel flywheel2) {
            flywheel = flywheel2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

