/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.flywheel;

import com.panopset.flywheel.Command;
import com.panopset.flywheel.CommandExecute;
import com.panopset.flywheel.CommandFile;
import com.panopset.flywheel.CommandList;
import com.panopset.flywheel.CommandMap;
import com.panopset.flywheel.CommandPush;
import com.panopset.flywheel.CommandQuit;
import com.panopset.flywheel.CommandRaw;
import com.panopset.flywheel.CommandReplace;
import com.panopset.flywheel.CommandTplt;
import com.panopset.flywheel.CommandUnkown;
import com.panopset.flywheel.CommandVariable;
import com.panopset.flywheel.Commands;
import com.panopset.flywheel.Syntax;
import com.panopset.flywheel.Template;
import com.panopset.flywheel.TemplateDirectiveCommand;
import com.panopset.flywheel.TemplateLine;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/panopset/flywheel/CommandBuilder;", "", "<init>", "()V", "template", "Lcom/panopset/flywheel/Template;", "templateLine", "Lcom/panopset/flywheel/TemplateLine;", "closeDirectiveLoc", "", "command", "Lcom/panopset/flywheel/Command;", "commandTemplate", "source", "newCloseDirectiveLoc", "newCommand", "construct", "flywheel"})
public final class CommandBuilder {
    private Template template;
    private TemplateLine templateLine;
    private int closeDirectiveLoc;
    @Nullable
    private Command command;

    @NotNull
    public final CommandBuilder template(@NotNull Template commandTemplate) {
        Intrinsics.checkNotNullParameter(commandTemplate, "commandTemplate");
        this.template = commandTemplate;
        return this;
    }

    @NotNull
    public final CommandBuilder source(@NotNull TemplateLine templateLine, int newCloseDirectiveLoc) {
        Intrinsics.checkNotNullParameter(templateLine, "templateLine");
        this.templateLine = templateLine;
        this.closeDirectiveLoc = newCloseDirectiveLoc;
        return this;
    }

    @NotNull
    public final CommandBuilder command(@NotNull Command newCommand) {
        Intrinsics.checkNotNullParameter(newCommand, "newCommand");
        this.command = newCommand;
        return this;
    }

    @NotNull
    public final Command construct() {
        TemplateDirectiveCommand templateDirectiveCommand;
        Command rtn2 = null;
        TemplateLine templateLine = this.templateLine;
        if (templateLine == null) {
            Intrinsics.throwUninitializedPropertyAccessException("templateLine");
            templateLine = null;
        }
        String line = templateLine.getLine();
        TemplateLine templateLine2 = this.templateLine;
        if (templateLine2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("templateLine");
            templateLine2 = null;
        }
        int ln = templateLine2.getTemplateLineNumber();
        TemplateLine templateLine3 = this.templateLine;
        if (templateLine3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("templateLine");
            templateLine3 = null;
        }
        int tci = templateLine3.getTemplateCharIndex();
        String string = line.substring(Syntax.getOpenDirective().length(), this.closeDirectiveLoc);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        String innerPiece = string;
        CharSequence charSequence = innerPiece;
        String string2 = Syntax.getDirective();
        Intrinsics.checkNotNullExpressionValue(string2, "getDirective(...)");
        if (StringsKt.indexOf$default(charSequence, string2, 0, false, 6, null) == 0 && innerPiece.length() > 1) {
            char cmd;
            String string3 = innerPiece.substring(1, 2);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            char c = cmd = string3.charAt(0);
            if (c == Commands.FILE.getCharCode()) {
                TemplateLine templateLine4 = new TemplateLine(line, tci, ln);
                Template template = this.template;
                if (template == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("template");
                    template = null;
                }
                templateDirectiveCommand = new CommandFile(templateLine4, innerPiece, template);
            } else if (c == Commands.PUSH.getCharCode()) {
                Template template;
                TemplateLine templateLine5 = this.templateLine;
                if (templateLine5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("templateLine");
                    templateLine5 = null;
                }
                if ((template = this.template) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("template");
                    template = null;
                }
                templateDirectiveCommand = new CommandPush(templateLine5, innerPiece, template);
            } else if (c == Commands.REPLACE.getCharCode()) {
                Template template;
                TemplateLine templateLine6 = this.templateLine;
                if (templateLine6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("templateLine");
                    templateLine6 = null;
                }
                if ((template = this.template) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("template");
                    template = null;
                }
                templateDirectiveCommand = new CommandReplace(templateLine6, innerPiece, template);
            } else if (c == Commands.LIST.getCharCode()) {
                Template template;
                TemplateLine templateLine7 = this.templateLine;
                if (templateLine7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("templateLine");
                    templateLine7 = null;
                }
                if ((template = this.template) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("template");
                    template = null;
                }
                templateDirectiveCommand = new CommandList(templateLine7, innerPiece, template);
            } else if (c == Commands.QUIT.getCharCode()) {
                Template template;
                TemplateLine templateLine8 = this.templateLine;
                if (templateLine8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("templateLine");
                    templateLine8 = null;
                }
                if ((template = this.template) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("template");
                    template = null;
                }
                templateDirectiveCommand = new CommandQuit(templateLine8, template);
            } else if (c == Commands.TEMPLATE.getCharCode()) {
                Template template;
                TemplateLine templateLine9 = this.templateLine;
                if (templateLine9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("templateLine");
                    templateLine9 = null;
                }
                if ((template = this.template) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("template");
                    template = null;
                }
                templateDirectiveCommand = new CommandTplt(templateLine9, innerPiece, template);
            } else if (c == Commands.EXECUTE.getCharCode()) {
                Template template;
                TemplateLine templateLine10 = this.templateLine;
                if (templateLine10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("templateLine");
                    templateLine10 = null;
                }
                if ((template = this.template) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("template");
                    template = null;
                }
                templateDirectiveCommand = new CommandExecute(templateLine10, innerPiece, template);
            } else if (c == Commands.RAW.getCharCode()) {
                Template template;
                TemplateLine templateLine11 = this.templateLine;
                if (templateLine11 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("templateLine");
                    templateLine11 = null;
                }
                if ((template = this.template) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("template");
                    template = null;
                }
                templateDirectiveCommand = new CommandRaw(templateLine11, innerPiece, template);
            } else if (c == Commands.MAP.getCharCode()) {
                Template template;
                TemplateLine templateLine12 = this.templateLine;
                if (templateLine12 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("templateLine");
                    templateLine12 = null;
                }
                if ((template = this.template) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("template");
                    template = null;
                }
                templateDirectiveCommand = new CommandMap(templateLine12, innerPiece, template);
            } else {
                Template template;
                TemplateLine templateLine13 = this.templateLine;
                if (templateLine13 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("templateLine");
                    templateLine13 = null;
                }
                if ((template = this.template) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("template");
                    template = null;
                }
                templateDirectiveCommand = new CommandUnkown(templateLine13, innerPiece, template);
            }
        } else {
            Template template;
            TemplateLine templateLine14 = this.templateLine;
            if (templateLine14 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("templateLine");
                templateLine14 = null;
            }
            if ((template = this.template) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("template");
                template = null;
            }
            return new CommandVariable(templateLine14, innerPiece, template);
        }
        rtn2 = templateDirectiveCommand;
        return rtn2;
    }
}

