/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities.fwtabs;

import com.panopset.compat.FileFunKt;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanComponentFactoryKt;
import com.panopset.fxapp.PanFileOrDirSelectorPanel;
import java.io.File;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/panopset/desk/utilities/fwtabs/TabLineRemover;", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "<init>", "(Lcom/panopset/fxapp/FxDoc;)V", "getFxDoc", "()Lcom/panopset/fxapp/FxDoc;", "lrFileOrDirSelect", "Lcom/panopset/fxapp/PanFileOrDirSelectorPanel;", "lrRemoveLinesButton", "Ljavafx/scene/control/Button;", "lrSearchCriteria", "Ljavafx/scene/control/TextArea;", "createTab", "Ljavafx/scene/control/Tab;", "createTopVBox", "Ljavafx/scene/layout/VBox;", "doUpdate", "", "desk"})
public final class TabLineRemover {
    @NotNull
    private final FxDoc fxDoc;
    private PanFileOrDirSelectorPanel lrFileOrDirSelect;
    private Button lrRemoveLinesButton;
    private TextArea lrSearchCriteria;

    public TabLineRemover(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.fxDoc = fxDoc;
    }

    @NotNull
    public final FxDoc getFxDoc() {
        return this.fxDoc;
    }

    @NotNull
    public final Tab createTab() {
        this.lrFileOrDirSelect = new PanFileOrDirSelectorPanel(this.fxDoc, "lr_file_or_dir_select");
        this.lrRemoveLinesButton = PanComponentFactoryKt.createPanButton(this.fxDoc, () -> TabLineRemover.createTab$lambda$0(this), "Remove lines", false, "Please ensure everything is backed up, this is irreversible.");
        this.lrSearchCriteria = PanComponentFactoryKt.createPersistentPanTextArea(this.fxDoc, "lr_search_criteria", "Text to search for, to determine which lines get deleted, go here.", "It is a good idea to back everything up before proceeding.");
        Tab rtn2 = FontManagerFX.INSTANCE.registerTab(new Tab("Line Remover"));
        BorderPane bp = new BorderPane();
        bp.setTop(this.createTopVBox());
        TextArea textArea = this.lrSearchCriteria;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lrSearchCriteria");
            textArea = null;
        }
        bp.setCenter(PanComponentFactoryKt.createPanScrollPane(textArea));
        rtn2.setContent(bp);
        return rtn2;
    }

    private final VBox createTopVBox() {
        VBox rtn2 = new VBox();
        ObservableList<Node> observableList = rtn2.getChildren();
        Node[] nodeArray = new Node[2];
        PanFileOrDirSelectorPanel panFileOrDirSelectorPanel = this.lrFileOrDirSelect;
        if (panFileOrDirSelectorPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lrFileOrDirSelect");
            panFileOrDirSelectorPanel = null;
        }
        nodeArray[0] = panFileOrDirSelectorPanel.getPane();
        Button button = this.lrRemoveLinesButton;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lrRemoveLinesButton");
            button = null;
        }
        nodeArray[1] = button;
        observableList.add(PanComponentFactoryKt.createPanHBox(nodeArray));
        rtn2.getChildren().add(PanComponentFactoryKt.createPanLabel("USE WITH CAUTION, clicking Remove Lines is irreversible."));
        return rtn2;
    }

    private final void doUpdate() {
        PanFileOrDirSelectorPanel panFileOrDirSelectorPanel = this.lrFileOrDirSelect;
        if (panFileOrDirSelectorPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lrFileOrDirSelect");
            panFileOrDirSelectorPanel = null;
        }
        File file = panFileOrDirSelectorPanel.createFile();
        TextArea textArea = this.lrSearchCriteria;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lrSearchCriteria");
            textArea = null;
        }
        String string = textArea.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        FileFunKt.deleteLines(file, string);
    }

    private static final Unit createTab$lambda$0(TabLineRemover this$0) {
        this$0.doUpdate();
        return Unit.INSTANCE;
    }
}

