/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities.fwtabs;

import com.panopset.compat.ByLineFilter;
import com.panopset.compat.Logz;
import com.panopset.compat.Stringop;
import com.panopset.compat.Transformer;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanComponentFactoryKt;
import com.panopset.fxapp.PanFileOrDirSelectorPanel;
import com.panopset.gp.GlobalReplaceProcessor;
import com.panopset.gp.PriorAndReplacementLineMustContainFilter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J8\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001f2\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001fH\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/panopset/desk/utilities/fwtabs/TabGlobalReplace;", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "<init>", "(Lcom/panopset/fxapp/FxDoc;)V", "getFxDoc", "()Lcom/panopset/fxapp/FxDoc;", "grDirOrFileSelect", "Lcom/panopset/fxapp/PanFileOrDirSelectorPanel;", "grFromText", "Ljavafx/scene/control/TextArea;", "grToText", "grFromStrings", "grToStrings", "grExtensions", "Ljavafx/scene/control/TextField;", "grRegex", "grPriorLineMustContain", "grReplacementLineMustContain", "createTab", "Ljavafx/scene/control/Tab;", "createMainBox", "Ljavafx/scene/layout/VBox;", "doReplaceAll", "", "createByLineFilter", "Lcom/panopset/compat/ByLineFilter;", "searchList", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "replaceList", "doReplaceAllFiles", "byLineFilter", "doReplaceAllTextFields", "desk"})
public final class TabGlobalReplace {
    @NotNull
    private final FxDoc fxDoc;
    private PanFileOrDirSelectorPanel grDirOrFileSelect;
    private TextArea grFromText;
    private TextArea grToText;
    private TextArea grFromStrings;
    private TextArea grToStrings;
    private TextField grExtensions;
    private TextField grRegex;
    private TextField grPriorLineMustContain;
    private TextField grReplacementLineMustContain;

    public TabGlobalReplace(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.fxDoc = fxDoc;
    }

    @NotNull
    public final FxDoc getFxDoc() {
        return this.fxDoc;
    }

    @NotNull
    public final Tab createTab() {
        this.grDirOrFileSelect = new PanFileOrDirSelectorPanel(this.fxDoc, "grdirselect");
        this.grFromStrings = PanComponentFactoryKt.createPersistentPanTextArea(this.fxDoc, "fxidFromStrings", "Strings to replace.", "List of Strings to replace.");
        this.grToStrings = PanComponentFactoryKt.createPersistentPanTextArea(this.fxDoc, "fxidToStrings", "Replacement Strings.", "List of replacement Strings.");
        this.grFromText = PanComponentFactoryKt.createPersistentPanTextArea(this.fxDoc, "fxidFromText", "Input text.", "Input text, if file or directory is not selected.");
        this.grToText = PanComponentFactoryKt.createPanTextArea("Output text.", "Output text, if file or directory is not selected.");
        this.grExtensions = PanComponentFactoryKt.createPanInputTextFieldHGrow(this.fxDoc, "fxidExtensions", "Only select files with these comma separated extensions.", "Leave out the leading period, for example \"java,kt\".");
        this.grRegex = PanComponentFactoryKt.createPanInputTextFieldHGrow(this.fxDoc, "fxidRegex", "Use this regex to select files.", "File extension selection is ignored, if this field is filled out.");
        this.grPriorLineMustContain = PanComponentFactoryKt.createPanInputTextFieldHGrow(this.fxDoc, "fxidPriorLineMustContain", "Enter text that the prior line must contain.", "Text that the prior line must contain, if replacement is to be done.");
        this.grReplacementLineMustContain = PanComponentFactoryKt.createPanInputTextFieldHGrow(this.fxDoc, "fxidReplacementLineMustContain", "Enter text that the replacement line must contain.", "Text that the replacement line must contain, if replacement is to be done.");
        Tab rtn2 = FontManagerFX.INSTANCE.registerTab(new Tab("Global Replace"));
        BorderPane bp = new BorderPane();
        bp.setCenter(this.createMainBox());
        rtn2.setContent(bp);
        return rtn2;
    }

    private final VBox createMainBox() {
        TextArea textArea;
        TextArea textArea2;
        Node[] nodeArray = new Node[9];
        PanFileOrDirSelectorPanel panFileOrDirSelectorPanel = this.grDirOrFileSelect;
        if (panFileOrDirSelectorPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grDirOrFileSelect");
            panFileOrDirSelectorPanel = null;
        }
        nodeArray[0] = panFileOrDirSelectorPanel.getPane();
        Node[] nodeArray2 = new Node[2];
        Node node = this.grFromStrings;
        if (node == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grFromStrings");
            node = nodeArray2[0] = null;
        }
        if ((textArea2 = this.grToStrings) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grToStrings");
            textArea2 = null;
        }
        nodeArray2[1] = textArea2;
        nodeArray[1] = PanComponentFactoryKt.createPanHBox(nodeArray2);
        nodeArray2 = new Node[2];
        Node node2 = this.grFromText;
        if (node2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grFromText");
            node2 = nodeArray2[0] = null;
        }
        if ((textArea = this.grToText) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grToText");
            textArea = null;
        }
        nodeArray2[1] = textArea;
        nodeArray[2] = PanComponentFactoryKt.createPanHBox(nodeArray2);
        nodeArray2 = new Node[2];
        nodeArray2[0] = PanComponentFactoryKt.createPanButton(this.fxDoc, () -> TabGlobalReplace.createMainBox$lambda$0(this), "Replace all", false, "Please make sure everything is backed up first, there is no going back.");
        TextField textField = this.grExtensions;
        if (textField == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grExtensions");
            textField = null;
        }
        nodeArray2[1] = textField;
        nodeArray[3] = PanComponentFactoryKt.createPanHBox(nodeArray2);
        TextField textField2 = this.grRegex;
        if (textField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grRegex");
            textField2 = null;
        }
        nodeArray[4] = textField2;
        nodeArray[5] = PanComponentFactoryKt.createPanLabel("Prior line must contain:");
        nodeArray2 = new Node[1];
        TextField textField3 = this.grPriorLineMustContain;
        if (textField3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grPriorLineMustContain");
            textField3 = null;
        }
        nodeArray2[0] = textField3;
        nodeArray[6] = PanComponentFactoryKt.createPanHBox(nodeArray2);
        nodeArray[7] = PanComponentFactoryKt.createPanLabel("Replacement lines must contain:");
        nodeArray2 = new Node[1];
        TextField textField4 = this.grReplacementLineMustContain;
        if (textField4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grReplacementLineMustContain");
            textField4 = null;
        }
        nodeArray2[0] = textField4;
        nodeArray[8] = PanComponentFactoryKt.createPanHBox(nodeArray2);
        return PanComponentFactoryKt.createPanVBox(nodeArray);
    }

    private final void doReplaceAll() {
        TextArea textArea = this.grFromStrings;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grFromStrings");
            textArea = null;
        }
        String string = textArea.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        ArrayList<String> searchList = Stringop.INSTANCE.stringToList(string);
        TextArea textArea2 = this.grToStrings;
        if (textArea2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grToStrings");
            textArea2 = null;
        }
        String string2 = textArea2.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        ArrayList<String> replaceList = Stringop.INSTANCE.stringToList(string2);
        ByLineFilter byLineFilter = this.createByLineFilter(searchList, replaceList);
        PanFileOrDirSelectorPanel panFileOrDirSelectorPanel = this.grDirOrFileSelect;
        if (panFileOrDirSelectorPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grDirOrFileSelect");
            panFileOrDirSelectorPanel = null;
        }
        if (panFileOrDirSelectorPanel.isPopulated()) {
            this.doReplaceAllFiles(byLineFilter);
        }
        this.doReplaceAllTextFields(byLineFilter);
    }

    private final ByLineFilter createByLineFilter(ArrayList<String> searchList, ArrayList<String> replaceList) {
        TextField textField = this.grPriorLineMustContain;
        if (textField == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grPriorLineMustContain");
            textField = null;
        }
        String priorLineMustContain = textField.getText();
        TextField textField2 = this.grReplacementLineMustContain;
        if (textField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grReplacementLineMustContain");
            textField2 = null;
        }
        String replacementLineMustContain = textField2.getText();
        Intrinsics.checkNotNull(priorLineMustContain);
        Intrinsics.checkNotNull(replacementLineMustContain);
        return new PriorAndReplacementLineMustContainFilter(priorLineMustContain, replacementLineMustContain, searchList, replaceList);
    }

    private final void doReplaceAllFiles(ByLineFilter byLineFilter) {
        PanFileOrDirSelectorPanel panFileOrDirSelectorPanel = this.grDirOrFileSelect;
        if (panFileOrDirSelectorPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grDirOrFileSelect");
            panFileOrDirSelectorPanel = null;
        }
        File file = panFileOrDirSelectorPanel.createFile();
        TextField textField = this.grExtensions;
        if (textField == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grExtensions");
            textField = null;
        }
        String string = textField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        PanFileOrDirSelectorPanel panFileOrDirSelectorPanel2 = this.grDirOrFileSelect;
        if (panFileOrDirSelectorPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grDirOrFileSelect");
            panFileOrDirSelectorPanel2 = null;
        }
        GlobalReplaceProcessor te = new GlobalReplaceProcessor(file, string, panFileOrDirSelectorPanel2.isRecursive());
        try {
            te.process(byLineFilter);
        }
        catch (IOException e) {
            Logz.INSTANCE.errorEx(e);
        }
    }

    private final void doReplaceAllTextFields(ByLineFilter byLineFilter) {
        StringWriter sw = new StringWriter();
        Transformer transformer = new Transformer().withByLineFilter(byLineFilter);
        TextArea textArea = this.grFromText;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grFromText");
            textArea = null;
        }
        transformer.process(new StringReader(textArea.getText()), sw);
        Platform.runLater(() -> TabGlobalReplace.doReplaceAllTextFields$lambda$1(this, sw));
    }

    private static final Unit createMainBox$lambda$0(TabGlobalReplace this$0) {
        this$0.doReplaceAll();
        return Unit.INSTANCE;
    }

    private static final void doReplaceAllTextFields$lambda$1(TabGlobalReplace this$0, StringWriter $sw) {
        TextArea textArea = this$0.grToText;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grToText");
            textArea = null;
        }
        textArea.setText($sw.toString());
    }
}

