/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities.chisel;

import com.panopset.compat.ChecksumFunKt;
import com.panopset.compat.NetworkInfo;
import com.panopset.desk.utilities.chisel.LastCommand;
import com.panopset.fxapp.FxDoc;
import com.panopset.fxapp.PanComponentFactoryKt;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J(\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0018H\u0002J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/panopset/desk/utilities/chisel/ChiselPane;", "", "fxDoc", "Lcom/panopset/fxapp/FxDoc;", "<init>", "(Lcom/panopset/fxapp/FxDoc;)V", "outputTA", "Ljavafx/scene/control/TextArea;", "verboseCheckBox", "Ljavafx/scene/control/CheckBox;", "lastCommand", "Lcom/panopset/desk/utilities/chisel/LastCommand;", "createPane", "Ljavafx/scene/layout/BorderPane;", "createControlPane", "Ljavafx/scene/layout/HBox;", "generateNetworkInfo", "", "generateEnvironmentInfo", "generateSystemInfo", "genEnvInfo", "", "genSysInfo", "sortMap", "", "map", "sortProperties", "props", "Ljava/util/Properties;", "desk"})
@SourceDebugExtension(value={"SMAP\nChiselPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChiselPane.kt\ncom/panopset/desk/utilities/chisel/ChiselPane\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class ChiselPane {
    @NotNull
    private final FxDoc fxDoc;
    private TextArea outputTA;
    private CheckBox verboseCheckBox;
    @NotNull
    private LastCommand lastCommand;

    public ChiselPane(@NotNull FxDoc fxDoc) {
        Intrinsics.checkNotNullParameter(fxDoc, "fxDoc");
        this.fxDoc = fxDoc;
        this.lastCommand = LastCommand.NET;
    }

    @NotNull
    public final BorderPane createPane() {
        this.outputTA = PanComponentFactoryKt.createPanTextArea();
        this.verboseCheckBox = PanComponentFactoryKt.createPanCheckBox(this.fxDoc, "chiselVBCB", "Verbose", "Expand acronyms in the output.");
        CheckBox checkBox = this.verboseCheckBox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException("verboseCheckBox");
            checkBox = null;
        }
        checkBox.setOnAction(arg_0 -> ChiselPane.createPane$lambda$0(this, arg_0));
        BorderPane bp = new BorderPane();
        bp.setTop(this.createControlPane());
        TextArea textArea = this.outputTA;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("outputTA");
            textArea = null;
        }
        bp.setCenter(PanComponentFactoryKt.createPanScrollPane(textArea));
        return bp;
    }

    private final HBox createControlPane() {
        Node[] nodeArray = new Node[4];
        CheckBox checkBox = this.verboseCheckBox;
        if (checkBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException("verboseCheckBox");
            checkBox = null;
        }
        nodeArray[0] = checkBox;
        nodeArray[1] = PanComponentFactoryKt.createPanButton(this.fxDoc, () -> ChiselPane.createControlPane$lambda$2(this), "Network", false, "");
        nodeArray[2] = PanComponentFactoryKt.createPanButton(this.fxDoc, () -> ChiselPane.createControlPane$lambda$4(this), "Environment", false, "");
        nodeArray[3] = PanComponentFactoryKt.createPanButton(this.fxDoc, () -> ChiselPane.createControlPane$lambda$6(this), "System", false, "");
        HBox cp = PanComponentFactoryKt.createPanHBox(nodeArray);
        return cp;
    }

    private final void generateNetworkInfo() {
        Platform.runLater(() -> ChiselPane.generateNetworkInfo$lambda$7(this));
        this.lastCommand = LastCommand.NET;
    }

    private final void generateEnvironmentInfo() {
        Platform.runLater(() -> ChiselPane.generateEnvironmentInfo$lambda$8(this));
        this.lastCommand = LastCommand.ENV;
    }

    private final void generateSystemInfo() {
        Platform.runLater(() -> ChiselPane.generateSystemInfo$lambda$9(this));
        this.lastCommand = LastCommand.SYS;
    }

    private final String genEnvInfo() {
        StringWriter sw = new StringWriter();
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, "getenv(...)");
        for (Map.Entry<String, String> e : this.sortMap(map).entrySet()) {
            CheckBox checkBox = this.verboseCheckBox;
            if (checkBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException("verboseCheckBox");
                checkBox = null;
            }
            StringWriter stringWriter = checkBox.isSelected() ? sw.append("key: " + e.getKey() + " value: " + e.getValue() + "\n") : sw.append(e.getKey() + ": " + e.getValue() + "\n");
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final String genSysInfo() {
        StringWriter sw = new StringWriter();
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue(properties, "getProperties(...)");
        for (Map.Entry<String, String> e : this.sortProperties(properties).entrySet()) {
            StringWriter stringWriter;
            CheckBox checkBox = this.verboseCheckBox;
            if (checkBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException("verboseCheckBox");
                checkBox = null;
            }
            if (checkBox.isSelected()) {
                if (Intrinsics.areEqual(e.getKey(), "line.separator")) {
                    String string = e.getKey();
                    String string2 = e.getValue();
                    byte[] byArray = string2.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                    stringWriter = sw.append("key: " + string + " hex value: " + ChecksumFunKt.convertBytesToHex(byArray) + "\n");
                    continue;
                }
                stringWriter = sw.append("key: " + e.getKey() + ": value: " + e.getValue() + "\n");
                continue;
            }
            stringWriter = sw.append(e.getKey() + ": " + e.getValue() + "\n");
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final Map<String, String> sortMap(Map<String, String> map) {
        SortedMap sortedMap = Collections.synchronizedSortedMap(new TreeMap());
        for (Map.Entry<String, String> e : map.entrySet()) {
            Intrinsics.checkNotNull(sortedMap);
            ((Map)sortedMap).put(e.getKey(), e.getValue());
        }
        Intrinsics.checkNotNull(sortedMap);
        return sortedMap;
    }

    private final Map<String, String> sortProperties(Properties props) {
        SortedMap sortedMap = Collections.synchronizedSortedMap(new TreeMap());
        for (Map.Entry e : ((Map)props).entrySet()) {
            Intrinsics.checkNotNull(sortedMap);
            ((Map)sortedMap).put(e.getKey().toString(), e.getValue().toString());
        }
        Intrinsics.checkNotNull(sortedMap);
        return sortedMap;
    }

    private static final void createPane$lambda$0(ChiselPane this$0, ActionEvent it) {
        switch (WhenMappings.$EnumSwitchMapping$0[this$0.lastCommand.ordinal()]) {
            case 1: {
                this$0.generateNetworkInfo();
                break;
            }
            case 2: {
                this$0.generateEnvironmentInfo();
                break;
            }
            case 3: {
                this$0.generateSystemInfo();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final Unit createControlPane$lambda$2(ChiselPane this$0) {
        ChiselPane $this$createControlPane_u24lambda_u242_u24lambda_u241 = this$0;
        boolean bl = false;
        $this$createControlPane_u24lambda_u242_u24lambda_u241.generateNetworkInfo();
        return Unit.INSTANCE;
    }

    private static final Unit createControlPane$lambda$4(ChiselPane this$0) {
        ChiselPane $this$createControlPane_u24lambda_u244_u24lambda_u243 = this$0;
        boolean bl = false;
        $this$createControlPane_u24lambda_u244_u24lambda_u243.generateEnvironmentInfo();
        return Unit.INSTANCE;
    }

    private static final Unit createControlPane$lambda$6(ChiselPane this$0) {
        ChiselPane $this$createControlPane_u24lambda_u246_u24lambda_u245 = this$0;
        boolean bl = false;
        $this$createControlPane_u24lambda_u246_u24lambda_u245.generateSystemInfo();
        return Unit.INSTANCE;
    }

    private static final void generateNetworkInfo$lambda$7(ChiselPane this$0) {
        CheckBox checkBox;
        TextArea textArea = this$0.outputTA;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("outputTA");
            textArea = null;
        }
        if ((checkBox = this$0.verboseCheckBox) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("verboseCheckBox");
            checkBox = null;
        }
        textArea.setText(NetworkInfo.INSTANCE.createNetSummary(checkBox.isSelected()));
    }

    private static final void generateEnvironmentInfo$lambda$8(ChiselPane this$0) {
        TextArea textArea = this$0.outputTA;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("outputTA");
            textArea = null;
        }
        textArea.setText(this$0.genEnvInfo());
    }

    private static final void generateSystemInfo$lambda$9(ChiselPane this$0) {
        TextArea textArea = this$0.outputTA;
        if (textArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("outputTA");
            textArea = null;
        }
        textArea.setText(this$0.genSysInfo());
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LastCommand.values().length];
            try {
                nArray[LastCommand.NET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LastCommand.ENV.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LastCommand.SYS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

