/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.utilities;

import com.google.gson.reflect.TypeToken;
import com.panopset.compat.AppVersion;
import com.panopset.compat.Fileop;
import com.panopset.compat.Jsonop;
import com.panopset.compat.Propop;
import com.panopset.desk.utilities.GenerateDownloadsTableKt;
import com.panopset.desk.utilities.PlatformDownload;
import com.panopset.desk.utilities.PlatformDownloadCollection;
import com.panopset.marin.secure.checksums.ChecksumType;
import java.io.File;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/panopset/desk/utilities/GenerateDownloadsTable;", "", "<init>", "()V", "createDownloadsTable", "", "path", "createPlatformDownloadMap", "", "Lcom/panopset/desk/utilities/PlatformDownloadCollection;", "loadPropsFor", "Ljava/util/Properties;", "fxArch", "Companion", "desk"})
public final class GenerateDownloadsTable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String createDownloadsTable(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Map<String, PlatformDownloadCollection> platformDownloadMap = this.createPlatformDownloadMap(path);
        StringWriter sw = new StringWriter();
        sw.append("<table>");
        for (Map.Entry<String, PlatformDownloadCollection> e : platformDownloadMap.entrySet()) {
            String platformName = e.getValue().getPlatformName();
            String platformPropertiesFileName = "app" + platformName + ".properties";
            Properties props = Propop.INSTANCE.load(new File(platformPropertiesFileName));
            String string = props.getProperty("PLATFORM_NAME");
            Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
            String platformFullName = StringsKt.replace$default(string, "\"", "", false, 4, null);
            String string2 = props.getProperty("LAUNCH_PATH");
            Intrinsics.checkNotNullExpressionValue(string2, "getProperty(...)");
            String launchPath = StringsKt.replace$default(string2, "\"", "", false, 4, null);
            String string3 = props.getProperty("JAVA_CMD");
            Intrinsics.checkNotNullExpressionValue(string3, "getProperty(...)");
            String javaCmd = StringsKt.replace$default(string3, "\"", "", false, 4, null);
            sw.append("<tr class=\"menuBar\"><td colspan=\"5\"><b>" + platformFullName + "</b></td></tr>\n");
            sw.append("<tr><th>Type</th><th>Download</th><th>Version</th><th>Bytes</th>");
            sw.append("<th>SHA-512</th></tr>");
            boolean firstTime = true;
            for (PlatformDownload platformDownload : e.getValue().getPlatformDownloads()) {
                String artifactType = platformDownload.getArtifactType();
                String artifactName = platformDownload.getArtifactName();
                String relPath = platformDownload.getRelPath();
                String version2 = AppVersion.INSTANCE.getFullVersion();
                String byteCount = platformDownload.getByteCount();
                String sha512 = platformDownload.getSha512();
                sw.append("\n\n<tr><td nowrap>\n");
                sw.append(artifactType);
                sw.append("</td><td nowrap>\n");
                sw.append("<a href=\"/downloads/" + relPath + artifactName + "\">" + artifactName + "</a>");
                sw.append("</td><td>\n");
                sw.append(version2);
                sw.append("</td><td>\n");
                sw.append(byteCount);
                sw.append("</td><td class=\"dsw99\"><input class=\"output2\" type=\"text\" value=\"");
                sw.append(sha512);
                sw.append("\"</input></td></tr>");
                StringWriter stringWriter = firstTime ? sw.append("<tr><td colspan=\"2\"><pre>Launch path:</pre></td><td colspan=\"3\"><pre>" + launchPath + "flywheel</pre></td></tr>") : sw.append("<tr><td colspan=\"2\"><pre>Java command:</pre></td><td colspan=\"3\"><pre>" + javaCmd + " flywheel</pre></td></tr>");
                firstTime = false;
            }
            sw.append("<tr><td colspan=\"5\">&nbsp;</td></tr>");
        }
        sw.append("</table>\n\n");
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final Map<String, PlatformDownloadCollection> createPlatformDownloadMap(String path) {
        SortedMap platformDownloadMap = Collections.synchronizedSortedMap(new TreeMap());
        File tempDirDownloads = new File(path);
        File[] fileArray = tempDirDownloads.listFiles();
        Intrinsics.checkNotNull(fileArray);
        for (File f : fileArray) {
            String sha512;
            String bytes;
            String ifn;
            String fxArch;
            Type mapType2;
            if (!f.isFile()) continue;
            Intrinsics.checkNotNull(f);
            if (!Intrinsics.areEqual(FilesKt.getExtension(f), "json")) continue;
            String artifactType = null;
            Object relPath = "";
            String string = f.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            int i = StringsKt.indexOf$default((CharSequence)string, "OneJar", 0, false, 6, null);
            if (i > -1) {
                String string2;
                artifactType = "jar";
                Intrinsics.checkNotNullExpressionValue(f.getName(), "getName(...)");
                int n = 0;
                String string3 = string2.substring(n, i);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                relPath = string3 + "/";
            } else {
                artifactType = "installer";
            }
            String jsonStr = Fileop.INSTANCE.readTextFile(f);
            Intrinsics.checkNotNullExpressionValue(new TypeToken<HashMap<String, String>>(){}.getType(), "getType(...)");
            HashMap rawMap = (HashMap)new Jsonop().fromJson(jsonStr, mapType2);
            SortedMap map = Collections.synchronizedSortedMap(new TreeMap());
            for (Map.Entry e : ((Map)rawMap).entrySet()) {
                Intrinsics.checkNotNull(map);
                ((Map)map).put(e.getKey(), e.getValue());
            }
            if ((String)map.get("ifn") == null) {
                Intrinsics.checkNotNull(platformDownloadMap);
                return platformDownloadMap;
            }
            if ((String)map.get("fxArch") == null) {
                Intrinsics.checkNotNull(platformDownloadMap);
                return platformDownloadMap;
            }
            Properties archProps = this.loadPropsFor(fxArch);
            String dspOrd = archProps.getProperty("DSPORD");
            if ((String)map.get("bytes") == null) {
                Intrinsics.checkNotNull(platformDownloadMap);
                return platformDownloadMap;
            }
            if ((String)map.get(ChecksumType.SHA512.key) == null) {
                Intrinsics.checkNotNull(platformDownloadMap);
                return platformDownloadMap;
            }
            Intrinsics.checkNotNull(platformDownloadMap);
            SortedSet<PlatformDownload> sortedSet = GenerateDownloadsTableKt.access$addPlatformIfNecessary(fxArch, platformDownloadMap).getPlatformDownloads();
            Intrinsics.checkNotNull(dspOrd);
            sortedSet.add(new PlatformDownload(dspOrd, artifactType, ifn, (String)relPath, bytes, sha512));
        }
        Intrinsics.checkNotNull(platformDownloadMap);
        return platformDownloadMap;
    }

    private final Properties loadPropsFor(String fxArch) {
        File propsFile = new File("app" + fxArch + ".properties");
        if (!propsFile.exists()) {
            throw new RuntimeException(propsFile.getCanonicalPath());
        }
        return Propop.INSTANCE.load(propsFile);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Companion.main(args2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/panopset/desk/utilities/GenerateDownloadsTable$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "desk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter(args2, "args");
            new GenerateDownloadsTable().createDownloadsTable("/var/www/html/downloads");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

