/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.desk.games.bj;

import com.panopset.blackjackEngine.CountingSystems;
import com.panopset.blackjackEngine.DefaultResources;
import com.panopset.compat.Logz;
import com.panopset.compat.Stringop;
import com.panopset.desk.games.bj.BlackjackFxControls;
import com.panopset.fxapp.FontManagerFX;
import com.panopset.fxapp.PanComponentFactoryKt;
import java.util.Arrays;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/panopset/desk/games/bj/TabConfigCounting;", "", "ctls", "Lcom/panopset/desk/games/bj/BlackjackFxControls;", "<init>", "(Lcom/panopset/desk/games/bj/BlackjackFxControls;)V", "getCtls", "()Lcom/panopset/desk/games/bj/BlackjackFxControls;", "createTab", "Ljavafx/scene/control/Tab;", "userReset", "", "defaultCountingSystems", "", "desk"})
public final class TabConfigCounting {
    @NotNull
    private final BlackjackFxControls ctls;
    @NotNull
    private final String defaultCountingSystems;

    public TabConfigCounting(@NotNull BlackjackFxControls ctls) {
        Intrinsics.checkNotNullParameter(ctls, "ctls");
        this.ctls = ctls;
        this.defaultCountingSystems = new DefaultResources().getDefaultCountingSystems();
    }

    @NotNull
    public final BlackjackFxControls getCtls() {
        return this.ctls;
    }

    @NotNull
    public final Tab createTab() {
        Tab rtn2 = FontManagerFX.INSTANCE.registerTab(new Tab("Counting"));
        Node[] nodeArray = new Node[2];
        Node[] nodeArray2 = new Node[6];
        nodeArray2[0] = PanComponentFactoryKt.createPanTitledPane("Counting system", this.ctls.getCbCountingSystems());
        nodeArray2[1] = PanComponentFactoryKt.createPanTitledPane("Positive count large bet trigger", this.ctls.getCountPositive());
        nodeArray2[2] = PanComponentFactoryKt.createPanTitledPane("Negative count bail trigger", this.ctls.getCountNegative());
        nodeArray2[3] = PanComponentFactoryKt.createPanLabel("Set both count triggers to 0, to turn off card counting bet adjustments.");
        nodeArray2[4] = PanComponentFactoryKt.createPanLabel("Counting system simulations work best with one player.");
        Node[] nodeArray3 = new Node[]{PanComponentFactoryKt.createPanButton(this.ctls.getFxDoc(), () -> TabConfigCounting.createTab$lambda$0(this), "Reset to default.", false, ""), PanComponentFactoryKt.createPanLabel("  Counting systems:")};
        nodeArray2[5] = PanComponentFactoryKt.createPanFlowPane(nodeArray3);
        nodeArray[0] = PanComponentFactoryKt.createPanVBox(nodeArray2);
        nodeArray2 = new Node[]{PanComponentFactoryKt.createPanTitledPane("Minimum Bet", this.ctls.getMinimumBet()), PanComponentFactoryKt.createPanTitledPane("Large Bet", this.ctls.getLargeBet()), PanComponentFactoryKt.createPanTitledPane("Target Stake", this.ctls.getTargetStake())};
        nodeArray[1] = PanComponentFactoryKt.createPanVBox(nodeArray2);
        HBox topHbox = PanComponentFactoryKt.createPanHBox(nodeArray);
        topHbox.setSpacing(5.0);
        this.ctls.getTaCountingSystems().setText(this.defaultCountingSystems);
        BorderPane bp = new BorderPane();
        bp.setTop(topHbox);
        bp.setCenter(PanComponentFactoryKt.createPanScrollPane(this.ctls.getTaCountingSystems()));
        rtn2.setContent(bp);
        CountingSystems countingSystems = this.ctls.getBge().getCountingSystems();
        String countingSystemsText = this.ctls.getTaCountingSystems().getText();
        if (!Stringop.INSTANCE.isPopulated(countingSystemsText)) {
            this.userReset(this.ctls);
        }
        PanComponentFactoryKt.setChoiceBoxChoices(this.ctls.getCbCountingSystems(), (List<String>)countingSystems.getKeyNames());
        this.ctls.getCbCountingSystems().getSelectionModel().selectedIndexProperty().addListener((arg_0, arg_1, arg_2) -> TabConfigCounting.createTab$lambda$3((arg_0, arg_1, arg_2) -> TabConfigCounting.createTab$lambda$2(countingSystems, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        this.ctls.getCbCountingSystems().getSelectionModel().select(3);
        return rtn2;
    }

    private final void userReset(BlackjackFxControls ctls) {
        ctls.getTaCountingSystems().setText(this.defaultCountingSystems);
    }

    private static final Unit createTab$lambda$0(TabConfigCounting this$0) {
        this$0.userReset(this$0.ctls);
        return Unit.INSTANCE;
    }

    private static final void createTab$lambda$2$lambda$1(Number $newIndex, CountingSystems $countingSystems) {
        int selectedIndex = $newIndex.intValue();
        $countingSystems.setSystemByKeyNamePosition(selectedIndex);
        String string = "Counting systems updated to %s.";
        Object[] objectArray = new Object[]{$countingSystems.findSelected().getName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        Logz.INSTANCE.info(string2);
    }

    private static final Unit createTab$lambda$2(CountingSystems $countingSystems, ObservableValue observableValue, Number number, Number newIndex) {
        new Thread(() -> TabConfigCounting.createTab$lambda$2$lambda$1(newIndex, $countingSystems)).start();
        return Unit.INSTANCE;
    }

    private static final void createTab$lambda$3(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke(p0, p1, p2);
    }
}

