/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.LogpanKt;
import com.panopset.compat.Stringop;
import com.panopset.compat.SysInfoKt;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/panopset/compat/SysInfo;", "", "<init>", "()V", "map", "Ljava/util/SortedMap;", "", "getMap", "()Ljava/util/SortedMap;", "sortByKeyName", "Ljava/util/Comparator;", "customCompare", "", "a", "b", "toString", "compat"})
public final class SysInfo {
    @NotNull
    public static final SysInfo INSTANCE = new SysInfo();
    @NotNull
    private static final SortedMap<String, String> map;
    @NotNull
    private static final Comparator<String> sortByKeyName;

    private SysInfo() {
    }

    @NotNull
    public final SortedMap<String, String> getMap() {
        return map;
    }

    private final int customCompare(String a, String b) {
        String string = a.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string, "memory", false, 2, null)) {
            String string2 = b.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            if (!StringsKt.contains$default((CharSequence)string2, "memory", false, 2, null)) {
                return -1;
            }
        }
        return a.compareTo(b);
    }

    @NotNull
    public String toString() {
        return SysInfoKt.map2string(MapsKt.toSortedMap((Map)map, sortByKeyName));
    }

    private static final int sortByKeyName$lambda$0(String a, String b) {
        return a == null && b == null ? 0 : (a == null ? -1 : (b == null ? 1 : (((CharSequence)a).length() > 0 && ((CharSequence)b).length() > 0 ? INSTANCE.customCompare(a, b) : 1)));
    }

    static {
        SortedMap sortedMap = Collections.synchronizedSortedMap(new TreeMap());
        Intrinsics.checkNotNullExpressionValue(sortedMap, "synchronizedSortedMap(...)");
        map = sortedMap;
        sortByKeyName = SysInfo::sortByKeyName$lambda$0;
        String name = "Un-able to determine, see log.";
        try {
            name = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LogpanKt.errorExlg(e);
        }
        Runtime runtime = Runtime.getRuntime();
        SysInfoKt.addValueToMapIfExists(map, "HostName", name);
        SysInfoKt.addValueToMapIfExists(map, "Processors", Stringop.INSTANCE.getCommaString(runtime.availableProcessors()));
        SysInfoKt.addValueToMapIfExists(map, "Total memory", Stringop.INSTANCE.getCommaString(runtime.totalMemory()));
        SysInfoKt.addValueToMapIfExists(map, "Max memory", Stringop.INSTANCE.getCommaString(runtime.maxMemory()));
        SysInfoKt.addValueToMapIfExists(map, "Free memory", Stringop.INSTANCE.getCommaString(runtime.freeMemory()));
        SysInfoKt.addSysPropValueToMapIfExists(map, "java.version");
        SysInfoKt.addSysPropValueToMapIfExists(map, "os.name");
        SysInfoKt.addSysPropValueToMapIfExists(map, "sun.os.patch.level");
        SysInfoKt.addSysPropValueToMapIfExists(map, "os.arch");
        SysInfoKt.addSysPropValueToMapIfExists(map, "sun.arch.data.model");
        SysInfoKt.addSysPropValueToMapIfExists(map, "sun.cpu.isalist");
        String string = Locale.getDefault().getLanguage();
        Intrinsics.checkNotNullExpressionValue(string, "getLanguage(...)");
        SysInfoKt.addValueToMapIfExists(map, "Language", string);
    }
}

