/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.Logz;
import com.panopset.compat.Randomop;
import com.panopset.compat.RegexValidator;
import com.panopset.compat.Streamop;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.FileSystems;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b$\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005J.\u0010!\u001a\u00020\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u00052\b\u0010#\u001a\u0004\u0018\u00010\u00052\b\u0010$\u001a\u0004\u0018\u00010\u00052\b\u0010%\u001a\u0004\u0018\u00010\u0005J\u0010\u0010&\u001a\u00020\u00052\b\u0010'\u001a\u0004\u0018\u00010\u0005J\u001f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050+\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005J\u0010\u0010.\u001a\u00020\u00052\b\u0010'\u001a\u0004\u0018\u00010\u0005J\u0018\u0010/\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u00100\u001a\u00020\fJ\u000e\u00101\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005J\u0010\u00102\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0005J\u0010\u00103\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010\u0005J\u0010\u00104\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010\u0005J\u001a\u00105\u001a\u00020\u00052\b\u0010'\u001a\u0004\u0018\u00010\u00052\b\u00106\u001a\u0004\u0018\u00010\u0005J\u0006\u00107\u001a\u00020\u0005J\u000e\u00108\u001a\u0002092\u0006\u0010 \u001a\u00020\u0005J\u0016\u0010:\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\fJ\u0010\u0010<\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u0005J\u001f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050+2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050+\u00a2\u0006\u0002\u0010?J#\u0010@\u001a\u00020\u00052\u0016\u0010A\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050+\"\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010BJ\u0018\u0010@\u001a\u00020\u00052\u0010\u0010C\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010)J\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00050E2\u0006\u0010'\u001a\u00020\u0005J\u0014\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00050E2\u0006\u0010'\u001a\u00020\u0005J\u000e\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020IJ\u000e\u0010J\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\fJ\u000e\u0010J\u001a\u00020\u00052\u0006\u0010 \u001a\u00020IJ\u000e\u0010K\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0005J\u0016\u0010K\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010L\u001a\u00020\fJ\u000e\u0010M\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0005J\u000e\u0010N\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0005J\u0010\u0010O\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u0005J\u0010\u0010P\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0005J\u0010\u0010Q\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0005J\u0006\u0010R\u001a\u00020\u0005J\u001a\u0010S\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010L\u001a\u00020\u001eJ\u000e\u0010T\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0005J\u0016\u0010U\u001a\u00020\u00052\u000e\u0010V\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050)J\"\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u00052\b\u0010Y\u001a\u0004\u0018\u00010\u00052\b\u0010Z\u001a\u0004\u0018\u00010\u0005J \u0010[\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u00052\b\u0010Z\u001a\u0004\u0018\u00010\u0005J.\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00050)2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00050)2\b\u0010]\u001a\u0004\u0018\u00010\u00052\b\u0010^\u001a\u0004\u0018\u00010\u0005J\u0010\u0010_\u001a\u00020\u00052\b\u0010'\u001a\u0004\u0018\u00010\u0005J\u001f\u0010`\u001a\u00020\u00052\u0012\u0010a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050+\"\u00020\u0005\u00a2\u0006\u0002\u0010BJ\u001c\u0010b\u001a\u00020\u00052\b\u0010c\u001a\u0004\u0018\u00010\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0005H\u0007J\u0006\u0010i\u001a\u00020IJ\u0006\u0010j\u001a\u00020\u0005J\u000e\u0010k\u001a\u00020\u00052\u0006\u0010l\u001a\u00020\u0005R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010d\u001a\u00020IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010f\"\u0004\bg\u0010h\u00a8\u0006m"}, d2={"Lcom/panopset/compat/Stringop;", "", "<init>", "()V", "lineTerminator", "", "TAB", "JAVA_RTN", "LINE_SEPARATOR", "getLINE_SEPARATOR", "()Ljava/lang/String;", "LINE_FEED_VALUE", "", "LINE_FEED", "CARRIAGE_RETURN_VALUE", "CARRIAGE_RETURN", "DOS_RTN", "USH", "getUSH", "FSP", "getFSP", "TEMP_DIR_PATH", "getTEMP_DIR_PATH", "LAST_MODIFIED_FORMAT", "TEST", "FOO", "BAR", "BAT", "CS", "isRegexFound", "", "regex", "value", "check4match", "s1", "s2", "r1", "r2", "capund", "str", "arrayToList", "", "strArray", "", "([Ljava/lang/String;)Ljava/util/List;", "upund", "capitalize", "toMaxLength", "max", "toUpperCase", "toLowerCase", "isPopulated", "isEmpty", "pullAfter", "searchStr", "getEol", "setEol", "", "wrapFixedWidth", "width", "countReturns", "trimTrailingEmptyLines", "sa", "([Ljava/lang/String;)[Ljava/lang/String;", "concat", "args", "([Ljava/lang/String;)Ljava/lang/String;", "pts", "stringToList", "Ljava/util/ArrayList;", "stringToListWithEol", "getDollarString", "pennies", "", "getCommaString", "parseInt", "defaultValue", "isNumber", "isInteger", "isBlank", "appendEol", "notNull", "randomString", "parseBoolean", "skipComment", "listToString", "list", "replace", "source", "target", "replacement", "replaceAll", "replaceFirstLinePreserveIndentation", "lineToReplaceContaining", "fullReplacementLine", "getIndentation", "appendFilePath", "pathElements", "firstHexDiff", "expected", "id", "getId", "()J", "setId", "(J)V", "getNextJvmUniqueID", "getNextJvmUniqueIDstr", "trimSurroundingQuotes", "s", "compat"})
@SourceDebugExtension(value={"SMAP\nStringop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Stringop.kt\ncom/panopset/compat/Stringop\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,437:1\n108#2:438\n80#2,22:439\n108#2:463\n80#2,22:464\n37#3,2:461\n*S KotlinDebug\n*F\n+ 1 Stringop.kt\ncom/panopset/compat/Stringop\n*L\n110#1:438\n110#1:439,22\n267#1:463\n267#1:464,22\n186#1:461,2\n*E\n"})
public final class Stringop {
    @NotNull
    public static final Stringop INSTANCE = new Stringop();
    @Nullable
    private static String lineTerminator;
    @NotNull
    public static final String TAB = "\t";
    @NotNull
    public static final String JAVA_RTN = "\n";
    @NotNull
    private static final String LINE_SEPARATOR;
    public static final int LINE_FEED_VALUE = 10;
    @NotNull
    public static final String LINE_FEED = "\n";
    public static final int CARRIAGE_RETURN_VALUE = 13;
    @NotNull
    public static final String CARRIAGE_RETURN = "\r";
    @NotNull
    public static final String DOS_RTN = "\r\n";
    @NotNull
    private static final String USH;
    @NotNull
    private static final String FSP;
    @NotNull
    private static final String TEMP_DIR_PATH;
    @NotNull
    public static final String LAST_MODIFIED_FORMAT = "EEEE, MMMM dd, yyyy, h:mm a(zz)";
    @NotNull
    public static final String TEST = "test";
    @NotNull
    public static final String FOO = "foo";
    @NotNull
    public static final String BAR = "bar";
    @NotNull
    public static final String BAT = "bat";
    @NotNull
    public static final String CS = "%s:%s";
    private static long id;

    private Stringop() {
    }

    @NotNull
    public final String getLINE_SEPARATOR() {
        return LINE_SEPARATOR;
    }

    @NotNull
    public final String getUSH() {
        return USH;
    }

    @NotNull
    public final String getFSP() {
        return FSP;
    }

    @NotNull
    public final String getTEMP_DIR_PATH() {
        return TEMP_DIR_PATH;
    }

    public final boolean isRegexFound(@NotNull String regex, @NotNull String value) {
        Intrinsics.checkNotNullParameter(regex, "regex");
        Intrinsics.checkNotNullParameter(value, "value");
        return new RegexValidator(regex).matches(value);
    }

    @NotNull
    public final String check4match(@Nullable String s1, @Nullable String s2, @Nullable String r1, @Nullable String r2) {
        if (s1 == null || s2 == null || r1 == null || r2 == null) {
            return "";
        }
        return Intrinsics.areEqual(s1, s2) ? r1 : r2;
    }

    @NotNull
    public final String capund(@Nullable String str) {
        CharSequence charSequence = str;
        if (!(charSequence == null || charSequence.length() == 0)) {
            CharSequence charSequence2 = str;
            Regex regex = new Regex("()([A-Z])");
            String string = "$1_$2";
            charSequence2 = regex.replace(charSequence2, string);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string2 = ((String)charSequence2).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            String rtn2 = string2;
            if (rtn2.charAt(0) == '_') {
                String string3 = rtn2.substring(1);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                rtn2 = string3;
            }
            return rtn2;
        }
        return "";
    }

    @NotNull
    public final List<String> arrayToList(@NotNull String[] strArray) {
        Intrinsics.checkNotNullParameter(strArray, "strArray");
        ArrayList<String> rtn2 = new ArrayList<String>();
        for (String s : strArray) {
            rtn2.add(s);
        }
        return rtn2;
    }

    @NotNull
    public final String upund(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        CharSequence charSequence = str;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string = charSequence.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        charSequence = string;
        Regex regex = new Regex(" ");
        String string2 = "_";
        return regex.replace(charSequence, string2);
    }

    @NotNull
    public final String capitalize(@Nullable String str) {
        Object object;
        if (str != null && str.length() > 0) {
            if (str.length() > 1) {
                String string = "" + str.charAt(0);
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string2 = string.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                String string3 = str.substring(1);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                object = string2 + string3;
            } else {
                String string = str;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string4 = string.toUpperCase(locale);
                object = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
            }
        } else {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String toMaxLength(@Nullable String value, int max) {
        String string;
        if (value == null) {
            return "";
        }
        if (max < 1) {
            return "";
        }
        if (value.length() > max) {
            String string2 = value.substring(0, max);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        } else {
            string = value;
        }
        return string;
    }

    @NotNull
    public final String toUpperCase(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        String string = value;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        return string2;
    }

    @NotNull
    public final String toLowerCase(@Nullable String value) {
        String string;
        block3: {
            block2: {
                string = value;
                if (string == null) break block2;
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                string = string3;
                if (string3 != null) break block3;
            }
            string = "";
        }
        return string;
    }

    public final boolean isPopulated(@Nullable String str) {
        return !this.isEmpty(str);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmpty(@Nullable String str) {
        void $this$trim$iv;
        if (str == null) return true;
        String string = str;
        String string2 = "";
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (!Intrinsics.areEqual(string2, ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) return false;
        return true;
    }

    @NotNull
    public final String pullAfter(@Nullable String str, @Nullable String searchStr) {
        String string;
        if (str == null || searchStr == null) {
            return "";
        }
        if (str.length() < searchStr.length()) {
            return "";
        }
        int i = StringsKt.indexOf$default((CharSequence)str, searchStr, 0, false, 6, null);
        if (i == -1) {
            string = "";
        } else {
            String string2 = str.substring(i + searchStr.length());
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        }
        return string;
    }

    @NotNull
    public final String getEol() {
        String string;
        if (lineTerminator == null) {
            lineTerminator = "\n";
        }
        if ((string = lineTerminator) == null) {
            string = "\n";
        }
        return string;
    }

    public final void setEol(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        lineTerminator = value;
    }

    @NotNull
    public final String wrapFixedWidth(@NotNull String str, int width) {
        Intrinsics.checkNotNullParameter(str, "str");
        if (!this.isPopulated(str)) {
            return "";
        }
        if (width < 1) {
            return str;
        }
        if (str.length() < width) {
            return str;
        }
        StringWriter sw = new StringWriter();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            sw.append(str.charAt(i));
            if ((i + 1) % width != 0) continue;
            sw.append(this.getEol());
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public final int countReturns(@Nullable String str) {
        if (str == null) {
            return 0;
        }
        int count = 0;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch != '\n') continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public final String[] trimTrailingEmptyLines(@NotNull String[] sa) {
        Intrinsics.checkNotNullParameter(sa, "sa");
        ArrayList<String> rtn2 = new ArrayList<String>();
        int size = sa.length - 1;
        int n = sa.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            String s = sa[i];
            if (index >= size && !this.isPopulated(s)) continue;
            rtn2.add(s);
        }
        Collection $this$toTypedArray$iv = rtn2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @NotNull
    public final String concat(String ... args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        return this.concat(Arrays.asList(Arrays.copyOf(args2, args2.length)));
    }

    @NotNull
    public final String concat(@Nullable List<String> pts) {
        if (pts == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        for (String s : pts) {
            if (s == null) continue;
            sw.append(s);
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final ArrayList<String> stringToList(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        return Streamop.INSTANCE.getLinesFromReader(new StringReader(str));
    }

    @NotNull
    public final ArrayList<String> stringToListWithEol(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        return Streamop.INSTANCE.getLinesFromReaderWithEol(new StringReader(str));
    }

    @NotNull
    public final String getDollarString(long pennies) {
        String string = NumberFormat.getCurrencyInstance().format(new BigDecimal(pennies).setScale(2, RoundingMode.HALF_UP).divide(new BigDecimal(100), RoundingMode.HALF_UP));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    @NotNull
    public final String getCommaString(int value) {
        String string = NumberFormat.getNumberInstance().format((Object)value);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    @NotNull
    public final String getCommaString(long value) {
        String string = NumberFormat.getNumberInstance().format(value);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    public final int parseInt(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return !this.isPopulated(value) ? 0 : this.parseInt(value, 0);
    }

    public final int parseInt(@NotNull String value, int defaultValue) {
        int n;
        Intrinsics.checkNotNullParameter(value, "value");
        if (((CharSequence)value).length() > 0) {
            int n2;
            String str = StringsKt.replace$default(value, ",", "", false, 4, null);
            try {
                n2 = Integer.parseInt(str);
            }
            catch (NumberFormatException nfe) {
                Logz.INSTANCE.errorMsg(value, (Throwable)nfe);
                n2 = defaultValue;
            }
            n = n2;
        } else {
            n = defaultValue;
        }
        return n;
    }

    public final boolean isNumber(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        CharSequence charSequence = value;
        return new Regex("[0-9]*").matches(charSequence);
    }

    public final boolean isInteger(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        CharSequence charSequence = value;
        return new Regex("-?\\d+").matches(charSequence);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBlank(@Nullable String value) {
        CharSequence charSequence;
        if (value == null) return true;
        String string = "";
        String $this$trim$iv = value;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (!string.contentEquals(charSequence = (CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) return false;
        return true;
    }

    @NotNull
    public final String appendEol(@Nullable String value) {
        String string = "%s%s";
        Object[] objectArray = new Object[]{value, this.getEol()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public final String notNull(@Nullable String value) {
        String string = value;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String randomString() {
        String string = "%d";
        Object[] objectArray = new Object[]{Randomop.INSTANCE.nextLong()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    public final boolean parseBoolean(@Nullable String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String string = "on";
        String string2 = value;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        if (string.contentEquals(string3)) {
            return true;
        }
        string = "yes";
        string2 = value;
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
        String string4 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
        if (string.contentEquals(string4)) {
            return true;
        }
        string = "y";
        string2 = value;
        Locale locale3 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale3, "getDefault(...)");
        String string5 = string2.toLowerCase(locale3);
        Intrinsics.checkNotNullExpressionValue(string5, "toLowerCase(...)");
        return string.contentEquals(string5) ? true : Boolean.parseBoolean(value);
    }

    public static /* synthetic */ boolean parseBoolean$default(Stringop stringop, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return stringop.parseBoolean(string, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean skipComment(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!this.isPopulated(value)) {
            return true;
        }
        String string = value.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        if (Intrinsics.areEqual("#", string)) {
            return true;
        }
        if (value.length() <= 1) return false;
        String string2 = value.substring(0, 2);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        if (!Intrinsics.areEqual("//", string2)) return false;
        return true;
    }

    @NotNull
    public final String listToString(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        StringWriter sw = new StringWriter();
        for (String s : list) {
            sw.append(s);
            sw.append(this.getEol());
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String replace(@NotNull String source, @Nullable String target, @Nullable String replacement) {
        Intrinsics.checkNotNullParameter(source, "source");
        String string = target;
        Intrinsics.checkNotNull(string);
        String string2 = replacement;
        Intrinsics.checkNotNull(string2);
        return StringsKt.replace$default(source, string, string2, false, 4, null);
    }

    @NotNull
    public final String replaceAll(@NotNull String source, @NotNull String target, @Nullable String replacement) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        CharSequence charSequence = source;
        Regex regex = new Regex(target);
        String string = replacement;
        Intrinsics.checkNotNull(string);
        String string2 = string;
        return regex.replace(charSequence, string2);
    }

    @NotNull
    public final List<String> replaceFirstLinePreserveIndentation(@NotNull List<String> source, @Nullable String lineToReplaceContaining, @Nullable String fullReplacementLine) {
        Intrinsics.checkNotNullParameter(source, "source");
        boolean firstTime = true;
        String priorIndentation = "";
        List rtn2 = new ArrayList();
        for (String str : source) {
            if (firstTime) {
                CharSequence charSequence = str;
                String string = lineToReplaceContaining;
                Intrinsics.checkNotNull(string);
                if (StringsKt.contains$default(charSequence, string, false, 2, null)) {
                    firstTime = false;
                    String string2 = "%s%s";
                    Object[] objectArray = new Object[]{priorIndentation, fullReplacementLine};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                    rtn2.add(string3);
                    continue;
                }
                rtn2.add(str);
                priorIndentation = this.getIndentation(str);
                continue;
            }
            rtn2.add(str);
        }
        return rtn2;
    }

    @NotNull
    public final String getIndentation(@Nullable String str) {
        if (str == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) {
                String string = sw.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                return string;
            }
            sw.append(str.charAt(i));
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String appendFilePath(String ... pathElements) {
        Intrinsics.checkNotNullParameter(pathElements, "pathElements");
        StringWriter sw = new StringWriter();
        boolean firstTime = true;
        for (String pathElement : pathElements) {
            if (firstTime) {
                sw.append(pathElement);
                firstTime = false;
                continue;
            }
            if (StringsKt.indexOf$default((CharSequence)pathElement, FSP, 0, false, 6, null) != 0) {
                sw.append(FSP);
            }
            sw.append(pathElement);
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String firstHexDiff(@Nullable String expected, @Nullable String value) {
        if (value == null) {
            return "value is null";
        }
        if (expected == null) {
            return "expected is null";
        }
        if (value.length() == 0) {
            return "value is empty";
        }
        if (expected.length() == 0) {
            return "expected is empty";
        }
        System.out.println((Object)"Comparing expected, to value:");
        System.out.println((Object)expected);
        System.out.println((Object)value);
        if (value.length() != expected.length()) {
            String string = "Expected length is %d and value length is %d";
            Object[] objectArray = new Object[]{expected.length(), value.length()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            return string2;
        }
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c1;
            char c0 = expected.charAt(i);
            if (c0 == (c1 = value.charAt(i))) continue;
            String string = "At position %d, expected %s, but was %s";
            Object[] objectArray = new Object[3];
            objectArray[0] = i;
            String string3 = "%04x";
            Object[] objectArray2 = new Object[]{(int)c0};
            Intrinsics.checkNotNullExpressionValue(String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length)), "format(...)");
            string3 = "%04x";
            objectArray2 = new Object[]{(int)c1};
            Intrinsics.checkNotNullExpressionValue(String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length)), "format(...)");
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            return string4;
        }
        return "values are identical";
    }

    public final long getId() {
        return id;
    }

    public final void setId(long l) {
        id = l;
    }

    public final long getNextJvmUniqueID() {
        long l = id;
        id = l + 1L;
        return l;
    }

    @NotNull
    public final String getNextJvmUniqueIDstr() {
        return String.valueOf(this.getNextJvmUniqueID());
    }

    @NotNull
    public final String trimSurroundingQuotes(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        if (s.length() < 2) {
            return s;
        }
        String string = s.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        if (Intrinsics.areEqual(string, "\"")) {
            String string2 = s.substring(1);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String t = string2;
            int i = t.length();
            String string3 = t.substring(i - 1, i);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            if (Intrinsics.areEqual(string3, "\"")) {
                String string4 = t.substring(0, i - 1);
                Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                return string4;
            }
        }
        return s;
    }

    static {
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue(string, "lineSeparator(...)");
        LINE_SEPARATOR = string;
        String string2 = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue(string2, "getProperty(...)");
        USH = string2;
        String string3 = FileSystems.getDefault().getSeparator();
        Intrinsics.checkNotNullExpressionValue(string3, "getSeparator(...)");
        FSP = string3;
        TEMP_DIR_PATH = USH + FSP + "tmp";
    }
}

