/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.AddrInfo;
import com.panopset.compat.NetInt;
import com.panopset.compat.NetworkInfoKt;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\tH\u0016J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/panopset/compat/NetworkInfo;", "", "<init>", "()V", "netInts", "Ljava/util/ArrayList;", "Lcom/panopset/compat/NetInt;", "Lkotlin/collections/ArrayList;", "maca", "", "getMaca", "()Ljava/lang/String;", "setMaca", "(Ljava/lang/String;)V", "netSummary", "getNetSummary", "setNetSummary", "netVerbose", "getNetVerbose", "setNetVerbose", "toString", "createNetSummary", "verbose", "", "compat"})
public final class NetworkInfo {
    @NotNull
    public static final NetworkInfo INSTANCE = new NetworkInfo();
    @NotNull
    private static final ArrayList<NetInt> netInts = new ArrayList();
    @NotNull
    private static String maca = "";
    @NotNull
    private static String netSummary = "";
    @NotNull
    private static String netVerbose = "";

    private NetworkInfo() {
    }

    @NotNull
    public final String getMaca() {
        return maca;
    }

    public final void setMaca(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        maca = string;
    }

    @NotNull
    public final String getNetSummary() {
        return netSummary;
    }

    public final void setNetSummary(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        netSummary = string;
    }

    @NotNull
    public final String getNetVerbose() {
        return netVerbose;
    }

    public final void setNetVerbose(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        netVerbose = string;
    }

    @NotNull
    public String toString() {
        return this.createNetSummary(false);
    }

    @NotNull
    public final String createNetSummary(boolean verbose) {
        if (verbose) {
            if (((CharSequence)netVerbose).length() > 0) {
                return netVerbose;
            }
        } else if (((CharSequence)netSummary).length() > 0) {
            return netSummary;
        }
        StringWriter sw = new StringWriter();
        Iterator<NetInt> iterator2 = netInts.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<NetInt> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Iterator<AddrInfo> iterator4;
            NetInt netInt;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (((CharSequence)netInt.getMaca()).length() > 0) {
                StringWriter stringWriter = verbose ? sw.append("Network Interface Card (NIC) Medium Access Control MAC Address, \n: Flywheel variable com.panopset.MACAddress: " + netInt.getMaca() + "\n") : sw.append("Flywheel variable com.panopset.MACAddress: " + netInt.getMaca() + "\n");
                maca = netInt.getMaca();
            }
            sw.append(netInt.getName());
            if (verbose) {
                sw.append(", loop back: " + netInt.isLoopBack());
                sw.append(", point to point: " + netInt.isPointToPoint());
            }
            Intrinsics.checkNotNullExpressionValue(netInt.getAddrInfos().iterator(), "iterator(...)");
            while (iterator4.hasNext()) {
                AddrInfo addInfo;
                Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                sw.append("\n");
                sw.append(addInfo.getIpAddress());
            }
            sw.append("\n\n");
        }
        if (verbose) {
            netVerbose = sw.toString();
        } else {
            netSummary = sw.toString();
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    static {
        Iterator iterator2 = NetworkInterface.networkInterfaces().iterator();
        while (iterator2.hasNext()) {
            NetInt netInt;
            NetworkInterface ni = (NetworkInterface)iterator2.next();
            if (ni.getHardwareAddress() == null) {
                String string = ni.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                netInt = new NetInt("", string, ni.isLoopback(), ni.isPointToPoint());
            } else {
                byte[] byArray = ni.getHardwareAddress();
                Intrinsics.checkNotNullExpressionValue(byArray, "getHardwareAddress(...)");
                String string = NetworkInfoKt.convertBytesToHumanReadableColon(byArray);
                String string2 = ni.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                netInt = new NetInt(string, string2, ni.isLoopback(), ni.isPointToPoint());
            }
            NetInt netInt2 = netInt;
            Enumeration<InetAddress> enumeration = ni.getInetAddresses();
            Intrinsics.checkNotNullExpressionValue(enumeration, "getInetAddresses(...)");
            Iterator<InetAddress> iterator3 = CollectionsKt.iterator(enumeration);
            while (iterator3.hasNext()) {
                boolean bl;
                InetAddress inetAddress = iterator3.next();
                if (inetAddress.getAddress().length == 4) {
                    ArrayList<AddrInfo> arrayList = netInt2.getAddrInfos();
                    byte[] byArray = inetAddress.getAddress();
                    Intrinsics.checkNotNullExpressionValue(byArray, "getAddress(...)");
                    bl = arrayList.add(new AddrInfo(NetworkInfoKt.convertBytesToHumanReadableIP4(byArray)));
                    continue;
                }
                ArrayList<AddrInfo> arrayList = netInt2.getAddrInfos();
                byte[] byArray = inetAddress.getAddress();
                Intrinsics.checkNotNullExpressionValue(byArray, "getAddress(...)");
                bl = arrayList.add(new AddrInfo(NetworkInfoKt.convertBytesToHumanReadableColon4(byArray)));
            }
            netInts.add(netInt2);
        }
        INSTANCE.createNetSummary(false);
    }
}

