/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.compat;

import com.panopset.compat.LogEntryKt;
import com.panopset.compat.LogopAlert;
import java.util.Date;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/panopset/compat/LogEntry;", "", "alert", "Lcom/panopset/compat/LogopAlert;", "level", "Ljava/util/logging/Level;", "message", "", "<init>", "(Lcom/panopset/compat/LogopAlert;Ljava/util/logging/Level;Ljava/lang/String;)V", "getAlert", "()Lcom/panopset/compat/LogopAlert;", "getLevel", "()Ljava/util/logging/Level;", "getMessage", "()Ljava/lang/String;", "timestamp", "Ljava/util/Date;", "getTimestamp", "()Ljava/util/Date;", "toString", "compat"})
public final class LogEntry {
    @NotNull
    private final LogopAlert alert;
    @NotNull
    private final Level level;
    @NotNull
    private final String message;
    @NotNull
    private final Date timestamp;

    public LogEntry(@NotNull LogopAlert alert, @NotNull Level level, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)alert, "alert");
        Intrinsics.checkNotNullParameter(level, "level");
        Intrinsics.checkNotNullParameter(message, "message");
        this.alert = alert;
        this.level = level;
        this.message = message;
        this.timestamp = new Date();
    }

    @NotNull
    public final LogopAlert getAlert() {
        return this.alert;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final Date getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String toString() {
        return this.message + " " + this.alert + " " + LogEntryKt.getTimestampFormat().format(this.timestamp);
    }
}

